/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx.cgl.awt;

import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.awt.Java2D;
import com.sun.opengl.impl.awt.Java2DGLContext;
import com.sun.opengl.impl.macosx.cgl.MacOSXCGLContext;
import com.sun.opengl.impl.macosx.cgl.MacOSXPbufferCGLContext;
import java.awt.Graphics;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXJava2DCGLContext
extends MacOSXCGLContext
implements Java2DGLContext {
    private Graphics graphics;

    public MacOSXJava2DCGLContext(GLContext gLContext) {
        super(null, gLContext);
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    protected int makeCurrentImpl() throws GLException {
        boolean bl = false;
        if (this.nsContext == 0L) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println("!!! Created GL nsContext for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!Java2D.makeOGLContextCurrentOnSurface(this.graphics, this.nsContext)) {
            throw new GLException("Error making context current");
        }
        if (bl) {
            this.setGLFunctionAvailability(false);
            return 2;
        }
        return 1;
    }

    protected boolean create() {
        long l;
        MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (macOSXCGLContext != null) {
            if (macOSXCGLContext instanceof MacOSXPbufferCGLContext) {
                MacOSXPbufferCGLContext macOSXPbufferCGLContext = (MacOSXPbufferCGLContext)macOSXCGLContext;
                macOSXPbufferCGLContext.setOpenGLMode(2);
            } else if (macOSXCGLContext.getOpenGLMode() != 2) {
                throw new GLException("Can't share between NSOpenGLContexts and CGLContextObjs");
            }
            l2 = macOSXCGLContext.getNSContext();
        }
        if (DEBUG) {
            System.err.println("!!! Share context is " + MacOSXJava2DCGLContext.toHexString(l2) + " for " + this.getClass().getName());
        }
        if ((l = Java2D.createOGLContextOnSurface(this.graphics, l2)) == 0L) {
            return false;
        }
        this.nsContext = l;
        return true;
    }

    protected void releaseImpl() throws GLException {
    }

    protected void destroyImpl() throws GLException {
        if (this.nsContext != 0L) {
            Java2D.destroyOGLContext(this.nsContext);
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.nsContext);
            }
            this.nsContext = 0L;
        }
    }

    public void setOpenGLMode(int n) {
        if (n != 2) {
            throw new GLException("OpenGL mode switching not supported for Java2D GLContexts");
        }
    }

    public int getOpenGLMode() {
        return 2;
    }
}

