/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11.glx.awt;

import com.sun.nativewindow.impl.jawt.x11.X11SunJDKReflection;
import com.sun.nativewindow.impl.x11.X11Util;
import com.sun.opengl.impl.Debug;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLException;

public class X11AWTGLXGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");

    public X11AWTGLXGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(Capabilities capabilities, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        X11GraphicsConfiguration x11GraphicsConfiguration;
        GraphicsConfiguration graphicsConfiguration;
        GraphicsDevice graphicsDevice = null;
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createScreenDevice(-1);
        }
        AWTGraphicsScreen aWTGraphicsScreen = (AWTGraphicsScreen)abstractGraphicsScreen;
        graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        if (capabilities != null && !(capabilities instanceof GLCapabilities)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilitiesChooser objects");
        }
        if (DEBUG) {
            System.err.println("X11AWTGLXGraphicsConfigurationFactory: got " + abstractGraphicsScreen);
        }
        NativeWindowFactory.getDefaultFactory().getToolkitLock().lock();
        try {
            long l = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice);
            if (0L == l) {
                l = X11Util.getThreadLocalDefaultDisplay();
                if (DEBUG) {
                    System.err.println("X11AWTGLXGraphicsConfigurationFactory: using a thread local X11 display");
                }
            } else if (DEBUG) {
                System.err.println("X11AWTGLXGraphicsConfigurationFactory: using AWT X11 display 0x" + Long.toHexString(l));
            }
            ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).setHandle(l);
            X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(l);
            X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, aWTGraphicsScreen.getIndex());
            if (DEBUG) {
                System.err.println("X11AWTGLXGraphicsConfigurationFactory: made " + x11GraphicsScreen);
            }
            graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilities, graphicsConfiguration);
            if (DEBUG) {
                System.err.println("AWT Colormodel compatible: " + capabilities);
            }
            if ((x11GraphicsConfiguration = (X11GraphicsConfiguration)GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)x11GraphicsDevice).chooseGraphicsConfiguration(capabilities, capabilitiesChooser, (AbstractGraphicsScreen)x11GraphicsScreen)) == null) {
                throw new GLException("Unable to choose a GraphicsConfiguration: " + capabilities + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
            }
            long l2 = x11GraphicsConfiguration.getVisualID();
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[i];
                if (graphicsConfiguration2 == null || (long)X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration2) != l2) continue;
                AWTGraphicsConfiguration aWTGraphicsConfiguration = new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration2, (AbstractGraphicsConfiguration)x11GraphicsConfiguration);
                return aWTGraphicsConfiguration;
            }
        }
        finally {
            NativeWindowFactory.getDefaultFactory().getToolkitLock().unlock();
        }
        if (DEBUG) {
            System.err.println("!!! Using default configuration");
        }
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, (AbstractGraphicsConfiguration)x11GraphicsConfiguration);
    }
}

