/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.Interpolator;
import com.sun.scenario.animation.SplineInterpolator;

public class Interpolators {
    private static final Interpolator DISCRETE_INSTANCE = new Discrete();
    private static final Interpolator LINEAR_INSTANCE = new Linear();
    private static final Interpolator EASING_INSTANCE = new Easing(0.2f, 0.2f);

    private Interpolators() {
    }

    public static Interpolator getDiscreteInstance() {
        return DISCRETE_INSTANCE;
    }

    public static Interpolator getLinearInstance() {
        return LINEAR_INSTANCE;
    }

    public static Interpolator getEasingInstance() {
        return EASING_INSTANCE;
    }

    public static Interpolator getEasingInstance(float f, float f2) {
        return new Easing(f, f2);
    }

    public static Interpolator getSplineInstance(float f, float f2, float f3, float f4) {
        return new SplineInterpolator(f, f2, f3, f4);
    }

    private static class Discrete
    implements Interpolator {
        private Discrete() {
        }

        public float interpolate(float f) {
            return f < 1.0f ? 0.0f : 1.0f;
        }
    }

    private static class Easing
    implements Interpolator {
        private float acceleration;
        private float deceleration;

        Easing(float f, float f2) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("Acceleration value cannot lie outside [0,1] range");
            }
            if (f > 1.0f - f2) {
                throw new IllegalArgumentException("Acceleration value cannot be greater than (1 - deceleration)");
            }
            if (f2 < 0.0f || f2 > 1.0f) {
                throw new IllegalArgumentException("Deceleration value cannot lie outside [0,1] range");
            }
            if (f2 > 1.0f - f) {
                throw new IllegalArgumentException("Deceleration value cannot be greater than (1 - acceleration)");
            }
            this.acceleration = f;
            this.deceleration = f2;
        }

        public float interpolate(float f) {
            if (this.acceleration != 0.0f || this.deceleration != 0.0f) {
                float f2 = 1.0f / (1.0f - this.acceleration / 2.0f - this.deceleration / 2.0f);
                if (f < this.acceleration) {
                    float f3 = f2 * (f / this.acceleration) / 2.0f;
                    f *= f3;
                } else if (f > 1.0f - this.deceleration) {
                    float f4 = f - (1.0f - this.deceleration);
                    float f5 = f4 / this.deceleration;
                    f = f2 * (1.0f - this.acceleration / 2.0f - this.deceleration + f4 * (2.0f - f5) / 2.0f);
                } else {
                    f = f2 * (f - this.acceleration / 2.0f);
                }
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
            }
            return f;
        }
    }

    private static class Linear
    implements Interpolator {
        private Linear() {
        }

        public float interpolate(float f) {
            return f;
        }
    }
}

