/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.scenario.animation.Animation;
import com.sun.scenario.animation.AnimationList;
import com.sun.scenario.animation.Clip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RunQueue
extends AnimationList<Clip, RunQueue>
implements Iterable<RunQueue> {
    private Animation.Status status;
    private long pauseTime;

    public RunQueue() {
    }

    private RunQueue(Clip clip, long l) {
        super(clip, l);
        this.status = Animation.Status.SCHEDULED;
    }

    @Override
    protected RunQueue makeEntry(Clip clip, long l) {
        return new RunQueue(clip, l);
    }

    final void adjustStartTime(long l) {
        this.t += l;
    }

    final Animation.Status getStatus() {
        return this.status;
    }

    final synchronized void pause(long l) {
        if (this.status == Animation.Status.SCHEDULED) {
            this.status = Animation.Status.SCHEDULEPAUSED;
        } else if (this.status == Animation.Status.RUNNING) {
            this.status = Animation.Status.PAUSED;
        } else {
            return;
        }
        this.pauseTime = l;
    }

    final synchronized void resume(long l) {
        Animation.Status status;
        if (this.status == Animation.Status.SCHEDULEPAUSED) {
            status = Animation.Status.SCHEDULED;
        } else if (this.status == Animation.Status.PAUSED) {
            status = Animation.Status.RUNNING;
        } else {
            return;
        }
        this.adjustStartTime(l - this.pauseTime);
        this.status = status;
    }

    final synchronized void stop(long l) {
        if (this.status == Animation.Status.PAUSED) {
            this.adjustStartTime(l - this.pauseTime);
        }
        this.status = Animation.Status.STOPPED;
    }

    final synchronized Animation.Status began() {
        if (this.status == Animation.Status.SCHEDULED) {
            this.status = Animation.Status.RUNNING;
        } else if (this.status == Animation.Status.SCHEDULEPAUSED) {
            this.status = Animation.Status.PAUSED;
        }
        return this.status;
    }
}

