/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.Interpolator;

class SplineInterpolator
implements Interpolator {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;
    private final boolean isCurveLinear;
    private static final int SAMPLE_SIZE = 16;
    private static final float SAMPLE_INCREMENT = 0.0625f;
    private final float[] xSamples = new float[17];

    SplineInterpolator(float f, float f2, float f3, float f4) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f) {
            throw new IllegalArgumentException("Control point coordinates must all be in range [0,1]");
        }
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
        boolean bl = this.isCurveLinear = this.x1 == this.y1 && this.x2 == this.y2;
        if (!this.isCurveLinear) {
            for (int i = 0; i < 17; ++i) {
                this.xSamples[i] = this.eval((float)i * 0.0625f, this.x1, this.x2);
            }
        }
    }

    public float interpolate(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("x must be in range [0,1]");
        }
        if (this.isCurveLinear || f == 0.0f || f == 1.0f) {
            return f;
        }
        return this.eval(this.findTForX(f), this.y1, this.y2);
    }

    private float eval(float f, float f2, float f3) {
        float f4 = 1.0f - f;
        return f * (3.0f * f4 * (f4 * f2 + f * f3) + f * f);
    }

    private float evalDerivative(float f, float f2, float f3) {
        float f4 = 1.0f - f;
        return 3.0f * (f4 * (f4 * f2 + 2.0f * f * (f3 - f2)) + f * f * (1.0f - f3));
    }

    private float getInitialGuessForT(float f) {
        for (int i = 1; i < 17; ++i) {
            if (!(this.xSamples[i] >= f)) continue;
            float f2 = this.xSamples[i] - this.xSamples[i - 1];
            if (f2 == 0.0f) {
                return (float)(i - 1) * 0.0625f;
            }
            return ((float)(i - 1) + (f - this.xSamples[i - 1]) / f2) * 0.0625f;
        }
        return 1.0f;
    }

    private float findTForX(float f) {
        float f2;
        float f3;
        float f4 = this.getInitialGuessForT(f);
        for (int i = 0; i < 4 && (f3 = this.eval(f4, this.x1, this.x2) - f) != 0.0f && (f2 = this.evalDerivative(f4, this.x1, this.x2)) != 0.0f; ++i) {
            f4 -= f3 / f2;
        }
        return f4;
    }
}

