/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.ogl;

import com.sun.javafx.geom.Rectangle;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.impl.hw.Texture;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class OGLTexture
implements Texture {
    private int texID;
    private final int physicalWidth;
    private final int physicalHeight;

    private OGLTexture(int n, int n2) {
        GL2 gL2 = GLU.getCurrentGL().getGL2();
        this.texID = OGLTexture.createTexture(gL2, n, n2);
        this.physicalWidth = n;
        this.physicalHeight = n2;
    }

    public static OGLTexture createFloat(int n, int n2) {
        return new OGLTexture(n, n2);
    }

    private static int createTexture(GL2 gL2, int n, int n2) {
        int[] nArray = new int[1];
        gL2.glGenTextures(1, nArray, 0);
        gL2.glBindTexture(3553, nArray[0]);
        gL2.glTexImage2D(3553, 0, 34836, n, n2, 0, 6408, 5126, null);
        gL2.glTexParameteri(3553, 10240, 9729);
        gL2.glTexParameteri(3553, 10241, 9729);
        return nArray[0];
    }

    public void update(FloatMap floatMap) {
        FloatBuffer floatBuffer = floatMap.getBuffer();
        int n = floatMap.getWidth();
        int n2 = floatMap.getHeight();
        GL2 gL2 = GLU.getCurrentGL().getGL2();
        gL2.glBindTexture(3553, this.texID);
        gL2.glPixelStorei(3317, 4);
        gL2.glPixelStorei(3314, n);
        gL2.glPixelStorei(3316, 0);
        for (int i = 0; i < n2; ++i) {
            gL2.glPixelStorei(3315, i);
            gL2.glTexSubImage2D(3553, 0, 0, n2 - 1 - i, n, 1, 6408, 5126, floatBuffer);
        }
    }

    public Rectangle getNativeBounds() {
        return new Rectangle(this.physicalWidth, this.physicalHeight);
    }

    public long getNativeSourceHandle() {
        return this.texID;
    }

    public void dispose() {
    }
}

