/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.j2d.J2DFilterContext;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;

public class J2DEffectHelper {
    public static void render(Effect effect, Graphics2D graphics2D, float f, float f2, Effect effect2) {
        boolean bl;
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.translate(f, f2);
        if (affineTransform.isIdentity()) {
            affineTransform = null;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setTransform(new AffineTransform());
        GraphicsConfiguration graphicsConfiguration = graphics2D2.getDeviceConfiguration();
        J2DFilterContext j2DFilterContext = J2DFilterContext.getInstance(graphicsConfiguration);
        ImageData imageData = null;
        do {
            if (imageData != null) {
                imageData.unref();
                imageData = null;
            }
            if (!(bl = (imageData = effect.filter(j2DFilterContext, J2DEffectHelper.toFXTransform(affineTransform), effect2)).validate(j2DFilterContext))) continue;
            Rectangle rectangle = imageData.getBounds();
            graphics2D2.drawImage((Image)imageData.getImage().getData(), rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, rectangle.width, rectangle.height, null);
            graphics2D2.dispose();
        } while (!bl);
        imageData.unref();
    }

    static void transformGraphics2D(Graphics2D graphics2D, BaseTransform baseTransform) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return;
        }
        if (baseTransform.isTranslateOrIdentity()) {
            graphics2D.translate(baseTransform.getMxt(), baseTransform.getMyt());
        } else {
            graphics2D.transform(J2DEffectHelper.toAWTTransform(baseTransform));
        }
    }

    static AffineTransform toAWTTransform(BaseTransform baseTransform) {
        if (baseTransform == null) {
            return null;
        }
        return new AffineTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
    }

    static BaseTransform toFXTransform(AffineTransform affineTransform) {
        if (affineTransform == null || affineTransform.isIdentity()) {
            return BaseTransform.IDENTITY_TRANSFORM;
        }
        return new Affine2D(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }
}

