/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d;

import com.sun.scenario.effect.FilterContext;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import java.util.WeakHashMap;

public class J2DFilterContext
extends FilterContext {
    private static final Map<GraphicsConfiguration, J2DFilterContext> ctxMap = new WeakHashMap<GraphicsConfiguration, J2DFilterContext>();

    private J2DFilterContext(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
    }

    public static J2DFilterContext getInstance(GraphicsConfiguration graphicsConfiguration) {
        J2DFilterContext j2DFilterContext;
        if (graphicsConfiguration == null) {
            throw new IllegalArgumentException("GraphicsConfig must be non-null");
        }
        if (graphicsConfiguration.getDevice().getType() != 0 && !GraphicsEnvironment.isHeadless()) {
            graphicsConfiguration = J2DFilterContext.getDefaultConfig();
        }
        if ((j2DFilterContext = ctxMap.get(graphicsConfiguration)) == null) {
            j2DFilterContext = new J2DFilterContext(graphicsConfiguration);
            ctxMap.put(graphicsConfiguration, j2DFilterContext);
        }
        return j2DFilterContext;
    }

    public static J2DFilterContext getDefaultInstance() {
        return J2DFilterContext.getInstance(J2DFilterContext.getDefaultConfig());
    }

    private static GraphicsConfiguration getDefaultConfig() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

