/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d;

import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.j2d.J2DImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public class J2DHeapImage
extends J2DImage
implements HeapImage {
    private final BufferedImage bufimg;
    private final int scanlineStride;

    private J2DHeapImage(int n, int n2) {
        this(new BufferedImage(n, n2, 3));
    }

    private J2DHeapImage(BufferedImage bufferedImage) {
        super(bufferedImage);
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("Input image must be TYPE_INT_ARGB_PRE");
        }
        this.scanlineStride = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        this.bufimg = bufferedImage;
    }

    public static J2DHeapImage create(int n, int n2) {
        return new J2DHeapImage(n, n2);
    }

    public BufferedImage getData() {
        return this.bufimg;
    }

    public int[] getPixelArray() {
        return ((DataBufferInt)this.bufimg.getRaster().getDataBuffer()).getData();
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }
}

