/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d.jogl;

import com.sun.javafx.geom.Rectangle;
import com.sun.scenario.effect.BoxShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.GaussianShadow;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.SepiaTone;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.hw.RendererDelegate;
import com.sun.scenario.effect.impl.hw.ogl.OGLRendererDelegate;
import com.sun.scenario.effect.impl.j2d.J2DHeapImage;
import com.sun.scenario.effect.impl.j2d.J2DRenderer;
import com.sun.scenario.effect.impl.j2d.jogl.JOGLTexture;
import com.sun.scenario.effect.impl.j2d.jogl.TexturePool;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.Capabilities;
import javax.media.opengl.GL2;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.glu.GLU;

public class JOGLRenderer
extends J2DRenderer {
    private static final int THRESHOLD = 16384;
    private static final GLProfile GL2_PROFILE = GLProfile.get("GL2");
    private static GLPbuffer scratchPbuffer;
    private static GLContext shareContext;
    private static Renderer backupRenderer;
    private final RendererDelegate delegate;
    private GLPbuffer pbuffer;
    private TexturePool pool;
    private GLU glu = new GLU();

    private JOGLRenderer() {
        this.delegate = new OGLRendererDelegate(false);
        this.pool = new TexturePool();
    }

    public Effect.AccelType getAccelType() {
        return this.delegate.getAccelType();
    }

    public RendererDelegate getDelegate() {
        return this.delegate;
    }

    public final J2DHeapImage createCompatibleImage(int n, int n2) {
        return (J2DHeapImage)this.getBackupRenderer().createCompatibleImage(n, n2);
    }

    public J2DHeapImage getCompatibleImage(int n, int n2) {
        return (J2DHeapImage)this.getBackupRenderer().getCompatibleImage(n, n2);
    }

    public void releaseCompatibleImage(Filterable filterable) {
        this.getBackupRenderer().releaseCompatibleImage(filterable);
    }

    public Renderer.RendererState getRendererState() {
        return Renderer.RendererState.OK;
    }

    protected Renderer getBackupRenderer() {
        if (backupRenderer == null) {
            backupRenderer = JOGLRenderer.getSoftwareRenderer();
        }
        return backupRenderer;
    }

    private boolean forceSWRenderer(Effect effect) {
        return effect instanceof BoxShadow || effect instanceof GaussianShadow || effect instanceof SepiaTone;
    }

    protected Renderer getRendererForSize(Effect effect, int n, int n2) {
        if (n * n2 < 16384 || this.forceSWRenderer(effect)) {
            return this.getBackupRenderer();
        }
        return this;
    }

    protected EffectPeer createPlatformPeer(FilterContext filterContext, String string, int n) {
        EffectPeer effectPeer;
        String string2 = string;
        if (n > 0) {
            string2 = string2 + "_" + n;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.j2d.jogl.JOGL" + string + "Peer");
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(filterContext, this, string2);
        }
        catch (Exception exception) {
            System.err.println("Error: JOGL peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return effectPeer;
    }

    public boolean isImageDataCompatible(ImageData imageData) {
        Image image = (Image)imageData.getImage().getData();
        return image instanceof BufferedImage && ((BufferedImage)image).getType() == 3;
    }

    private static String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    private static boolean snowLeopardWithIntelChipset(GL2 gL2) {
        String string;
        String string2;
        String string3 = JOGLRenderer.getProperty("os.name");
        return string3 != null && string3.toLowerCase().startsWith("mac") && (string2 = JOGLRenderer.getProperty("os.version")) != null && string2.startsWith("10.6") && (string = gL2.glGetString(7936)) != null && string.toLowerCase().startsWith("intel");
    }

    private static boolean isHwValid(FilterContext filterContext) {
        Object object;
        if (shareContext == null) {
            object = new GLCapabilities(GL2_PROFILE);
            scratchPbuffer = GLDrawableFactory.getFactory(GL2_PROFILE).createGLPbuffer((GLCapabilities)object, null, 1, 1, null);
            shareContext = scratchPbuffer.getContext();
        }
        shareContext.makeCurrent();
        object = shareContext.getGL().getGL2();
        if (JOGLRenderer.snowLeopardWithIntelChipset((GL2)object)) {
            return false;
        }
        boolean bl = false;
        if (object.isExtensionAvailable("GL_NV_fragment_program")) {
            if (object.isExtensionAvailable("GL_NV_fragment_program2")) {
                bl = true;
            }
        } else if (object.isExtensionAvailable("GL_ARB_fragment_program")) {
            int[] nArray = new int[1];
            object.glGetProgramivARB(34820, 34977, nArray, 0);
            if (nArray[0] > 512) {
                bl = true;
            }
        }
        boolean bl2 = object.isExtensionAvailable("GL_ARB_texture_float") && object.isExtensionAvailable("GL_ARB_texture_non_power_of_two");
        shareContext.release();
        if (!(bl &= bl2)) {
            shareContext.destroy();
            scratchPbuffer.destroy();
        }
        return bl;
    }

    public static JOGLRenderer createRenderer(FilterContext filterContext) {
        if (!JOGLRenderer.isHwValid(filterContext)) {
            return null;
        }
        return new JOGLRenderer();
    }

    public void enable(int n, int n2) {
        Object object;
        if (this.pbuffer == null || n > this.pbuffer.getWidth() || n2 > this.pbuffer.getHeight()) {
            if (this.pbuffer != null) {
                this.pbuffer.destroy();
            }
            object = new GLCapabilities(GL2_PROFILE);
            ((Capabilities)object).setAlphaBits(8);
            this.pbuffer = GLDrawableFactory.getFactory(GL2_PROFILE).createGLPbuffer((GLCapabilities)object, null, n, n2, shareContext);
        }
        object = this.pbuffer.getContext();
        ((GLContext)object).makeCurrent();
        GL2 gL2 = ((GLContext)object).getGL().getGL2();
        gL2.glViewport(0, 0, n, n2);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho(0.0, n, 0.0, n2, -1.0, 1.0);
        gL2.glReadBuffer(1028);
        gL2.glDrawBuffer(1028);
    }

    public void disable() {
        this.pbuffer.getContext().release();
    }

    public void readPixels(HeapImage heapImage, int n, int n2) {
        int n3 = heapImage.getScanlineStride();
        int[] nArray = heapImage.getPixelArray();
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        GL2 gL2 = GLU.getCurrentGL().getGL2();
        gL2.glPixelStorei(3332, 0);
        gL2.glPixelStorei(3331, 0);
        gL2.glPixelStorei(3330, n3);
        gL2.glPixelStorei(3333, 4);
        gL2.glReadPixels(0, 0, n, n2, 32993, 33639, intBuffer);
    }

    public String getErrorString() {
        GL2 gL2 = GLU.getCurrentGL().getGL2();
        int n = gL2.glGetError();
        if (n != 0) {
            return this.glu.gluErrorString(n);
        }
        return "no error";
    }

    public JOGLTexture getTexture(J2DHeapImage j2DHeapImage, Rectangle rectangle) {
        return this.pool.getTexture(j2DHeapImage.getData(), rectangle);
    }

    public void releaseTexture(JOGLTexture jOGLTexture) {
        this.pool.releaseTexture(jOGLTexture);
    }

    public Object createFloatTexture(int n, int n2) {
        return this.delegate.createFloatTexture(n, n2);
    }

    public void updateFloatTexture(Object object, FloatMap floatMap) {
        this.delegate.updateFloatTexture(object, floatMap);
    }
}

