/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d.jogl;

import com.sun.javafx.geom.Rectangle;
import com.sun.scenario.effect.impl.hw.Texture;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class JOGLTexture
implements Texture {
    private int texID;
    private final int physicalWidth;
    private final int physicalHeight;
    private static IntBuffer zerobuf;

    private JOGLTexture(int n, int n2, int n3) {
        this.texID = n;
        this.physicalWidth = n2;
        this.physicalHeight = n3;
    }

    public static JOGLTexture create(BufferedImage bufferedImage, int n, int n2) {
        GL2 gL2 = GLU.getCurrentGL().getGL2();
        int n3 = JOGLTexture.createTexture(gL2, bufferedImage, n, n2);
        return new JOGLTexture(n3, n, n2);
    }

    private static int createTexture(GL2 gL2, BufferedImage bufferedImage, int n, int n2) {
        int[] nArray = new int[1];
        gL2.glGenTextures(1, nArray, 0);
        gL2.glBindTexture(3553, nArray[0]);
        gL2.glTexImage2D(3553, 0, 6408, n, n2, 0, 32993, 33639, null);
        JOGLTexture.uploadPixels(gL2, bufferedImage, n, n2);
        gL2.glTexParameteri(3553, 10240, 9729);
        gL2.glTexParameteri(3553, 10241, 9729);
        return nArray[0];
    }

    private static void uploadPixels(GL2 gL2, BufferedImage bufferedImage, int n, int n2) {
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new InternalError("Input image must be TYPE_INT_ARGB_PRE");
        }
        int n3 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        gL2.glPixelStorei(3317, 4);
        gL2.glPixelStorei(3314, n3);
        gL2.glPixelStorei(3315, 0);
        gL2.glPixelStorei(3316, 0);
        gL2.glTexSubImage2D(3553, 0, 0, 0, n, n2, 32993, 33639, intBuffer);
    }

    public void update(BufferedImage bufferedImage, int n, int n2) {
        int n3 = this.physicalWidth;
        int n4 = this.physicalHeight;
        GL2 gL2 = GLU.getCurrentGL().getGL2();
        gL2.glBindTexture(3553, this.texID);
        if (n3 > n || n4 > n2) {
            int n5 = n3 * n4;
            if (zerobuf == null || zerobuf.capacity() < n5) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5 * 4);
                zerobuf = byteBuffer.order(ByteOrder.nativeOrder()).asIntBuffer();
            }
            gL2.glPixelStorei(3317, 4);
            gL2.glPixelStorei(3314, 0);
            gL2.glPixelStorei(3315, 0);
            gL2.glPixelStorei(3316, 0);
            gL2.glTexSubImage2D(3553, 0, 0, 0, n3, n4, 32993, 33639, zerobuf);
        }
        JOGLTexture.uploadPixels(gL2, bufferedImage, n, n2);
    }

    public Rectangle getNativeBounds() {
        return new Rectangle(this.physicalWidth, this.physicalHeight);
    }

    public int getPhysicalWidth() {
        return this.physicalWidth;
    }

    public int getPhysicalHeight() {
        return this.physicalHeight;
    }

    public long getNativeSourceHandle() {
        return this.texID;
    }

    public void dispose() {
        if (this.texID != 0) {
            GL2 gL2 = GLU.getCurrentGL().getGL2();
            gL2.glDeleteTextures(1, new int[]{this.texID}, 0);
            this.texID = 0;
        }
    }
}

