/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d.jogl;

import com.sun.javafx.geom.Rectangle;
import com.sun.scenario.effect.impl.j2d.jogl.JOGLTexture;
import java.awt.image.BufferedImage;

public class TexturePool {
    private static boolean disabled = false;
    private Item[] items = new Item[2];

    public TexturePool() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Item();
        }
    }

    public JOGLTexture getTexture(BufferedImage bufferedImage, Rectangle rectangle) {
        if (disabled) {
            return JOGLTexture.create(bufferedImage, rectangle.width, rectangle.height);
        }
        JOGLTexture jOGLTexture = null;
        for (Item item : this.items) {
            if (!item.available) continue;
            if (item.tex == null || item.tex.getPhysicalWidth() < rectangle.width || item.tex.getPhysicalHeight() < rectangle.height) {
                if (item.tex != null) {
                    item.tex.dispose();
                }
                item.tex = JOGLTexture.create(bufferedImage, rectangle.width, rectangle.height);
            } else {
                item.tex.update(bufferedImage, rectangle.width, rectangle.height);
            }
            item.available = false;
            jOGLTexture = item.tex;
            break;
        }
        return jOGLTexture;
    }

    public void releaseTexture(JOGLTexture jOGLTexture) {
        if (disabled) {
            jOGLTexture.dispose();
        }
        for (Item item : this.items) {
            if (item.tex != jOGLTexture) continue;
            item.available = true;
            break;
        }
    }

    private static class Item {
        boolean available = true;
        JOGLTexture tex;

        private Item() {
        }
    }
}

