/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.impl.state.GaussianBlurState;

public class GaussianShadowState
extends GaussianBlurState {
    private Color4f shadowColor;
    private float spread;

    void checkRadius(float f) {
        if (f < 0.0f || f > 127.0f) {
            throw new IllegalArgumentException("Radius must be in the range [1,127]");
        }
    }

    private int getPow2Scale(int n) {
        return this.getRadius(n) > 63.0f ? -1 : 0;
    }

    public int getPow2ScaleX() {
        return this.getPow2Scale(0);
    }

    public int getPow2ScaleY() {
        return this.getPow2Scale(1);
    }

    public float getScaledRadius(int n) {
        float f = this.getRadius(n);
        for (int i = this.getPow2Scale(n); i < 0; ++i) {
            f /= 2.0f;
        }
        return f;
    }

    public int getScaledPad(int n) {
        float f = this.getScaledRadius(n);
        return f > 63.0f ? 63 : (int)Math.ceil(f);
    }

    public int getScaledKernelSize(int n) {
        return this.getScaledPad(n) * 2 + 1;
    }

    public Color4f getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color4f color4f) {
        if (color4f == null) {
            throw new IllegalArgumentException("Color must be non-null");
        }
        this.shadowColor = color4f;
    }

    public float getSpread() {
        return this.spread;
    }

    public void setSpread(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Spread must be in the range [0,1]");
        }
        this.spread = f;
    }

    public boolean isNop() {
        return false;
    }

    public boolean isNop(int n) {
        return n == 0 && super.isNop(n);
    }

    public boolean isShadow() {
        return true;
    }

    public float[] getShadowColorComponents(int n) {
        return n == 0 ? BLACK_COMPONENTS : this.shadowColor.getPremultipliedRGBComponents();
    }
}

