/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGShape;
import com.sun.scenario.paint.ProportionalPaint;
import com.sun.scenario.scenegraph.SGAbstractGeometry;
import com.sun.scenario.scenegraph.SGAbstractShape;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class SGShape
extends SGAbstractGeometry {
    private Shape shape;
    private static final int AT_IDENT = 0;
    private static final int AT_TRANS = 1;
    private static final int AT_GENERAL = 2;
    private static final AffineTransform TEMP_TX = new AffineTransform();
    private static final int[] coordsPerSeg = new int[]{2, 2, 4, 6, 0};

    protected Paint getRelativePaint(ProportionalPaint proportionalPaint) {
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        return proportionalPaint.getPaint(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public final Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.geomChanged(true);
    }

    public final Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        Shape shape = this.getShape();
        if (shape instanceof Ellipse2D) {
            return SGShape.computeBounds(bounds2D, baseTransform, (SGAbstractGeometry)this, (Ellipse2D)shape);
        }
        if (shape instanceof RoundRectangle2D) {
            return SGShape.computeBounds(bounds2D, baseTransform, (SGAbstractGeometry)this, (RoundRectangle2D)shape);
        }
        if (shape instanceof Line2D) {
            return SGShape.computeBounds(bounds2D, baseTransform, (SGAbstractGeometry)this, (Line2D)shape);
        }
        if (shape instanceof Arc2D) {
            return SGShape.computeBounds(bounds2D, baseTransform, (SGAbstractGeometry)this, (Arc2D)shape);
        }
        if (shape == null) {
            return bounds2D.invalidate();
        }
        return SGShape.computeShapeBounds(bounds2D, baseTransform, this, shape);
    }

    public boolean computeContains(float f, float f2) {
        Shape shape = this.getShape();
        if (shape == null) {
            return false;
        }
        if (shape instanceof Ellipse2D) {
            return SGShape.contains(f, f2, (SGAbstractGeometry)this, (Ellipse2D)shape);
        }
        if (shape instanceof RoundRectangle2D) {
            return SGShape.contains(f, f2, (SGAbstractGeometry)this, (RoundRectangle2D)shape);
        }
        if (shape instanceof Line2D) {
            return SGShape.contains(f, f2, (SGAbstractGeometry)this, (Line2D)shape);
        }
        return SGShape.shapeContains(f, f2, this, shape);
    }

    private static int classify(BaseTransform baseTransform) {
        if (baseTransform == null) {
            return 0;
        }
        switch (baseTransform.getType()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    private static BasicStroke getBasicStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            return (BasicStroke)stroke;
        }
        if (stroke instanceof SGAbstractShape.OuterStroke) {
            return ((SGAbstractShape.OuterStroke)stroke).getBasicStroke();
        }
        return null;
    }

    static Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform, SGAbstractGeometry sGAbstractGeometry, Line2D line2D) {
        float f;
        if (sGAbstractGeometry.getMode() == PGShape.Mode.FILL || sGAbstractGeometry.getMode() == PGShape.Mode.EMPTY) {
            return bounds2D.invalidate();
        }
        Stroke stroke = sGAbstractGeometry.getDrawStroke();
        if (stroke instanceof SGAbstractShape.OuterStroke) {
            stroke = ((SGAbstractShape.OuterStroke)stroke).getBasicStroke();
            f = 1.0f;
        } else {
            if (stroke instanceof SGAbstractShape.InnerStroke) {
                return bounds2D.invalidate();
            }
            f = 0.5f;
        }
        if (stroke instanceof BasicStroke) {
            float f2;
            float f3;
            BasicStroke basicStroke = (BasicStroke)stroke;
            float f4 = (float)line2D.getX1();
            float f5 = (float)line2D.getY1();
            float f6 = (float)line2D.getX2();
            float f7 = (float)line2D.getY2();
            float f8 = basicStroke.getLineWidth() * f;
            int n = SGShape.classify(baseTransform);
            if (n <= 1) {
                float f9;
                float f10;
                float f11;
                f8 += 0.5f;
                if (n == 1) {
                    f11 = (float)baseTransform.getMxt();
                    float f12 = (float)baseTransform.getMyt();
                    f4 += f11;
                    f5 += f12;
                    f6 += f11;
                    f7 += f12;
                }
                if (f5 == f7 && f4 != f6) {
                    f10 = f8;
                    f9 = basicStroke.getEndCap() == 0 ? 0.0f : f8;
                } else if (f4 == f6 && f5 != f7) {
                    f9 = f8;
                    f10 = basicStroke.getEndCap() == 0 ? 0.0f : f8;
                } else {
                    if (basicStroke.getEndCap() == 2) {
                        f8 = (float)((double)f8 * Math.sqrt(2.0));
                    }
                    f9 = f10 = f8;
                }
                if (f4 > f6) {
                    f11 = f4;
                    f4 = f6;
                    f6 = f11;
                }
                if (f5 > f7) {
                    f11 = f5;
                    f5 = f7;
                    f7 = f11;
                }
                bounds2D.setBounds(f4 -= f9, f5 -= f10, f6 += f9, f7 += f10);
                return bounds2D;
            }
            float f13 = f6 - f4;
            float f14 = f7 - f5;
            float f15 = (float)Math.sqrt(f13 * f13 + f14 * f14);
            if (f15 == 0.0f) {
                f13 = f8;
                f14 = 0.0f;
            } else {
                f13 = f8 * f13 / f15;
                f14 = f8 * f14 / f15;
            }
            if (basicStroke.getEndCap() != 0) {
                f3 = f13;
                f2 = f14;
            } else {
                f2 = 0.0f;
                f3 = 0.0f;
            }
            float[] fArray = new float[]{f4 - f14 - f3, f5 + f13 - f2, f4 + f14 - f3, f5 - f13 - f2, f6 + f14 + f3, f7 - f13 + f2, f6 - f14 + f3, f7 + f13 + f2};
            baseTransform.transform(fArray, 0, fArray, 0, 4);
            f4 = Math.min(Math.min(fArray[0], fArray[2]), Math.min(fArray[4], fArray[6]));
            f5 = Math.min(Math.min(fArray[1], fArray[3]), Math.min(fArray[5], fArray[7]));
            f6 = Math.max(Math.max(fArray[0], fArray[2]), Math.max(fArray[4], fArray[6]));
            f7 = Math.max(Math.max(fArray[1], fArray[3]), Math.max(fArray[5], fArray[7]));
            bounds2D.setBounds(f4 -= 0.5f, f5 -= 0.5f, f6 += 0.5f, f7 += 0.5f);
            return bounds2D;
        }
        return SGShape.computeShapeBounds(bounds2D, baseTransform, sGAbstractGeometry, line2D);
    }

    static Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform, SGAbstractGeometry sGAbstractGeometry, RoundRectangle2D roundRectangle2D) {
        float f;
        float f2;
        if (sGAbstractGeometry.getMode() == PGShape.Mode.EMPTY) {
            return bounds2D.invalidate();
        }
        int n = SGShape.classify(baseTransform);
        if (sGAbstractGeometry.getMode() == PGShape.Mode.FILL) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            Stroke stroke = sGAbstractGeometry.getDrawStroke();
            if (stroke instanceof SGAbstractShape.InnerStroke) {
                f2 = 0.0f;
                f = 0.0f;
            } else if (stroke instanceof SGAbstractShape.OuterStroke || stroke instanceof BasicStroke) {
                BasicStroke basicStroke;
                if (stroke instanceof BasicStroke) {
                    basicStroke = (BasicStroke)stroke;
                    f = 0.5f;
                } else {
                    basicStroke = ((SGAbstractShape.OuterStroke)stroke).getBasicStroke();
                    f = 1.0f;
                }
                f *= basicStroke.getLineWidth();
                if (basicStroke.getLineJoin() == 0) {
                    double d = roundRectangle2D.getWidth();
                    double d2 = roundRectangle2D.getHeight();
                    double d3 = Math.min(d, Math.abs(roundRectangle2D.getArcWidth()));
                    double d4 = Math.min(d2, Math.abs(roundRectangle2D.getArcHeight()));
                    f = d3 > 0.0 && d4 > 0.0 && (d3 * 10.0 < d4 || d4 * 10.0 < d3) ? (f *= basicStroke.getMiterLimit()) : (float)((double)f * Math.sqrt(2.0));
                }
                f2 = 0.5f;
            } else {
                return SGShape.computeShapeBounds(bounds2D, baseTransform, sGAbstractGeometry, roundRectangle2D);
            }
        }
        return SGShape.computeBounds(bounds2D, baseTransform, n, f, f2, roundRectangle2D);
    }

    static Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform, SGAbstractGeometry sGAbstractGeometry, Arc2D arc2D) {
        return SGShape.computeShapeBounds(bounds2D, baseTransform, sGAbstractGeometry, arc2D);
    }

    static Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform, SGAbstractGeometry sGAbstractGeometry, Ellipse2D ellipse2D) {
        float f;
        float f2;
        if (sGAbstractGeometry.getMode() == PGShape.Mode.EMPTY) {
            return bounds2D.invalidate();
        }
        if (sGAbstractGeometry.getMode() == PGShape.Mode.FILL) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            Stroke stroke = sGAbstractGeometry.getDrawStroke();
            if (stroke instanceof SGAbstractShape.InnerStroke) {
                f2 = 0.0f;
                f = 0.0f;
            } else if (stroke instanceof BasicStroke || stroke instanceof SGAbstractShape.OuterStroke) {
                BasicStroke basicStroke;
                if (stroke instanceof BasicStroke) {
                    basicStroke = (BasicStroke)stroke;
                    f = 0.5f;
                } else {
                    basicStroke = ((SGAbstractShape.OuterStroke)stroke).getBasicStroke();
                    f = 1.0f;
                }
                f *= basicStroke.getLineWidth();
                if (basicStroke.getLineJoin() == 0 && (ellipse2D.getWidth() * 10.0 < ellipse2D.getHeight() || ellipse2D.getHeight() * 10.0 < ellipse2D.getWidth())) {
                    f *= basicStroke.getMiterLimit();
                }
                f2 = 0.5f;
            } else {
                return SGShape.computeShapeBounds(bounds2D, baseTransform, sGAbstractGeometry, ellipse2D);
            }
        }
        return SGShape.computeBounds(bounds2D, baseTransform, SGShape.classify(baseTransform), f, f2, ellipse2D);
    }

    static Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform, SGAbstractGeometry sGAbstractGeometry, Rectangle2D rectangle2D) {
        float f;
        float f2;
        if (sGAbstractGeometry.getMode() == PGShape.Mode.EMPTY) {
            return bounds2D.invalidate();
        }
        int n = SGShape.classify(baseTransform);
        if (sGAbstractGeometry.getMode() == PGShape.Mode.FILL) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            Stroke stroke = sGAbstractGeometry.getDrawStroke();
            if (stroke instanceof SGAbstractShape.InnerStroke) {
                f2 = 0.0f;
                f = 0.0f;
            } else if (stroke instanceof BasicStroke || stroke instanceof SGAbstractShape.OuterStroke) {
                BasicStroke basicStroke;
                if (stroke instanceof BasicStroke) {
                    basicStroke = (BasicStroke)stroke;
                    f = 0.5f;
                } else {
                    basicStroke = ((SGAbstractShape.OuterStroke)stroke).getBasicStroke();
                    f = 1.0f;
                }
                f *= basicStroke.getLineWidth();
                if (basicStroke.getLineJoin() == 0 && n > 1) {
                    f = (float)((double)f * Math.sqrt(2.0));
                }
                f2 = 0.5f;
            } else {
                return SGShape.computeShapeBounds(bounds2D, baseTransform, sGAbstractGeometry, rectangle2D);
            }
        }
        return SGShape.computeBounds(bounds2D, baseTransform, n, f, f2, rectangle2D);
    }

    private static Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform, int n, float f, float f2, RectangularShape rectangularShape) {
        float f3 = (float)rectangularShape.getWidth();
        float f4 = (float)rectangularShape.getHeight();
        if (f3 < 0.0f || f4 < 0.0f) {
            return bounds2D.invalidate();
        }
        float f5 = (float)rectangularShape.getX();
        float f6 = (float)rectangularShape.getY();
        if (n <= 1) {
            f3 += f5;
            f4 += f6;
            if (n == 1) {
                float f7 = (float)baseTransform.getMxt();
                float f8 = (float)baseTransform.getMyt();
                f5 += f7;
                f6 += f8;
                f3 += f7;
                f4 += f8;
            }
            f2 += f;
        } else {
            f5 -= f;
            f6 -= f;
            f3 += f * 2.0f;
            f4 += f * 2.0f;
            float f9 = (float)baseTransform.getMxx();
            float f10 = (float)baseTransform.getMxy();
            float f11 = (float)baseTransform.getMyx();
            float f12 = (float)baseTransform.getMyy();
            float f13 = f5 * f9 + f6 * f10 + (float)baseTransform.getMxt();
            float f14 = f5 * f11 + f6 * f12 + (float)baseTransform.getMyt();
            f5 = Math.min(Math.min(0.0f, f9 *= f3), Math.min(f10 *= f4, f9 + f10)) + f13;
            f6 = Math.min(Math.min(0.0f, f11 *= f3), Math.min(f12 *= f4, f11 + f12)) + f14;
            f3 = Math.max(Math.max(0.0f, f9), Math.max(f10, f9 + f10)) + f13;
            f4 = Math.max(Math.max(0.0f, f11), Math.max(f12, f11 + f12)) + f14;
        }
        bounds2D.setBounds(f5 -= f2, f6 -= f2, f3 += f2, f4 += f2);
        return bounds2D;
    }

    static Bounds2D computeShapeBounds(Bounds2D bounds2D, BaseTransform baseTransform, SGAbstractGeometry sGAbstractGeometry, Shape shape) {
        PGShape.Mode mode = sGAbstractGeometry.getMode();
        if (mode == PGShape.Mode.EMPTY) {
            return bounds2D.invalidate();
        }
        boolean bl = mode != PGShape.Mode.STROKE;
        boolean bl2 = mode != PGShape.Mode.FILL;
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        if (bl) {
            SGShape.accumulate(fArray, shape, baseTransform);
        }
        if (bl2) {
            Stroke stroke = sGAbstractGeometry.getDrawStroke();
            SGShape.accumulate(fArray, sGAbstractGeometry.getStrokeShape(), baseTransform);
            if (stroke instanceof BasicStroke || stroke instanceof SGAbstractShape.OuterStroke) {
                fArray[0] = fArray[0] - 0.5f;
                fArray[1] = fArray[1] - 0.5f;
                fArray[2] = fArray[2] + 0.5f;
                fArray[3] = fArray[3] + 0.5f;
            }
        }
        if (fArray[2] < fArray[0] || fArray[3] < fArray[1]) {
            return bounds2D.invalidate();
        }
        bounds2D.setBounds(fArray[0], fArray[1], fArray[2], fArray[3]);
        return bounds2D;
    }

    private static void accumulate(float[] fArray, Shape shape, BaseTransform baseTransform) {
        if (baseTransform.isIdentity()) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            if ((double)fArray[0] > rectangle2D.getMinX()) {
                fArray[0] = (float)rectangle2D.getMinX();
            }
            if ((double)fArray[1] > rectangle2D.getMinY()) {
                fArray[1] = (float)rectangle2D.getMinY();
            }
            if ((double)fArray[2] < rectangle2D.getMaxX()) {
                fArray[2] = (float)rectangle2D.getMaxX();
            }
            if ((double)fArray[3] < rectangle2D.getMaxY()) {
                fArray[3] = (float)rectangle2D.getMaxY();
            }
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(SGShape.toAWTTransform(baseTransform, TEMP_TX));
        float[] fArray2 = new float[6];
        while (!pathIterator.isDone()) {
            int n = coordsPerSeg[pathIterator.currentSegment(fArray2)];
            for (int i = 0; i < n; ++i) {
                int n2 = i & 1;
                float f = fArray2[i];
                if (fArray[n2 + 0] > f) {
                    fArray[n2 + 0] = f;
                }
                if (!(fArray[n2 + 2] < f)) continue;
                fArray[n2 + 2] = f;
            }
            pathIterator.next();
        }
    }

    private static boolean hasMiterAndNoDashes(BasicStroke basicStroke) {
        return basicStroke.getLineJoin() == 0 && basicStroke.getDashArray() == null;
    }

    static boolean rectContains(float f, float f2, SGAbstractGeometry sGAbstractGeometry, RectangularShape rectangularShape) {
        float f3 = (float)rectangularShape.getWidth();
        float f4 = (float)rectangularShape.getHeight();
        if (f3 < 0.0f || f4 < 0.0f) {
            return false;
        }
        PGShape.Mode mode = sGAbstractGeometry.getMode();
        if (mode == PGShape.Mode.EMPTY) {
            return false;
        }
        float f5 = (float)rectangularShape.getX();
        float f6 = (float)rectangularShape.getY();
        if (mode == PGShape.Mode.FILL) {
            return f >= f5 && f2 >= f6 && f < f5 + f3 && f2 < f6 + f4;
        }
        float f7 = -1.0f;
        float f8 = -1.0f;
        boolean bl = false;
        Stroke stroke = sGAbstractGeometry.getDrawStroke();
        if (stroke instanceof SGAbstractShape.InnerStroke) {
            if (mode == PGShape.Mode.STROKE_FILL) {
                f7 = 0.0f;
            } else {
                BasicStroke basicStroke = ((SGAbstractShape.InnerStroke)stroke).getBasicStroke();
                if (basicStroke.getDashArray() == null) {
                    f7 = 0.0f;
                    f8 = basicStroke.getLineWidth();
                } else {
                    bl = true;
                }
            }
        } else if (stroke instanceof SGAbstractShape.OuterStroke) {
            BasicStroke basicStroke = ((SGAbstractShape.OuterStroke)stroke).getBasicStroke();
            if (SGShape.hasMiterAndNoDashes(basicStroke)) {
                f7 = basicStroke.getLineWidth();
                if (mode == PGShape.Mode.STROKE) {
                    f8 = 0.0f;
                }
            } else {
                if (mode == PGShape.Mode.STROKE_FILL) {
                    f7 = 0.0f;
                }
                bl = true;
            }
        } else if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (SGShape.hasMiterAndNoDashes(basicStroke)) {
                f7 = basicStroke.getLineWidth() / 2.0f;
                if (mode == PGShape.Mode.STROKE) {
                    f8 = f7;
                }
            } else {
                if (mode == PGShape.Mode.STROKE_FILL) {
                    f7 = 0.0f;
                }
                bl = true;
            }
        } else {
            if (mode == PGShape.Mode.STROKE_FILL) {
                f7 = 0.0f;
            }
            bl = true;
        }
        if (f7 >= 0.0f && f >= f5 - f7 && f2 >= f6 - f7 && f < f5 + f3 + f7 && f2 < f6 + f4 + f7) {
            return !(f8 >= 0.0f) || !(f8 < f3 / 2.0f) || !(f8 < f4 / 2.0f) || !(f >= f5 + f8) || !(f2 >= f6 + f8) || !(f < f5 + f3 - f8) || !(f2 < f6 + f4 - f8);
        }
        if (bl) {
            return sGAbstractGeometry.getStrokeShape().contains(f, f2);
        }
        return false;
    }

    static boolean contains(float f, float f2, SGAbstractGeometry sGAbstractGeometry, Ellipse2D ellipse2D) {
        return SGShape.shapeContains(f, f2, sGAbstractGeometry, ellipse2D);
    }

    static boolean contains(float f, float f2, SGAbstractGeometry sGAbstractGeometry, Arc2D arc2D) {
        return SGShape.shapeContains(f, f2, sGAbstractGeometry, arc2D);
    }

    static boolean contains(float f, float f2, SGAbstractGeometry sGAbstractGeometry, RoundRectangle2D roundRectangle2D) {
        if (roundRectangle2D.getArcWidth() == 0.0 || roundRectangle2D.getArcHeight() == 0.0) {
            return SGShape.rectContains(f, f2, sGAbstractGeometry, roundRectangle2D);
        }
        return SGShape.shapeContains(f, f2, sGAbstractGeometry, roundRectangle2D);
    }

    static boolean contains(float f, float f2, SGAbstractGeometry sGAbstractGeometry, Line2D line2D) {
        PGShape.Mode mode = sGAbstractGeometry.getMode();
        if (mode == PGShape.Mode.FILL || mode == PGShape.Mode.EMPTY) {
            return false;
        }
        return sGAbstractGeometry.getStrokeShape().contains(f, f2);
    }

    static boolean shapeContains(float f, float f2, SGAbstractGeometry sGAbstractGeometry, Shape shape) {
        PGShape.Mode mode = sGAbstractGeometry.getMode();
        if (mode == PGShape.Mode.EMPTY) {
            return false;
        }
        if (mode != PGShape.Mode.STROKE && shape.contains(f, f2)) {
            return true;
        }
        if (mode != PGShape.Mode.FILL) {
            return sGAbstractGeometry.getStrokeShape().contains(f, f2);
        }
        return false;
    }
}

