/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.media.jmc.MediaFrameHandler;
import com.sun.media.jmc.MediaProvider;
import com.sun.media.jmc.control.VideoDataBuffer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.WeakHashMap;

public class SwingMediaFrameHandler
extends MediaFrameHandler {
    private BufferedImage frameImage;
    private int[] data;
    private static Map<MediaProvider, MediaFrameHandler> handlers;
    private static final ColorModel RGB_CM;
    private static boolean accThresholdSet;
    private static final Color translucentColor;

    static MediaFrameHandler getHandler(MediaProvider mediaProvider) {
        MediaFrameHandler mediaFrameHandler;
        if (mediaProvider == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        if (handlers == null) {
            handlers = new WeakHashMap<MediaProvider, MediaFrameHandler>(1);
        }
        if ((mediaFrameHandler = handlers.get(mediaProvider)) == null) {
            mediaFrameHandler = new SwingMediaFrameHandler(mediaProvider);
            handlers.put(mediaProvider, mediaFrameHandler);
        }
        return mediaFrameHandler;
    }

    private SwingMediaFrameHandler(MediaProvider mediaProvider) {
        super(mediaProvider);
    }

    protected Object getGraphicsData(Object object) {
        return this.frameImage;
    }

    protected boolean updateGraphicsData(Object object, int n, int n2, VideoDataBuffer.Format format, Buffer buffer) {
        if (format != VideoDataBuffer.Format.XRGB || !(buffer instanceof IntBuffer)) {
            this.releaseGraphicsData();
            return true;
        }
        IntBuffer intBuffer = (IntBuffer)buffer;
        if (this.frameImage == null || intBuffer.hasArray() && intBuffer.array() != this.data || this.frameImage.getWidth() != n || this.frameImage.getHeight() != n2) {
            this.releaseGraphicsData();
            if (intBuffer.isDirect()) {
                this.frameImage = new BufferedImage(n, n2, 1);
                DataBufferInt dataBufferInt = (DataBufferInt)this.frameImage.getRaster().getDataBuffer();
                this.data = dataBufferInt.getData();
            } else {
                this.data = intBuffer.array();
                DataBufferInt dataBufferInt = new DataBufferInt(this.data, this.data.length);
                SampleModel sampleModel = RGB_CM.createCompatibleSampleModel(n, n2);
                WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferInt, null);
                this.frameImage = new BufferedImage(RGB_CM, writableRaster, false, null);
            }
            SwingMediaFrameHandler.restoreImageAcceleration(this.frameImage);
        }
        if (intBuffer.isDirect() && intBuffer.capacity() >= this.data.length) {
            intBuffer.get(this.data);
        }
        SwingMediaFrameHandler.markImageDirty(this.frameImage);
        return true;
    }

    protected void releaseGraphicsData() {
        if (this.frameImage != null) {
            this.frameImage.flush();
            this.frameImage = null;
            this.data = null;
        }
    }

    private static void restoreImageAcceleration(final Image image) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AccessibleObject accessibleObject;
                    Class<?> clazz = Class.forName("sun.awt.image.CachingSurfaceManager", true, null);
                    if (!accThresholdSet) {
                        accThresholdSet = true;
                        accessibleObject = clazz.getDeclaredField("accelerationThreshold");
                        ((Field)accessibleObject).setAccessible(true);
                        ((Field)accessibleObject).setInt(clazz, 0);
                    }
                    accessibleObject = clazz.getDeclaredMethod("restoreLocalAcceleration", Image.class);
                    ((Method)accessibleObject).setAccessible(true);
                    ((Method)accessibleObject).invoke(clazz, image);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void markImageDirty(Image image) {
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setColor(translucentColor);
            graphics.fillRect(0, 0, 1, 1);
        }
    }

    static {
        RGB_CM = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        accThresholdSet = false;
        translucentColor = new Color(0, 0, 0, 0);
    }
}

