/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXContext;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;

public class FXSequenceBuilder {
    FXValue[] values = new FXValue[16];
    int nvalues;
    FXValue sequence;
    FXType elementType;
    FXContext context;

    protected FXSequenceBuilder(FXContext fXContext, FXType fXType) {
        this.elementType = fXType;
        this.context = fXContext;
    }

    public void append(FXValue fXValue) {
        Object object;
        int n;
        if (this.sequence != null) {
            throw new IllegalStateException("appending to SequenceBuilder after getSequence");
        }
        int n2 = fXValue.getItemCount();
        if (this.nvalues + n2 > this.values.length) {
            for (n = this.values.length; this.nvalues + n2 > n; n = 2 * n) {
            }
            object = new FXValue[n];
            System.arraycopy(this.values, 0, object, 0, this.nvalues);
            this.values = object;
        }
        for (n = 0; n < n2; ++n) {
            object = fXValue.getItem(n);
            if ((object = this.elementType.coerceOrNull((FXValue)object)) == null) {
                throw new ClassCastException("cannot coerce to " + this.elementType);
            }
            this.values[this.nvalues++] = object;
        }
    }

    public FXValue getSequence() {
        if (this.sequence == null) {
            this.sequence = this.context.makeSequenceValue(this.values, this.nvalues, this.elementType);
            this.values = null;
        }
        return this.sequence;
    }
}

