/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.sun.nativewindow.impl.Debug;
import com.sun.nativewindow.impl.NWReflection;
import com.sun.nativewindow.impl.NativeWindowFactoryImpl;
import com.sun.nativewindow.impl.jvm.JVMUtil;
import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;

public abstract class NativeWindowFactory {
    protected static final boolean DEBUG;
    public static final String TYPE_EGL = "EGL";
    public static final String TYPE_WINDOWS = "Windows";
    public static final String TYPE_X11 = "X11";
    public static final String TYPE_MACOSX = "MacOSX";
    public static final String TYPE_GDL = "GDL";
    public static final String TYPE_AWT = "AWT";
    public static final String TYPE_DEFAULT = "default";
    private static NativeWindowFactory defaultFactory;
    private static Map registeredFactories;
    private static Class nativeWindowClass;
    private static String nativeWindowingTypePure;
    private static String nativeOSNamePure;
    private static String nativeWindowingTypeCustom;
    private static String nativeOSNameCustom;

    protected NativeWindowFactory() {
    }

    private static String _getNativeWindowingType(String string) {
        if (string.startsWith("kd")) {
            return TYPE_EGL;
        }
        if (string.startsWith("wind")) {
            return TYPE_WINDOWS;
        }
        if (string.startsWith("mac os x") || string.startsWith("darwin")) {
            return TYPE_MACOSX;
        }
        if (string.equals("awt")) {
            return TYPE_AWT;
        }
        return TYPE_X11;
    }

    public static String getNativeOSName(boolean bl) {
        return bl ? nativeOSNameCustom : nativeOSNamePure;
    }

    public static String getNativeWindowType(boolean bl) {
        String string = bl ? nativeWindowingTypeCustom : nativeWindowingTypePure;
        return string;
    }

    public static void setDefaultFactory(NativeWindowFactory nativeWindowFactory) {
        defaultFactory = nativeWindowFactory;
    }

    public static NativeWindowFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static NativeWindowFactory getFactory(Class clazz) throws IllegalArgumentException {
        if (nativeWindowClass.isAssignableFrom(clazz)) {
            return (NativeWindowFactory)registeredFactories.get(nativeWindowClass);
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            NativeWindowFactory nativeWindowFactory = (NativeWindowFactory)registeredFactories.get(clazz2);
            if (nativeWindowFactory == null) continue;
            return nativeWindowFactory;
        }
        throw new IllegalArgumentException("No registered NativeWindowFactory for class " + clazz.getName());
    }

    protected static void registerFactory(Class clazz, NativeWindowFactory nativeWindowFactory) {
        if (DEBUG) {
            System.err.println("NativeWindowFactory.registerFactory() " + clazz + " -> " + nativeWindowFactory);
        }
        registeredFactories.put(clazz, nativeWindowFactory);
    }

    public static NativeWindow getNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException, NativeWindowException {
        if (object == null) {
            throw new IllegalArgumentException("Null window object");
        }
        return NativeWindowFactory.getFactory(object.getClass()).getNativeWindowImpl(object, abstractGraphicsConfiguration);
    }

    protected abstract NativeWindow getNativeWindowImpl(Object var1, AbstractGraphicsConfiguration var2) throws IllegalArgumentException;

    public abstract ToolkitLock getToolkitLock();

    static {
        Constructor constructor;
        DEBUG = Debug.debug("NativeWindow");
        JVMUtil.initSingleton();
        AccessControlContext accessControlContext = AccessController.getContext();
        nativeOSNamePure = Debug.getProperty("os.name", false, accessControlContext);
        nativeWindowingTypePure = NativeWindowFactory._getNativeWindowingType(nativeOSNamePure.toLowerCase());
        nativeOSNameCustom = Debug.getProperty("nativewindow.ws.name", true, accessControlContext);
        if (null == nativeOSNameCustom || nativeOSNameCustom.length() == 0) {
            nativeOSNameCustom = nativeOSNamePure;
            nativeWindowingTypeCustom = nativeWindowingTypePure;
        } else {
            nativeWindowingTypeCustom = nativeOSNameCustom;
        }
        if (DEBUG) {
            System.err.println("NativeWindowingType: Pure: " + nativeWindowingTypePure);
            System.err.println("NativeWindowingType: Custom: " + nativeWindowingTypeCustom);
        }
        registeredFactories = Collections.synchronizedMap(new HashMap());
        Object var1_1 = null;
        NativeWindowFactoryImpl nativeWindowFactoryImpl = new NativeWindowFactoryImpl();
        nativeWindowClass = NativeWindow.class;
        NativeWindowFactory.registerFactory(nativeWindowClass, nativeWindowFactoryImpl);
        defaultFactory = nativeWindowFactoryImpl;
        boolean bl = Debug.getBooleanProperty("java.awt.headless", false, accessControlContext);
        boolean bl2 = Debug.getBooleanProperty("nativewindow.locking", true, accessControlContext);
        boolean bl3 = bl || Debug.getBooleanProperty("nativewindow.nolocking", true, accessControlContext);
        Class clazz = null;
        if (!bl && NWReflection.isClassAvailable("java.awt.Component") && NWReflection.isClassAvailable("javax.media.nativewindow.awt.AWTGraphicsDevice")) {
            try {
                clazz = NWReflection.getClass("java.awt.Component", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NativeWindowFactory nativeWindowFactory = null;
        if (!bl3 && null != clazz && TYPE_X11.equals(nativeWindowingTypeCustom)) {
            try {
                constructor = NWReflection.getConstructor("com.sun.nativewindow.impl.x11.awt.X11AWTNativeWindowFactory", new Class[0]);
                nativeWindowFactory = (NativeWindowFactory)constructor.newInstance(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2 && null == nativeWindowFactory) {
            try {
                constructor = NWReflection.getConstructor("com.sun.nativewindow.impl.LockingNativeWindowFactory", new Class[0]);
                nativeWindowFactory = (NativeWindowFactory)constructor.newInstance(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != nativeWindowFactory) {
            nativeWindowFactoryImpl = nativeWindowFactory;
        }
        if (null != clazz) {
            NativeWindowFactory.registerFactory(clazz, nativeWindowFactoryImpl);
        }
        defaultFactory = nativeWindowFactoryImpl;
        if (DEBUG) {
            System.err.println("NativeWindowFactory toolkitLockForced " + bl2 + ", awtToolkitLockDisabled " + bl3 + ", defaultFactory " + nativeWindowFactoryImpl);
        }
    }
}

