/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.nativewindow.impl.NWReflection;
import com.sun.opengl.impl.Debug;
import java.security.AccessController;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;

public abstract class GLDrawableFactory {
    private static final GLDrawableFactory eglFactory;
    private static final GLDrawableFactory nativeOSFactory;
    private static final String nativeOSType;
    static final String macosxFactoryClassNameCGL = "com.sun.opengl.impl.macosx.cgl.MacOSXCGLDrawableFactory";
    static final String macosxFactoryClassNameAWTCGL = "com.sun.opengl.impl.macosx.cgl.awt.MacOSXAWTCGLDrawableFactory";

    protected GLDrawableFactory() {
    }

    public static GLDrawableFactory getFactory(GLProfile gLProfile) throws GLException {
        return GLDrawableFactory.getFactoryImpl(gLProfile.getImplName());
    }

    protected static GLDrawableFactory getFactoryImpl(String string) throws GLException {
        if (GLProfile.usesNativeGLES(string)) {
            if (null == eglFactory) {
                throw new GLException("EGLDrawableFactory unavailable: " + string);
            }
            return eglFactory;
        }
        if (null != nativeOSFactory) {
            return nativeOSFactory;
        }
        if (null != eglFactory) {
            return eglFactory;
        }
        throw new GLException("No native platform GLDrawableFactory, nor EGLDrawableFactory available: " + string);
    }

    public void shutdown() {
    }

    public abstract GLDrawable createGLDrawable(NativeWindow var1) throws IllegalArgumentException, GLException;

    public abstract GLDrawable createOffscreenDrawable(GLCapabilities var1, GLCapabilitiesChooser var2, int var3, int var4) throws GLException;

    public abstract boolean canCreateGLPbuffer();

    public abstract GLDrawable createGLPbufferDrawable(GLCapabilities var1, GLCapabilitiesChooser var2, int var3, int var4) throws GLException;

    public abstract GLPbuffer createGLPbuffer(GLCapabilities var1, GLCapabilitiesChooser var2, int var3, int var4, GLContext var5) throws GLException;

    public abstract GLContext createExternalGLContext() throws GLException;

    public abstract boolean canCreateExternalGLDrawable();

    public abstract GLDrawable createExternalGLDrawable() throws GLException;

    static {
        GLDrawableFactory gLDrawableFactory;
        block15: {
            block14: {
                gLDrawableFactory = null;
                try {
                    gLDrawableFactory = (GLDrawableFactory)NWReflection.createInstance("com.sun.opengl.impl.egl.EGLDrawableFactory");
                }
                catch (Throwable throwable) {
                    if (!GLProfile.DEBUG) break block14;
                    System.err.println("GLDrawableFactory.static - EGLDrawableFactory - not available");
                    throwable.printStackTrace();
                }
            }
            eglFactory = gLDrawableFactory;
            nativeOSType = NativeWindowFactory.getNativeWindowType(true);
            String string = null;
            gLDrawableFactory = null;
            try {
                string = Debug.getProperty("jogl.gldrawablefactory.class.name", true, AccessController.getContext());
                if (null == string) {
                    if (nativeOSType.equals("X11")) {
                        string = "com.sun.opengl.impl.x11.glx.X11GLXDrawableFactory";
                    } else if (nativeOSType.equals("Windows")) {
                        string = "com.sun.opengl.impl.windows.wgl.WindowsWGLDrawableFactory";
                    } else if (nativeOSType.equals("MacOSX")) {
                        string = NWReflection.isClassAvailable(macosxFactoryClassNameAWTCGL) ? macosxFactoryClassNameAWTCGL : macosxFactoryClassNameCGL;
                    } else if (GLProfile.DEBUG) {
                        System.err.println("GLDrawableFactory.static - No native OS Factory for: " + nativeOSType + "; May use EGLDrawableFactory, if available.");
                    }
                }
                if (null != string) {
                    if (GLProfile.DEBUG) {
                        System.err.println("GLDrawableFactory.static - Native OS Factory for: " + nativeOSType + ": " + string);
                    }
                    gLDrawableFactory = (GLDrawableFactory)NWReflection.createInstance(string);
                }
            }
            catch (Throwable throwable) {
                if (!GLProfile.DEBUG) break block15;
                System.err.println("GLDrawableFactory.static - Native Platform: " + nativeOSType + " - not available: " + string);
                throwable.printStackTrace();
            }
        }
        nativeOSFactory = gLDrawableFactory;
    }
}

