/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.applet.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import netscape.javascript.JSObject;
import org.jdesktop.applet.util.StartupPing;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JNLPAppletLauncher
extends Applet {
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private boolean isInitOk = false;
    private boolean firstStart = true;
    private boolean appletStarted = false;
    private Applet subApplet;
    private String subAppletClassName;
    private String subAppletDisplayName;
    private URL subAppletImageURL;
    private JPanel loaderPanel;
    private static final String JRE_PREFIX = "deployment.javapi.jre.";
    private static final String NODDRAW_PROP = "-Dsun.java2d.noddraw=true";
    private static final String DONT_ASK = ".dont_ask";
    private JProgressBar progressBar = null;
    private static boolean firstApplet = true;
    private static List<URL> jnlpExtensions = null;
    private static URL codeBase;
    private static String archive;
    private static File cacheBaseDir;
    private static Set<URL> jarFiles;
    private static Set<URL> nativeJars;
    private static String nativePrefix;
    private static String nativeSuffix;
    private static Map<String, String> nativeLibMap;
    private static boolean staticInitError;
    private static File tmpBaseDir;
    private static String tmpRootPropValue;
    private static File tmpRootDir;
    private static File nativeTmpDir;
    boolean haveUI = true;
    private static final String _javaVersionProperty;
    private static final boolean _atLeast13;
    private static final boolean _atLeast14;
    private static final boolean _atLeast15;
    private static final String vendorURL;
    private static final String sunVendorURL = "http://java.sun.com/";
    private static final String appleVendorURL = "http://www.apple.com/";
    private static final String CONNECTION_HEADER = "Connection";
    private static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    private static final String PROTOCOL_VERSION_1_1 = "HTTP/1.1";

    private void hideOverlayImpl(String string) {
        JSObject jSObject = JSObject.getWindow((Applet)this);
        Object[] objectArray = new Object[]{string, "appletlauncher_no_perm"};
        jSObject.call("fxAppletFailed", objectArray);
    }

    private void hideOverlay() {
        final String string = this.getParameter("deployJavaAppletID");
        if (string == null) {
            return;
        }
        try {
            this.hideOverlayImpl(string);
            return;
        }
        catch (Exception exception) {
            System.err.println("Retry to hide overlay due to " + exception);
            Thread thread = new Thread(){

                public void run() {
                    for (int i = 1; i < 11; ++i) {
                        try {
                            1.sleep(100L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    JNLPAppletLauncher.this.hideOverlayImpl(string);
                                }
                            });
                            return;
                        }
                        catch (Exception exception) {
                            System.err.println("Retry to hide overlay due to " + exception);
                            continue;
                        }
                    }
                }
            };
            thread.setName("AppletLauncher hideOverlay re-try Thread");
            thread.setDaemon(true);
            thread.start();
            return;
        }
    }

    public void init() {
        StartupPing.setup(this.getParameter("pingAppletID"), this.getParameter("pingTS"), this.getParameter("fxbuild"));
        StartupPing.send("info_oldplugin");
        this.subAppletClassName = this.getParameter("subapplet.classname");
        if (this.subAppletClassName == null) {
            this.displayError("Init failed : Missing subapplet.classname parameter");
            return;
        }
        this.subAppletDisplayName = this.getParameter("subapplet.displayname");
        if (this.subAppletDisplayName == null) {
            this.subAppletDisplayName = "Applet";
        }
        this.subAppletImageURL = null;
        try {
            String string = this.getParameter("subapplet.image");
            if (string != null && string.length() > 0) {
                this.subAppletImageURL = new URL(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        boolean bl = this.haveUI = this.getParameter("deployJavaAppletID") == null;
        if (this.haveUI) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.initLoaderLayout();
                }
            });
        } else {
            System.err.println("Disable launcher UI");
        }
        this.isInitOk = true;
    }

    public void start() {
        if (staticInitError) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.setLayout(new BorderLayout());
                    String string = JNLPAppletLauncher.this.getParameter("customSecurityDialogErrorMsg");
                    if (string == null) {
                        string = "<center> You need to accept the security warning to run the applicaiton. Restart your browser and click the Allow button when the security warning is displayed.</center>";
                    }
                    JLabel jLabel = new JLabel("<html> <body>" + string + "</body></html> ");
                    JNLPAppletLauncher.this.add((Component)jLabel, "Center");
                }
            });
            StartupPing.send("done_noperm");
            this.hideOverlay();
            return;
        }
        if (this.isInitOk) {
            if (this.firstStart) {
                this.firstStart = false;
                Thread thread = new Thread(){

                    public void run() {
                        JNLPAppletLauncher.this.initAndStartApplet();
                    }
                };
                thread.setName("AppletLauncher-Startup");
                thread.setPriority(4);
                thread.start();
            } else if (this.appletStarted) {
                this.checkNoDDrawAndUpdateDeploymentProperties();
                this.subApplet.start();
            }
        }
    }

    public void stop() {
        if (this.subApplet != null) {
            this.subApplet.stop();
        }
    }

    private void applyMemoryLeakWorkaround() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block18: {
                    try {
                        Object object;
                        Object object2;
                        Object object3;
                        Field field;
                        AnnotatedElement annotatedElement;
                        GenericDeclaration genericDeclaration;
                        Class<?> clazz;
                        Object object4;
                        try {
                            object4 = Class.forName("javax.swing.TimerQueue", true, null);
                            clazz = ((Class)object4).getMethod("sharedInstance", new Class[0]);
                            ((Method)((Object)clazz)).setAccessible(true);
                            genericDeclaration = ((Method)((Object)clazz)).invoke(object4, null);
                            annotatedElement = ((Class)object4).getDeclaredMethod("stop", new Class[0]);
                            ((Method)annotatedElement).setAccessible(true);
                            ((Method)annotatedElement).invoke(genericDeclaration, null);
                        }
                        catch (Exception exception) {
                            System.err.println("Workaround [Timer] failed");
                        }
                        try {
                            object4 = Thread.class.getDeclaredField("subclassAudits");
                            ((Field)object4).setAccessible(true);
                            clazz = ((Field)object4).get(null);
                            genericDeclaration = Class.forName("sun.misc.SoftCache", true, null);
                            annotatedElement = ((Class)genericDeclaration).getDeclaredField("entrySet");
                            ((Field)annotatedElement).setAccessible(true);
                            ((Field)annotatedElement).set(clazz, null);
                            field = ((Class)genericDeclaration).getDeclaredField("hash");
                            field.setAccessible(true);
                            field.set(clazz, new HashMap());
                        }
                        catch (Exception exception) {
                            System.err.println("  Workaround [subclassAudits] failed: " + exception);
                        }
                        object4 = JNLPAppletLauncher.class.getClassLoader();
                        clazz = Class.forName("java.util.concurrent.ExecutorService", true, null);
                        genericDeclaration = clazz.getDeclaredMethod("shutdownNow", null);
                        try {
                            annotatedElement = Class.forName("com.sun.scenario.ToolkitAccessor", false, (ClassLoader)object4);
                            field = ((Class)annotatedElement).getDeclaredField("instance");
                            field.setAccessible(true);
                            object3 = field.get(null);
                            object2 = Class.forName("com.sun.scenario.StandaloneAccessor", false, (ClassLoader)object4);
                            object = ((Class)object2).getDeclaredField("executor");
                            ((Field)object).setAccessible(true);
                            if (object3 != null && object3.getClass().equals("com.sun.scenario.StandaloneAccessor")) {
                                Object object5 = ((Field)object).get(object3);
                                ((Method)genericDeclaration).invoke(object5, null);
                            } else {
                                System.err.println("Workaround [StandaloneAccessor] skipped");
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Workaround [StandaloneAccessor] failed due to " + exception);
                        }
                        try {
                            annotatedElement = Class.forName("com.sun.javafx.async.desktop.DesktopTaskManager", false, (ClassLoader)object4);
                            field = ((Class)annotatedElement).getDeclaredField("executor");
                            field.setAccessible(true);
                            object3 = field.get(null);
                            if (object3 != null) {
                                ((Method)genericDeclaration).invoke(object3, null);
                                object2 = (ThreadPoolExecutor)object3;
                                ((ThreadPoolExecutor)object2).setThreadFactory(Executors.defaultThreadFactory());
                            } else {
                                System.err.println("Workaround [DesktopTaskManager] skipped");
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Workaround [DesktopTaskManager] failed due to " + exception);
                        }
                        try {
                            annotatedElement = Class.forName("sun.net.www.http.HttpClient", false, (ClassLoader)object4);
                            field = ((Class)annotatedElement).getDeclaredField("kac");
                            field.setAccessible(true);
                            object3 = field.get(null);
                            if (object3 != null) {
                                object2 = object3.getClass().getDeclaredField("keepAliveTimer");
                                ((Field)object2).setAccessible(true);
                                object = (Thread)((Field)object2).get(object3);
                                if (object != null) {
                                    ((Thread)object).setContextClassLoader(null);
                                }
                                break block18;
                            }
                            System.err.println("Workaround [keepAlive] skiped");
                        }
                        catch (Exception exception) {
                            System.err.println("Workaround [keepAlive] failed due to " + exception);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public void destroy() {
        if (this.subApplet != null) {
            this.subApplet.destroy();
        }
        this.applyMemoryLeakWorkaround();
        System.runFinalization();
    }

    public Applet getSubApplet() {
        return this.subApplet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTmpRoot() throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            String string = System.getProperty("java.io.tmpdir") + File.separator + "jnlp-applet";
            tmpBaseDir = new File(string);
            tmpRootPropValue = System.getProperty("jnlp.applet.launcher.tmproot");
            if (tmpRootPropValue == null) {
                tmpBaseDir.mkdir();
                if (!tmpBaseDir.isDirectory()) {
                    throw new IOException("Cannot create directory " + tmpBaseDir);
                }
                File file = File.createTempFile("jln", ".tmp", tmpBaseDir);
                final FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                final FileLock fileLock = fileChannel.lock();
                String string2 = file.getAbsolutePath();
                String string3 = string2.substring(0, string2.lastIndexOf(".tmp"));
                String string4 = string3 + ".lck";
                File file2 = new File(string4);
                file2.createNewFile();
                final FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
                FileChannel fileChannel2 = fileOutputStream2.getChannel();
                final FileLock fileLock2 = fileChannel2.lock();
                tmpRootDir = new File(string3);
                if (!tmpRootDir.mkdir()) {
                    throw new IOException("Cannot create " + tmpRootDir);
                }
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            fileOutputStream.close();
                            fileLock.release();
                            fileOutputStream2.close();
                            fileLock2.release();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                thread.setContextClassLoader(null);
                Runtime.getRuntime().addShutdownHook(thread);
                tmpRootPropValue = string3.substring(string3.lastIndexOf(File.separator) + 1);
                System.setProperty("jnlp.applet.launcher.tmproot", tmpRootPropValue);
                Thread thread2 = new Thread(){

                    public void run() {
                        JNLPAppletLauncher.deleteOldTempDirs();
                    }
                };
                thread2.setName("AppletLauncher-Reaper");
                thread2.start();
            } else {
                if (tmpRootPropValue.indexOf(47) >= 0 || tmpRootPropValue.indexOf(File.separatorChar) >= 0) {
                    throw new IOException("Illegal value of: jnlp.applet.launcher.tmproot");
                }
                tmpRootDir = new File(tmpBaseDir, tmpRootPropValue);
                if (!tmpRootDir.isDirectory()) {
                    throw new IOException("Cannot access " + tmpRootDir);
                }
            }
        }
    }

    private static void deleteOldTempDirs() {
        final String string = tmpRootPropValue + ".lck";
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string2) {
                return string2.endsWith(".lck") && !string2.equals(string);
            }
        };
        String[] stringArray = tmpBaseDir.list(filenameFilter);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.lastIndexOf(".lck"));
                String string4 = string3 + ".tmp";
                File file = new File(tmpBaseDir, string2);
                File file2 = new File(tmpBaseDir, string4);
                File file3 = new File(tmpBaseDir, string3);
                if (!file.exists() || !file2.exists() || !file3.isDirectory()) continue;
                FileOutputStream fileOutputStream = null;
                FileChannel fileChannel = null;
                FileLock fileLock = null;
                try {
                    fileOutputStream = new FileOutputStream(file2);
                    fileChannel = fileOutputStream.getChannel();
                    fileLock = fileChannel.tryLock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fileLock == null) continue;
                FileOutputStream fileOutputStream2 = null;
                FileChannel fileChannel2 = null;
                FileLock fileLock2 = null;
                try {
                    fileOutputStream2 = new FileOutputStream(file);
                    fileChannel2 = fileOutputStream2.getChannel();
                    fileLock2 = fileChannel2.tryLock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fileLock2 != null) {
                    JNLPAppletLauncher.removeAll(file3);
                    try {
                        fileOutputStream2.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    file.delete();
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    file2.delete();
                    continue;
                }
                try {
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                    fileOutputStream.close();
                    fileLock.release();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static void removeAll(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                JNLPAppletLauncher.removeAll(fileArray[i]);
            }
        }
        file.delete();
    }

    private void initAndStartApplet() {
        try {
            this.initResources();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError(JNLPAppletLauncher.toErrorString(exception));
            return;
        }
        this.displayMessage("Starting applet " + this.subAppletDisplayName);
        this.setProgress(0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JNLPAppletLauncher.this.startSubApplet();
            }
        });
    }

    URL getJarBase() throws MalformedURLException {
        String string = JNLPAppletLauncher.class.getResource("").toString();
        if (string.startsWith("jar:")) {
            int n = string.indexOf(33);
            string = string.substring(4, n);
        }
        return new URL(string);
    }

    String getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("win")) {
            return "win";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("mac")) {
            return "mac";
        }
        if (string.startsWith("solaris") || string.startsWith("sunos")) {
            return "solaris";
        }
        return "other";
    }

    private boolean isNativeJarNeeded(String string) {
        String string2 = this.getParameter("javafx.unneeded");
        return string2 == null || !string2.contains(string);
    }

    private void addFXJars() {
        try {
            URL uRL = JNLPAppletLauncher.class.getResource("/nativejars.lst");
            InputStream inputStream = uRL.openStream();
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
            String string = this.getPlatform();
            String string2 = System.getProperty("os.arch");
            int n = 1;
            try {
                while (true) {
                    String string3 = propertyResourceBundle.getString("nativelib." + string + "." + string2 + "." + n + ".part");
                    String string4 = propertyResourceBundle.getString("nativelib." + string + "." + string2 + "." + n + ".file");
                    if (this.isNativeJarNeeded(string3)) {
                        this.addNativeJar(new URL(this.getJarBase(), string4));
                    }
                    ++n;
                }
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load hardcoded list of native FX jars " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResources() throws IOException {
        Class<JNLPAppletLauncher> clazz = JNLPAppletLauncher.class;
        synchronized (JNLPAppletLauncher.class) {
            if (firstApplet) {
                codeBase = this.getCodeBase();
                assert (codeBase != null);
                archive = this.getParameter("archive");
                if (archive == null || archive.length() == 0) {
                    throw new IllegalArgumentException("Missing archive parameter");
                }
                jarFiles = new HashSet<URL>();
                nativeJars = new HashSet<URL>();
                nativeLibMap = new HashMap<String, String>();
            } else {
                assert (this.getCodeBase().equals(codeBase));
                assert (this.getParameter("archive").equals(archive));
            }
            int n = -1;
            String string = this.getParameter("jnlpNumExtensions");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 0) {
                    throw new IllegalArgumentException("Missing or invalid jnlpNumExtensions parameter");
                }
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (int i = 1; i <= n; ++i) {
                String object = "jnlpExtension" + i;
                String string2 = this.getParameter(object);
                if (string2 == null || string2.length() == 0) {
                    throw new IllegalArgumentException("Missing " + object + " parameter");
                }
                URL uRL = new URL(string2);
                arrayList.add(uRL);
            }
            if (firstApplet) {
                this.createCacheBaseDir();
                this.createTmpDir();
                jnlpExtensions = arrayList;
                this.parseJNLPExtensions(arrayList);
                this.addFXJars();
                if (nativeJars.size() > 0) {
                    for (URL uRL : nativeJars) {
                        this.processNativeJar(uRL);
                    }
                }
                System.setProperty("sun.jnlp.applet.launcher", "true");
            } else if (!((Object)jnlpExtensions).equals(arrayList)) {
                throw new IllegalArgumentException("jnlpExtension parameters do not match previously loaded applet");
            }
            firstApplet = false;
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    private void createCacheBaseDir() throws IOException {
        String string = System.getProperty("os.name").toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home")).append(File.separator);
        if (string.startsWith("mac")) {
            stringBuffer.append("Library").append(File.separator).append("Caches").append(File.separator).append("Java").append(File.separator);
        } else if (string.startsWith("windows")) {
            stringBuffer.append("Sun").append(File.separator).append("Java").append(File.separator);
        } else {
            stringBuffer.append(".java").append(File.separator);
        }
        stringBuffer.append("jnlp-applet");
        cacheBaseDir = new File(stringBuffer.toString());
        if (!cacheBaseDir.isDirectory() && !cacheBaseDir.mkdirs()) {
            throw new IOException("Cannot create directory " + cacheBaseDir);
        }
        assert (cacheBaseDir.isDirectory());
    }

    private File createCacheDir(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? "" : string.substring(0, n);
        File file = new File(cacheBaseDir, JNLPAppletLauncher.sha1Hash(string2));
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Cannot create directory " + file);
        }
        assert (file.isDirectory());
        return file;
    }

    private static String sha1Hash(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        if (byArray == null || byArray.length == 0) {
            throw new RuntimeException("Error reading message digest");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    private void createTmpDir() throws IOException {
        File file = File.createTempFile("jln", ".tmp", tmpRootDir);
        String string = file.getAbsolutePath();
        String string2 = string.substring(0, string.lastIndexOf(".tmp"));
        nativeTmpDir = new File(string2);
        if (!nativeTmpDir.mkdir()) {
            throw new IOException("Cannot create " + nativeTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNativeJar(URL uRL) throws IOException {
        File file = this.createCacheDir(uRL);
        assert (file.isDirectory());
        assert (nativeTmpDir.isDirectory());
        String string = uRL.toExternalForm();
        String string2 = JNLPAppletLauncher.sha1Hash(string);
        File file2 = new File(file, string2 + ".jar");
        File file3 = new File(file, string2 + ".idx");
        this.displayMessage("Loading: " + string);
        this.setProgress(0);
        Closeable closeable = System.out;
        synchronized (closeable) {
            this.validateCache(uRL, file, file2, file3);
        }
        this.displayMessage("Unpacking: " + string);
        this.setProgress(0);
        closeable = null;
        closeable = new JarFile(file2);
        Set set = this.getRootEntries((JarFile)closeable);
        Set set2 = this.getNativeLibNames(set);
        this.validateCertificates((JarFile)closeable, set);
        this.extractNativeLibs((JarFile)closeable, set, set2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCache(URL uRL, File file, File file2, File file3) throws IOException {
        File file4 = new File(file, "cache.lck");
        file4.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file4);
        FileChannel fileChannel = fileOutputStream.getChannel();
        FileLock fileLock = fileChannel.lock();
        try {
            int n;
            long l = this.readExpiration(file3);
            if (l > System.currentTimeMillis()) {
                return;
            }
            long l2 = this.readTimeStamp(file3);
            URLConnection uRLConnection = uRL.openConnection();
            HttpURLConnection httpURLConnection = null;
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("GET");
            }
            if (l2 != -1L) {
                uRLConnection.setIfModifiedSince(l2);
            }
            boolean bl = false;
            if (uRLConnection instanceof HttpURLConnection) {
                uRLConnection = JNLPAppletLauncher.followRedirects(uRLConnection);
                bl = true;
            }
            if (!bl) {
                uRLConnection.connect();
            }
            if (httpURLConnection != null) {
                n = httpURLConnection.getResponseCode();
                if (n == 304) {
                    return;
                }
                if (n == 204) {
                    throw new IOException("HTTP connection: no content for " + uRL);
                }
                if (n >= 400) {
                    throw new IOException("HTTP connection failed for " + uRL);
                }
            }
            n = 0;
            long l3 = uRLConnection.getLastModified();
            if (l3 > 0L && l3 == l2) {
                n = 1;
            }
            if (n == 0) {
                file3.delete();
                file2.delete();
                int n2 = uRLConnection.getContentLength();
                int n3 = this.copyURLToFile(uRLConnection, file2);
                this.writeTimeStamp(file3, l3, uRLConnection.getExpiration());
            }
        }
        finally {
            fileLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readTimeStamp(File file) {
        long l;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            l = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                return -1L;
            }
        }
        bufferedReader.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readExpiration(File file) {
        long l;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            l = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                return -1L;
            }
        }
        bufferedReader.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimeStamp(File file, long l, long l2) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                bufferedWriter.write(Long.toString(l) + "\n");
                bufferedWriter.write(Long.toString(l2) + "\n");
                bufferedWriter.flush();
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            this.displayError("Error writing time stamp for native libraries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyURLToFile(URLConnection uRLConnection, File file) throws IOException {
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                n = this.copyStream(bufferedInputStream, bufferedOutputStream, uRLConnection.getContentLength());
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    private int copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        int n3 = 0;
        float f = 100.0f / (float)n;
        byte[] byArray = new byte[1000];
        this.setProgress(0);
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
            if (n <= 0) continue;
            this.setProgress(Math.round((float)n3 * f));
        }
        this.setProgress(100);
        return n3;
    }

    private Set getRootEntries(JarFile jarFile) {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (string.indexOf(47) != -1 || string.indexOf(File.separatorChar) != -1) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set getNativeLibNames(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            String string2 = string.toLowerCase();
            if (!string2.startsWith(nativePrefix) || !string2.endsWith(nativeSuffix)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private void validateCertificates(JarFile jarFile, Set set) throws IOException {
        byte[] byArray = new byte[1000];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (!set.contains(string) || this.checkNativeCertificates(jarFile, jarEntry, byArray)) continue;
            throw new IOException("Cannot validate certificate for " + string);
        }
    }

    private boolean checkNativeCertificates(JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException {
        int n;
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        int n2 = (int)jarEntry.getSize();
        while ((n = inputStream.read(byArray)) > 0) {
        }
        inputStream.close();
        Certificate[] certificateArray = JNLPAppletLauncher.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IOException("Cannot find certificates for JNLPAppletLauncher class");
        }
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return false;
        }
        int n3 = 0;
        block1: for (int i = 0; i < certificateArray.length; ++i) {
            for (int j = 0; j < certificateArray2.length; ++j) {
                if (!certificateArray2[j].equals(certificateArray[i])) continue;
                ++n3;
                continue block1;
            }
        }
        return n3 == certificateArray.length;
    }

    private void extractNativeLibs(JarFile jarFile, Set set, Set set2) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (!set.contains(string)) continue;
            int n = 0;
            if (string.startsWith(nativePrefix)) {
                n = nativePrefix.length();
            }
            String string2 = string.endsWith(nativeSuffix) ? string.substring(n, string.length() - nativeSuffix.length()) : string.substring(n);
            File file = new File(nativeTmpDir, string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n2 = this.copyStream(bufferedInputStream, bufferedOutputStream, -1);
            ((InputStream)bufferedInputStream).close();
            ((OutputStream)bufferedOutputStream).close();
            if (!set2.contains(string)) continue;
            nativeLibMap.put(string2, file.getAbsolutePath());
        }
    }

    private void startSubApplet() {
        try {
            this.subApplet = (Applet)Class.forName(this.subAppletClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
            this.subApplet.setStub(new AppletStubProxy());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            this.displayError("Class not found: " + this.subAppletClassName);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError("Unable to start " + this.subAppletDisplayName);
            return;
        }
        if (!this.haveUI) {
            this.setLayout(new BorderLayout());
        }
        this.add((Component)this.subApplet, "Center");
        try {
            this.subApplet.init();
            if (this.haveUI) {
                this.remove(this.loaderPanel);
            }
            this.validate();
            this.checkNoDDrawAndUpdateDeploymentProperties();
            this.subApplet.start();
            this.appletStarted = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadLibrary(String string) {
        String string2 = nativeLibMap.get(string);
        if (string2 == null) {
            throw new UnsatisfiedLinkError(string);
        }
        System.load(string2);
    }

    public static void removeLibrary(String string) {
        String string2 = nativeLibMap.get(string);
        if (string2 == null) {
            return;
        }
        new File(string2).delete();
        nativeLibMap.remove(string);
    }

    private static String toErrorString(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer(throwable.toString());
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuffer.append(": ").append(throwable2);
        }
        return stringBuffer.toString();
    }

    private void displayMessage(final String string) {
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.progressBar.setString(string);
                }
            });
        }
    }

    private void displayError(final String string) {
        Logger.getLogger("global").severe(string);
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.progressBar.setString("Error : " + string);
                }
            });
        }
    }

    private void setProgress(final int n) {
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.progressBar.setValue(n);
                }
            });
        }
    }

    private void initLoaderLayout() {
        this.setLayout(new BorderLayout());
        this.loaderPanel = new JPanel(new BorderLayout());
        if (this.getBooleanParameter("progressbar")) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setBorderPainted(true);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("Loading...");
        }
        boolean bl = false;
        ImageIcon imageIcon = null;
        if (this.subAppletImageURL != null) {
            imageIcon = new ImageIcon(this.subAppletImageURL);
            bl = true;
        }
        this.add((Component)this.loaderPanel, "South");
        if (bl) {
            this.loaderPanel.add((Component)new JLabel(imageIcon), "Center");
            if (this.progressBar != null) {
                this.loaderPanel.add((Component)this.progressBar, "South");
            }
        } else if (this.progressBar != null) {
            this.loaderPanel.add((Component)this.progressBar, "Center");
        }
    }

    private void parseJNLPExtensions(List list) throws IOException {
        for (URL uRL : list) {
            JNLPParser jNLPParser = new JNLPParser(this, uRL);
            jNLPParser.parse();
        }
    }

    private void addJarFile(URL uRL) {
        jarFiles.add(uRL);
    }

    private void addNativeJar(URL uRL) {
        nativeJars.add(uRL);
    }

    private static void printResources() {
        System.err.println("  Resources:");
        System.err.println("    Class Jars:");
        JNLPAppletLauncher.doPrint(jarFiles);
        System.err.println();
        System.err.println("    Native Jars:");
        JNLPAppletLauncher.doPrint(nativeJars);
    }

    private static void doPrint(Collection collection) {
        for (URL uRL : collection) {
            String string = uRL.toExternalForm();
            System.err.println("      " + string);
        }
    }

    private static boolean isJavaVersionAtLeast15() {
        return _atLeast15;
    }

    private static boolean isJavaVersion142Family() {
        return _javaVersionProperty.startsWith("1.4.2");
    }

    private boolean getBooleanParameter(String string) {
        return Boolean.valueOf(this.getParameter(string));
    }

    private String getDeploymentPropsDir() {
        String string = System.getProperty("os.name").toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        if (string.startsWith("windows")) {
            if (string.indexOf("vista") != -1) {
                stringBuffer.append(File.separator).append("AppData").append(File.separator).append("LocalLow");
            } else {
                stringBuffer.append(File.separator).append("Application Data");
            }
            stringBuffer.append(File.separator).append("Sun").append(File.separator).append("Java").append(File.separator).append("Deployment");
        } else if (string.startsWith("mac")) {
            stringBuffer.append(File.separator).append("Library").append(File.separator).append("Caches").append(File.separator).append("Java");
        } else {
            stringBuffer.append(File.separator).append(".java").append(File.separator).append("deployment");
        }
        return stringBuffer.toString();
    }

    private void checkNoDDrawAndUpdateDeploymentProperties() {
        if (!this.getBooleanParameter("noddraw.check")) {
            return;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !"true".equalsIgnoreCase(System.getProperty("sun.java2d.noddraw"))) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            JNLPAppletLauncher.this.updateDeploymentPropertiesImpl();
                        }
                    });
                }
                catch (Exception exception) {}
            } else {
                this.updateDeploymentPropertiesImpl();
            }
        }
    }

    private void updateDeploymentPropertiesImpl() {
        String string = System.getProperty("user.home");
        File file = new File(string + File.separator + ".jnlp-applet" + File.separator + DONT_ASK);
        if (file.exists()) {
            return;
        }
        int n = 0;
        if (!this.getBooleanParameter("noddraw.check.silent")) {
            n = JOptionPane.showOptionDialog(null, "For best robustness of OpenGL applets on Windows,\nwe recommend disabling Java2D's use of DirectDraw.\nThis setting will affect all applets, but is unlikely\nto slow other applets down significantly. May we update\nyour deployment.properties to turn off DirectDraw for\napplets? You can change this back later if necessary\nusing the Java Control Panel, Java tab, under Java\nApplet Runtime Settings.", "Update deployment.properties?", 1, 3, null, new Object[]{"Yes", "No", "No, Don't Ask Again"}, "Yes");
        }
        if (n < 0 || n == 1) {
            return;
        }
        if (n == 2) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            String string2;
            File file2 = new File(this.getDeploymentPropsDir());
            if (!file2.exists()) {
                return;
            }
            File file3 = new File(file2, "deployment.properties");
            if (!file3.exists()) {
                return;
            }
            Properties properties = new Properties();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file3));
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : properties.keySet()) {
                int n2;
                if (!string3.startsWith(JRE_PREFIX) || (n2 = string3.lastIndexOf(".")) < 0 || n2 <= JRE_PREFIX.length()) continue;
                string2 = string3.substring(JRE_PREFIX.length(), n2);
                hashSet.add(string2);
            }
            hashSet.add(System.getProperty("java.version"));
            for (String string3 : hashSet) {
                String string4 = JRE_PREFIX + string3 + ".args";
                string2 = properties.getProperty(string4);
                if (string2 == null) {
                    string2 = NODDRAW_PROP;
                } else if (string2.indexOf(NODDRAW_PROP) < 0) {
                    string2 = string2 + " " + NODDRAW_PROP;
                }
                properties.setProperty(string4, string2);
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            properties.store(bufferedOutputStream, null);
            ((OutputStream)bufferedOutputStream).close();
            if (!this.getBooleanParameter("noddraw.check.silent")) {
                JOptionPane.showMessageDialog(null, "For best robustness, we recommend you now exit and\nrestart your web browser. (Note: clicking \"OK\" will\nnot exit your browser.)", "Browser Restart Recommended", 1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getJnlpInputStream(URL uRL) throws IOException {
        File file = this.createCacheDir(uRL);
        assert (file.isDirectory());
        assert (nativeTmpDir.isDirectory());
        String string = uRL.toExternalForm();
        String string2 = JNLPAppletLauncher.sha1Hash(string);
        File file2 = new File(file, string2 + ".jnlp");
        File file3 = new File(file, string2 + ".jdx");
        this.displayMessage("Loading jnlp: " + string);
        try {
            Closeable closeable = System.out;
            synchronized (closeable) {
                this.validateCache(uRL, file, file2, file3);
            }
            closeable = new FileInputStream(file2);
            return closeable;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static HttpURLConnection followRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 305 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            JNLPAppletLauncher.cleanupConnection(httpURLConnection);
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException(uRLConnection.getURL() + " redirected to non-http URL");
        }
        return (HttpURLConnection)uRLConnection;
    }

    public static void cleanupConnection(URLConnection uRLConnection) {
        if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        try {
            InputStream inputStream;
            int n;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            String string = httpURLConnection.getHeaderField(null);
            String string2 = httpURLConnection.getHeaderField(CONNECTION_HEADER);
            if ((string2 != null && string2.equalsIgnoreCase(CONNECTION_KEEP_ALIVE) || string != null && string.startsWith(PROTOCOL_VERSION_1_1) && string2 == null) && (n = httpURLConnection.getResponseCode()) < 400 && (inputStream = httpURLConnection.getInputStream()) != null) {
                byte[] byArray = new byte[8192];
                while (inputStream.read(byArray) > 0) {
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        archive = null;
        staticInitError = false;
        System.err.println("JNLPAppletLauncher: static initializer");
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac")) {
            nativePrefix = "lib";
            nativeSuffix = ".jnilib";
        } else if (string.startsWith("windows")) {
            nativePrefix = "";
            nativeSuffix = ".dll";
        } else {
            nativePrefix = "lib";
            nativeSuffix = ".so";
        }
        try {
            JNLPAppletLauncher.initTmpRoot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            staticInitError = true;
        }
        _javaVersionProperty = System.getProperty("java.version");
        _atLeast13 = !_javaVersionProperty.startsWith("1.2");
        _atLeast14 = _atLeast13 && !_javaVersionProperty.startsWith("1.3");
        _atLeast15 = _atLeast14 && !_javaVersionProperty.startsWith("1.4");
        vendorURL = System.getProperty("java.vendor.url");
    }

    private class AppletStubProxy
    implements AppletStub {
        private AppletStubProxy() {
        }

        public boolean isActive() {
            return JNLPAppletLauncher.this.isActive();
        }

        public URL getDocumentBase() {
            return JNLPAppletLauncher.this.getDocumentBase();
        }

        public URL getCodeBase() {
            return JNLPAppletLauncher.this.getCodeBase();
        }

        public String getParameter(String string) {
            return JNLPAppletLauncher.this.getParameter(string);
        }

        public AppletContext getAppletContext() {
            return JNLPAppletLauncher.this.getAppletContext();
        }

        public void appletResize(int n, int n2) {
            JNLPAppletLauncher.this.resize(n, n2);
        }
    }

    private static class JNLPParser {
        private static final int INITIAL = 1;
        private static final int STARTED = 2;
        private static final int IN_JNLP = 3;
        private static final int IN_RESOURCES = 4;
        private static final int SKIP_ELEMENT = 5;
        private static SAXParserFactory factory;
        private static String systemOsName;
        private static String systemOsArch;
        private JNLPAppletLauncher launcher;
        private URL url;
        private InputStream in;
        private JNLPHandler handler;
        private URL codebase;
        private int state = 1;
        private int prevState = 1;
        private int depth = 0;
        private int skipDepth = -1;

        private JNLPParser(JNLPAppletLauncher jNLPAppletLauncher, URL uRL) throws IOException {
            this.launcher = jNLPAppletLauncher;
            this.url = uRL;
            this.in = jNLPAppletLauncher.getJnlpInputStream(uRL);
            this.handler = new JNLPHandler();
        }

        private void parse() throws IOException {
            try {
                SAXParser sAXParser = factory.newSAXParser();
                sAXParser.parse(this.in, (DefaultHandler)this.handler);
                this.in.close();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw (IOException)new IOException().initCause(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException().initCause(sAXException);
            }
        }

        static {
            if (JNLPAppletLauncher.sunVendorURL.equals(vendorURL) || JNLPAppletLauncher.appleVendorURL.equals(vendorURL)) {
                if (JNLPAppletLauncher.isJavaVersionAtLeast15()) {
                    System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
                } else if (JNLPAppletLauncher.isJavaVersion142Family()) {
                    System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.crimson.jaxp.SAXParserFactoryImpl");
                }
            }
            factory = SAXParserFactory.newInstance();
            systemOsName = System.getProperty("os.name").toLowerCase();
            systemOsArch = System.getProperty("os.arch").toLowerCase();
            if (systemOsArch != null && systemOsName != null && systemOsName.startsWith("linux") && systemOsArch.startsWith("x86")) {
                systemOsArch = "i386";
            }
        }

        private class JNLPHandler
        extends DefaultHandler {
            JNLPHandler() {
            }

            public void startDocument() {
                JNLPParser.this.state = 2;
            }

            public void endDocument() {
                JNLPParser.this.state = 1;
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                ++JNLPParser.this.depth;
                switch (JNLPParser.this.state) {
                    case 2: {
                        if (string3.equals("jnlp")) {
                            JNLPParser.this.state = 3;
                            String string4 = attributes.getValue("codebase");
                            if (string4 == null) {
                                throw new SAXException("<jnlp> unable to determine codebase");
                            }
                            if (string4.lastIndexOf(47) != string4.length() - 1) {
                                string4 = string4 + "/";
                            }
                            try {
                                JNLPParser.this.codebase = new URL(string4);
                                break;
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new SAXException("<jnlp> bad codebase: " + malformedURLException);
                            }
                        }
                        if (!string3.equals("resources")) break;
                        throw new SAXException("<resources> tag not within <jnlp> tag");
                    }
                    case 3: {
                        if (string3.equals("jnlp")) {
                            throw new SAXException("Nested <jnlp> tags");
                        }
                        if (!string3.equals("resources")) break;
                        String string5 = attributes.getValue("os");
                        String string6 = attributes.getValue("arch");
                        if ((string5 == null || systemOsName.startsWith(string5.toLowerCase())) && (string6 == null || systemOsArch.startsWith(string6.toLowerCase()))) {
                            JNLPParser.this.state = 4;
                            break;
                        }
                        JNLPParser.this.prevState = JNLPParser.this.state;
                        JNLPParser.this.skipDepth = JNLPParser.this.depth - 1;
                        JNLPParser.this.state = 5;
                        break;
                    }
                    case 4: {
                        try {
                            if (string3.equals("jnlp")) {
                                throw new SAXException("Nested <jnlp> tags");
                            }
                            if (string3.equals("resources")) {
                                throw new SAXException("Nested <resources> tags");
                            }
                            if (string3.equals("jar")) {
                                String string7 = attributes.getValue("href");
                                if (string7 == null || string7.length() == 0) {
                                    throw new SAXException("<jar> tag missing href attribute");
                                }
                                JNLPParser.this.launcher.addJarFile(new URL(JNLPParser.this.codebase, string7));
                                break;
                            }
                            if (string3.equals("nativelib")) {
                                String string8 = attributes.getValue("href");
                                if (string8 == null || string8.length() == 0) {
                                    throw new SAXException("<nativelib> tag missing href attribute");
                                }
                                String string9 = attributes.getValue("version");
                                if (string9 != null && string9.length() != 0) {
                                    string8 = string8 + "?version-id=" + string9;
                                }
                                JNLPParser.this.launcher.addNativeJar(new URL(JNLPParser.this.codebase, string8));
                                break;
                            }
                            if (string3.equals("extension")) {
                                String string10 = attributes.getValue("href");
                                if (string10 == null || string10.length() == 0) {
                                    throw new SAXException("<extension> tag missing href attribute");
                                }
                                String string11 = attributes.getValue("version");
                                if (string11 != null && string11.length() != 0) {
                                    string10 = string10 + "?version-id=" + string11;
                                }
                                URL uRL = new URL(JNLPParser.this.codebase, string10);
                                JNLPParser jNLPParser = new JNLPParser(JNLPParser.this.launcher, uRL);
                                jNLPParser.parse();
                                break;
                            }
                            JNLPParser.this.prevState = JNLPParser.this.state;
                            JNLPParser.this.skipDepth = JNLPParser.this.depth - 1;
                            JNLPParser.this.state = 5;
                            break;
                        }
                        catch (IOException iOException) {
                            throw (SAXException)new SAXException(iOException).initCause(iOException);
                        }
                    }
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                --JNLPParser.this.depth;
                switch (JNLPParser.this.state) {
                    case 3: {
                        if (!string3.equals("jnlp")) break;
                        JNLPParser.this.state = 2;
                        break;
                    }
                    case 4: {
                        if (!string3.equals("resources")) break;
                        JNLPParser.this.state = 3;
                        break;
                    }
                    case 5: {
                        if (JNLPParser.this.depth != JNLPParser.this.skipDepth) break;
                        JNLPParser.this.state = JNLPParser.this.prevState;
                        JNLPParser.this.skipDepth = -1;
                        break;
                    }
                }
            }
        }
    }
}

