/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.progressbar;

import com.javafx.progressbar.Callback;
import com.javafx.progressbar.EdtTimer;
import com.javafx.progressbar.Logger;
import com.javafx.progressbar.ProgressBar;
import java.applet.AppletStub;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import javax.jnlp.DownloadServiceListener;
import javax.swing.JFrame;
import netscape.javascript.JSObject;

public class ProgressManager
implements DownloadServiceListener,
Callback {
    private JFrame frame;
    private AppletStub stub = null;
    private static ProgressManager theInstance = null;
    private boolean needToHideOverlay = false;
    private int rescaleBound = -1;
    private static Point point = new Point();
    private PercentageSmoother percentageSmoother;
    private ProgressBar progressBar;

    public static ProgressManager getInstance() {
        return theInstance;
    }

    public ProgressManager() {
        Logger.info("Loading....JNLP Mode");
        theInstance = this;
        this.percentageSmoother = new PercentageSmoother();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProgressManager.this.frame = new JFrame("Loading");
                ProgressManager.this.frame.setUndecorated(true);
                ProgressManager.this.frame.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        point.x = mouseEvent.getX();
                        point.y = mouseEvent.getY();
                    }

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (ProgressManager.this.frame.getWidth() - mouseEvent.getX() < 22 && mouseEvent.getY() < 18) {
                            System.exit(0);
                        }
                    }
                });
                ProgressManager.this.frame.addMouseMotionListener(new MouseMotionAdapter(){

                    public void mouseDragged(MouseEvent mouseEvent) {
                        Point point = ProgressManager.this.frame.getLocation();
                        ProgressManager.this.frame.setLocation(point.x + mouseEvent.getX() - point.x, point.y + mouseEvent.getY() - point.y);
                    }
                });
                ProgressManager.this.progressBar = new ProgressBar(ProgressManager.getInstance());
                ProgressManager.this.frame.add(ProgressManager.this.progressBar);
                ProgressManager.this.frame.pack();
                Insets insets = ProgressManager.this.frame.getInsets();
                ProgressManager.this.frame.setSize(ProgressManager.this.progressBar.getWidth() + insets.left + insets.right, ProgressManager.this.progressBar.getHeight() + insets.top + insets.bottom);
                ProgressManager.this.frame.setResizable(false);
                ProgressManager.this.frame.setLocationRelativeTo(null);
                ProgressManager.this.frame.setDefaultCloseOperation(3);
            }
        });
    }

    private synchronized void hideOverlay() {
        if (this.needToHideOverlay) {
            try {
                String string = this.stub.getParameter("deployJavaAppletID");
                if (string != null && !"".equals(string)) {
                    JSObject jSObject = JSObject.getWindow(null);
                    if (jSObject != null) {
                        jSObject.call("fxAppletHideSplash", string);
                    }
                    this.needToHideOverlay = false;
                }
            }
            catch (Exception exception) {
                Logger.error("Failed to hide FX overlay! ", exception);
            }
        }
    }

    public ProgressManager(Object object) {
        this(object, null);
        Logger.info("Applet JNLP MODE...");
    }

    public ProgressManager(Object object, Object object2) {
        this.stub = (AppletStub)object2;
        theInstance = this;
        this.percentageSmoother = new PercentageSmoother();
        if (object instanceof Container) {
            Container container = (Container)object;
            this.progressBar = new ProgressBar(this.stub, this);
            container.add(this.progressBar);
            this.needToHideOverlay = true;
            this.hideOverlay();
        } else {
            Logger.error("The containerObject value is not a Container");
        }
    }

    public final void progress(URL uRL, String string, long l, long l2, final int n) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (n < 100 && ProgressManager.this.frame != null && !ProgressManager.this.frame.isVisible()) {
                    Logger.info("overallPercent: " + n);
                    ProgressManager.this.frame.setVisible(true);
                }
                int n2 = ProgressManager.this.rescale(n);
                System.err.println("IIII: " + n2);
                ProgressManager.this.percentageSmoother.updateOverallPercent(n2);
            }
        });
    }

    public final void upgradingArchive(URL uRL, String string, int n, final int n2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProgressManager.this.progressBar.progress(ProgressManager.this.rescale(n2));
            }
        });
    }

    public final void validating(URL uRL, String string, long l, long l2, final int n) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProgressManager.this.progressBar.progress(ProgressManager.this.rescale(n));
            }
        });
    }

    public void downloadFailed(URL uRL, String string) {
        Logger.error("Download failed");
    }

    public void done() {
        Logger.info("Download Completed");
        if (this.frame != null && this.frame.isVisible()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ProgressManager.this.frame.setVisible(false);
                    ProgressManager.this.frame.dispose();
                    ProgressManager.this.frame = null;
                }
            });
        }
    }

    private int rescale(int n) {
        if (this.rescaleBound == -1) {
            this.rescaleBound = n;
            return 0;
        }
        if (this.rescaleBound == 100) {
            return 100;
        }
        if (n < this.rescaleBound) {
            return 0;
        }
        int n2 = 100 * (n - this.rescaleBound) / (100 - this.rescaleBound);
        return n2;
    }

    private class PercentageSmoother {
        private EdtTimer timer = null;
        private final long startTime = System.currentTimeMillis();
        private long estimatedCompletionTime = this.startTime + 60000L;
        private int overallPercent;
        private int notifiedOverallPercent;

        private void startTimer() {
            if (this.timer == null) {
                this.timer = new EdtTimer(new Runnable(){

                    public void run() {
                        if (PercentageSmoother.this.notifiedOverallPercent >= PercentageSmoother.this.overallPercent + 10 || PercentageSmoother.this.notifiedOverallPercent > 99) {
                            return;
                        }
                        int n = (int)((System.currentTimeMillis() - PercentageSmoother.this.startTime) * 100L / (PercentageSmoother.this.estimatedCompletionTime - PercentageSmoother.this.startTime));
                        if (PercentageSmoother.this.notifiedOverallPercent >= n) {
                            return;
                        }
                        if (n - PercentageSmoother.this.notifiedOverallPercent > 30) {
                            PercentageSmoother.this.notifiedOverallPercent += 5;
                        } else {
                            PercentageSmoother.this.notifiedOverallPercent++;
                        }
                        ProgressManager.this.progressBar.progress(PercentageSmoother.this.notifiedOverallPercent);
                        if (ProgressManager.this.frame != null && ProgressManager.this.frame.isVisible()) {
                            ProgressManager.this.frame.setTitle(PercentageSmoother.this.notifiedOverallPercent + "% Loading");
                        }
                    }
                }, 50L);
            }
        }

        private PercentageSmoother() {
        }

        public void updateOverallPercent(int n) {
            if (n <= this.overallPercent) {
                return;
            }
            this.startTimer();
            this.overallPercent = n;
            long l = System.currentTimeMillis();
            this.estimatedCompletionTime = this.startTime + (l - this.startTime) * 100L / (long)n;
        }
    }
}

