uniform float jsl_pixCoordYOffset;
vec2 pixcoord = vec2(gl_FragCoord.x, jsl_pixCoordYOffset-gl_FragCoord.y);
uniform vec2 jsl_posValueYFlip;
vec4 jsl_sample(sampler2D img, vec2 pos) {
    pos.y = (jsl_posValueYFlip.x - pos.y) * jsl_posValueYFlip.y;
    return texture2D(img, pos);
}
uniform sampler2D botImg;
uniform sampler2D topImg;
uniform float opacity;
vec4 blend_hard_light(vec4 bot, vec4 top) {
vec3 lumCoeff = vec3(0.2125, 0.7154, 0.0721);
float lum = dot(top.rgb, lumCoeff);
vec4 res;
if (lum < 0.45){
res.rgb = 2.0 * top.rgb * bot.rgb;
}
 else if (lum > 0.55){
res.rgb = 1.0 - (2.0 * (1.0 - top.rgb) * (1.0 - bot.rgb));
}
 else {
vec3 res1 = 2.0 * top.rgb * bot.rgb;
vec3 res2 = 1.0 - (2.0 * (1.0 - top.rgb) * (1.0 - bot.rgb));
res.rgb = mix(res1, res2, (lum - 0.45) * 10.0);
}
res.rgb = bot.rgb + (res.rgb - bot.rgb) * top.a;
res.a = bot.a + top.a - (bot.a * top.a);
return res;
}
void main() {
vec4 bot = jsl_sample(botImg, gl_TexCoord[0].st);
vec4 top = jsl_sample(topImg, gl_TexCoord[1].st) * opacity;
gl_FragColor = blend_hard_light(bot, top);
}
