uniform float jsl_pixCoordYOffset;
vec2 pixcoord = vec2(gl_FragCoord.x, jsl_pixCoordYOffset-gl_FragCoord.y);
uniform vec2 jsl_posValueYFlip;
vec4 jsl_sample(sampler2D img, vec2 pos) {
    pos.y = (jsl_posValueYFlip.x - pos.y) * jsl_posValueYFlip.y;
    return texture2D(img, pos);
}
uniform sampler2D bumpImg;
uniform sampler2D origImg;
uniform float surfaceScale;
uniform float diffuseConstant;
uniform float specularConstant;
uniform float specularExponent;
uniform vec3 lightColor;
uniform vec4 kvals[9];
uniform vec3 lightPosition;
uniform vec3 normalizedLightDirection;
uniform float lightSpecularExponent;
void main() {
vec4 orig = jsl_sample(origImg, gl_TexCoord[1].st);
int i;
vec2 sum = vec2(0.0, 0.0);
for (i = 0;
i < 9;++i){
sum += kvals[i].zw * jsl_sample(bumpImg, gl_TexCoord[0].st + kvals[i].xy).a;
}
float factor = 0.25;
sum *= -surfaceScale * factor;
vec3 N = normalize(vec3(sum.x, sum.y, 1.0));
float bumpA = jsl_sample(bumpImg, gl_TexCoord[0].st).a;
vec3 tmp = vec3(pixcoord.x, pixcoord.y, surfaceScale * bumpA);
vec3 Lxyz = normalize(lightPosition - tmp);
float LdotS = dot(Lxyz, normalizedLightDirection);
LdotS = min(LdotS, 0.0);
vec3 Lrgb = lightColor * pow(-LdotS, lightSpecularExponent);
vec3 E = vec3(0.0, 0.0, 1.0);
vec3 H = normalize(Lxyz + E);
vec4 D;
D.rgb = diffuseConstant * dot(N, Lxyz) * Lrgb;
D.rgb = clamp(D.rgb, 0.0, 1.0);
D.a = 1.0;
vec4 S;
float NdotH = dot(N, H);
S.rgb = specularConstant * pow(NdotH, specularExponent) * Lrgb;
S.a = max(S.r, S.g);
S.a = max(S.a, S.b);
orig *= D;
S *= orig.a;
gl_FragColor = S + (orig * (1.0 - S.a));
}
