/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.xml;

import com.sun.javafx.data.pull.impl.EventType;
import com.sun.javafx.data.pull.impl.Position;
import com.sun.javafx.data.pull.impl.StreamException;
import com.sun.javafx.data.pull.ukit.xml.Pair;
import com.sun.javafx.data.pull.ukit.xml.ParserStAX;
import java.io.IOException;
import java.util.NoSuchElementException;

final class DTDStreamReaderImp
implements EventType,
Position {
    private Pair mEQhead;
    private Pair mEQtail;
    private ParserStAX mStream;

    DTDStreamReaderImp(ParserStAX parserStAX, Pair pair) {
        if (parserStAX == null || pair == null) {
            throw new NullPointerException();
        }
        this.mStream = parserStAX;
        this.eqAdd(pair);
        this.mEQhead.id = 1001;
    }

    public int next() throws StreamException {
        if (this.getEventType() == 1002) {
            throw new NoSuchElementException();
        }
        if (this.mEQhead.list != null) {
            this.mStream.del(this.mEQhead.list);
        }
        this.mStream.del(this.eqGet());
        if (this.mEQhead != null) {
            return this.mEQhead.id;
        }
        try {
            switch (this.mStream.step()) {
                case 8: {
                    this.mEQhead.id = 5;
                    break;
                }
                case 6: {
                    this.mEQhead.id = 3;
                    break;
                }
                case 12: {
                    this.mEQhead.id = 15;
                    break;
                }
                case 13: {
                    this.mEQhead.id = 1003;
                    break;
                }
                case 14: {
                    this.mEQhead.id = 14;
                    break;
                }
                case 10: {
                    this.mStream.mPh = 3;
                    Pair pair = this.mStream.pair(null);
                    pair.id = 1002;
                    this.eqAdd(pair);
                    break;
                }
                default: {
                    throw new StreamException();
                }
            }
        }
        catch (StreamException streamException) {
            throw streamException;
        }
        catch (IOException iOException) {
            throw new StreamException(iOException.toString());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new StreamException(exception.toString());
        }
        return this.mEQhead.id;
    }

    public boolean hasNext() throws StreamException {
        return this.getEventType() != 1002;
    }

    public int getEventType() {
        return this.mStream.mDTD != null ? this.mEQhead.id : 1002;
    }

    public String getText() {
        switch (this.getEventType()) {
            case 15: {
                if (this.mEQhead.num < 0) {
                    return null;
                }
            }
            case 5: {
                if (this.mEQhead.value == null) {
                    this.mEQhead.value = new String(this.mEQhead.chars, 0, this.mEQhead.num);
                }
                return this.mEQhead.value;
            }
        }
        throw new IllegalStateException();
    }

    public char[] getTextCharacters() {
        switch (this.getEventType()) {
            case 5: 
            case 15: {
                return this.mEQhead.chars;
            }
        }
        throw new IllegalStateException();
    }

    public int getTextStart() {
        switch (this.getEventType()) {
            case 5: 
            case 15: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    public int getTextLength() {
        switch (this.getEventType()) {
            case 5: 
            case 15: {
                return this.mEQhead.num;
            }
        }
        throw new IllegalStateException();
    }

    public Position getLocation() {
        return this;
    }

    public String getPublicId() {
        return this.mStream.getPublicId();
    }

    public String getSystemId() {
        return this.mStream.getSystemId();
    }

    public int line() {
        return this.mStream.getEventType() == 11 ? this.mStream.line() : -1;
    }

    public int column() {
        return this.mStream.getEventType() == 11 ? this.mStream.column() : -1;
    }

    public int getCharacterOffset() {
        return this.mStream.getEventType() == 11 ? this.mStream.getCharacterOffset() : -1;
    }

    public String getPITarget() {
        if (this.getEventType() != 3) {
            throw new IllegalStateException();
        }
        return this.mEQhead.name;
    }

    public String getPIData() {
        if (this.getEventType() != 3) {
            throw new IllegalStateException();
        }
        return this.mEQhead.value;
    }

    public String getName() {
        switch (this.getEventType()) {
            case 14: 
            case 15: 
            case 1001: 
            case 1003: {
                return this.mEQhead.name;
            }
        }
        throw new IllegalStateException();
    }

    public String getPublicIdentifier() {
        switch (this.getEventType()) {
            case 15: {
                if (this.mEQhead.num >= 0) {
                    return null;
                }
            }
            case 14: 
            case 1001: 
            case 1003: {
                return this.mEQhead.list.name;
            }
        }
        throw new IllegalStateException();
    }

    public String getSystemIdentifier() {
        switch (this.getEventType()) {
            case 15: {
                if (this.mEQhead.num >= 0) {
                    return null;
                }
            }
            case 14: 
            case 1001: 
            case 1003: {
                return this.mEQhead.list.value;
            }
        }
        throw new IllegalStateException();
    }

    public String getNotationName() {
        switch (this.getEventType()) {
            case 1003: {
                return this.mEQhead.value;
            }
        }
        throw new IllegalStateException();
    }

    public void close() throws StreamException {
        while (this.hasNext()) {
            this.next();
        }
    }

    void eqAdd(Pair pair) {
        pair.next = null;
        if (this.mEQtail != null) {
            this.mEQtail.next = pair;
        } else {
            this.mEQhead = pair;
        }
        this.mEQtail = pair;
    }

    Pair eqGet() {
        Pair pair = this.mEQhead;
        if (pair != null) {
            this.mEQhead = pair.next;
            pair.next = null;
        }
        if (this.mEQhead == null) {
            this.mEQtail = null;
        }
        return pair;
    }
}

