/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.xml;

import com.sun.javafx.data.pull.impl.StreamException;
import com.sun.javafx.data.pull.impl.StreamReader;
import com.sun.javafx.data.pull.ukit.xml.ParserStAX;
import java.io.InputStream;
import java.io.Reader;

public class XMLInputFactoryImp {
    public static final String IS_COALESCING = "javax.xml.stream.isCoalescing";
    public static final String IS_NAMESPACE_AWARE = "javax.xml.stream.isNamespaceAware";
    public static final String IS_REPLACING_ENTITY_REFERENCES = "javax.xml.stream.isReplacingEntityReferences";
    public static final String IS_SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";
    public static final String IS_VALIDATING = "javax.xml.stream.isValidating";
    public static final String RESOLVER = "javax.xml.stream.resolver";
    public static final String SUPPORT_DTD = "javax.xml.stream.supportDTD";
    boolean mIsNSAware = true;
    boolean mIsExtEnt;

    public StreamReader createStreamReader(Reader reader) throws StreamException {
        ParserStAX parserStAX = new ParserStAX(reader);
        parserStAX.mIsNSAware = this.mIsNSAware;
        return parserStAX;
    }

    public StreamReader createStreamReader(InputStream inputStream) throws StreamException {
        ParserStAX parserStAX = new ParserStAX(inputStream, null);
        parserStAX.mIsNSAware = this.mIsNSAware;
        return parserStAX;
    }

    public StreamReader createStreamReader(InputStream inputStream, String string) throws StreamException {
        if (string == null) {
            throw new NullPointerException("");
        }
        ParserStAX parserStAX = new ParserStAX(inputStream, string);
        parserStAX.mIsNSAware = this.mIsNSAware;
        return parserStAX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (IS_VALIDATING.equals(string)) {
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) return;
            throw new IllegalArgumentException(string);
        }
        if (IS_NAMESPACE_AWARE.equals(string)) {
            if (!(object instanceof Boolean)) throw new IllegalArgumentException(string);
            this.mIsNSAware = (Boolean)object;
            return;
        } else {
            if (IS_COALESCING.equals(string)) {
                if (object instanceof Boolean && !((Boolean)object).booleanValue()) return;
                throw new IllegalArgumentException(string);
            }
            if (IS_REPLACING_ENTITY_REFERENCES.equals(string)) {
                if (object instanceof Boolean && ((Boolean)object).booleanValue()) return;
                throw new IllegalArgumentException(string);
            }
            if (IS_SUPPORTING_EXTERNAL_ENTITIES.equals(string)) {
                if (!(object instanceof Boolean)) throw new IllegalArgumentException(string);
                this.mIsExtEnt = (Boolean)object;
                return;
            } else {
                if (!SUPPORT_DTD.equals(string)) throw new IllegalArgumentException(string);
                if (object instanceof Boolean && ((Boolean)object).booleanValue()) return;
                throw new IllegalArgumentException(string);
            }
        }
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (IS_VALIDATING.equals(string)) {
            return Boolean.FALSE;
        }
        if (IS_NAMESPACE_AWARE.equals(string)) {
            return this.mIsNSAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (IS_COALESCING.equals(string)) {
            return Boolean.FALSE;
        }
        if (IS_REPLACING_ENTITY_REFERENCES.equals(string)) {
            return Boolean.TRUE;
        }
        if (IS_SUPPORTING_EXTERNAL_ENTITIES.equals(string)) {
            return this.mIsExtEnt ? Boolean.TRUE : Boolean.FALSE;
        }
        if (SUPPORT_DTD.equals(string)) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(string);
    }

    public boolean isPropertySupported(String string) {
        if (IS_VALIDATING.equals(string)) {
            return true;
        }
        if (IS_NAMESPACE_AWARE.equals(string)) {
            return true;
        }
        if (IS_COALESCING.equals(string)) {
            return true;
        }
        if (IS_REPLACING_ENTITY_REFERENCES.equals(string)) {
            return true;
        }
        if (IS_SUPPORTING_EXTERNAL_ENTITIES.equals(string)) {
            return true;
        }
        if (SUPPORT_DTD.equals(string)) {
            return true;
        }
        return RESOLVER.equals(string);
    }
}

