/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.AreaIterator;
import com.sun.javafx.geom.AreaOp;
import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Crossings;
import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.Enumeration;
import java.util.Vector;

public class Area
extends Shape {
    private static Vector EmptyCurves = new Vector();
    private Vector curves;
    private Bounds2D cachedBounds;

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(Shape shape) {
        this.curves = shape instanceof Area ? ((Area)shape).curves : Area.pathToCurves(shape.getPathIterator(null));
    }

    public Area(PathIterator pathIterator) {
        this.curves = Area.pathToCurves(pathIterator);
    }

    private static Vector pathToCurves(PathIterator pathIterator) {
        Vector vector = new Vector();
        int n = pathIterator.getWindingRule();
        float[] fArray = new float[23];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    Curve.insertLine(vector, f3, f4, f, f2);
                    f3 = f = fArray[0];
                    f4 = f2 = fArray[1];
                    Curve.insertMove(vector, f, f2);
                    break;
                }
                case 1: {
                    float f5 = fArray[0];
                    float f6 = fArray[1];
                    Curve.insertLine(vector, f3, f4, f5, f6);
                    f3 = f5;
                    f4 = f6;
                    break;
                }
                case 2: {
                    float f5 = fArray[2];
                    float f6 = fArray[3];
                    Curve.insertQuad(vector, f3, f4, fArray);
                    f3 = f5;
                    f4 = f6;
                    break;
                }
                case 3: {
                    float f5 = fArray[4];
                    float f6 = fArray[5];
                    Curve.insertCubic(vector, f3, f4, fArray);
                    f3 = f5;
                    f4 = f6;
                    break;
                }
                case 4: {
                    Curve.insertLine(vector, f3, f4, f, f2);
                    f3 = f;
                    f4 = f2;
                }
            }
            pathIterator.next();
        }
        Curve.insertLine(vector, f3, f4, f, f2);
        AreaOp areaOp = n == 0 ? new AreaOp.EOWindOp() : new AreaOp.NZWindOp();
        return areaOp.calculate(vector, EmptyCurves);
    }

    public void add(Area area) {
        this.curves = new AreaOp.AddOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void subtract(Area area) {
        this.curves = new AreaOp.SubOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void intersect(Area area) {
        this.curves = new AreaOp.IntOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void exclusiveOr(Area area) {
        this.curves = new AreaOp.XorOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void reset() {
        this.curves = new Vector();
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    public boolean isPolygonal() {
        Enumeration enumeration = this.curves.elements();
        while (enumeration.hasMoreElements()) {
            if (((Curve)enumeration.nextElement()).getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        int n = this.curves.size();
        if (n == 0) {
            return true;
        }
        if (n > 3) {
            return false;
        }
        Curve curve = (Curve)this.curves.get(1);
        Curve curve2 = (Curve)this.curves.get(2);
        if (curve.getOrder() != 1 || curve2.getOrder() != 1) {
            return false;
        }
        if (curve.getXTop() != curve.getXBot() || curve2.getXTop() != curve2.getXBot()) {
            return false;
        }
        return curve.getYTop() == curve2.getYTop() && curve.getYBot() == curve2.getYBot();
    }

    public boolean isSingular() {
        if (this.curves.size() < 3) {
            return true;
        }
        Enumeration enumeration = this.curves.elements();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            if (((Curve)enumeration.nextElement()).getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    private void invalidateBounds() {
        this.cachedBounds = null;
    }

    private Bounds2D getCachedBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        Bounds2D bounds2D = new Bounds2D();
        if (this.curves.size() > 0) {
            Curve curve = (Curve)this.curves.get(0);
            bounds2D.setBounds(curve.getX0(), curve.getY0(), 0.0f, 0.0f);
            for (int i = 1; i < this.curves.size(); ++i) {
                ((Curve)this.curves.get(i)).enlarge(bounds2D);
            }
        }
        this.cachedBounds = bounds2D;
        return this.cachedBounds;
    }

    public Bounds2D getBounds2D() {
        return new Bounds2D(this.getCachedBounds());
    }

    public boolean equals(Area area) {
        if (area == this) {
            return true;
        }
        if (area == null) {
            return false;
        }
        Vector vector = new AreaOp.XorOp().calculate(this.curves, area.curves);
        return vector.isEmpty();
    }

    public void transform(BaseTransform baseTransform) {
        if (baseTransform == null) {
            throw new NullPointerException("transform must not be null");
        }
        this.curves = Area.pathToCurves(this.getPathIterator(baseTransform));
        this.invalidateBounds();
    }

    public Area createTransformedArea(BaseTransform baseTransform) {
        Area area = new Area(this);
        area.transform(baseTransform);
        return area;
    }

    public boolean contains(float f, float f2) {
        if (!this.getCachedBounds().contains(f, f2)) {
            return false;
        }
        Enumeration enumeration = this.curves.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            n += curve.crossingsFor(f, f2);
        }
        return n & true;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.x, point2D.y);
    }

    public boolean contains(float f, float f2, float f3, float f4) {
        if (f3 < 0.0f || f4 < 0.0f) {
            return false;
        }
        if (!this.getCachedBounds().contains(f, f2, f3, f4)) {
            return false;
        }
        Crossings crossings = Crossings.findCrossings(this.curves, f, f2, f + f3, f2 + f4);
        return crossings != null && crossings.covers(f2, f2 + f4);
    }

    public boolean intersects(float f, float f2, float f3, float f4) {
        if (f3 < 0.0f || f4 < 0.0f) {
            return false;
        }
        if (!this.getCachedBounds().intersects(f, f2, f3, f4)) {
            return false;
        }
        Crossings crossings = Crossings.findCrossings(this.curves, f, f2, f + f3, f2 + f4);
        return crossings == null || !crossings.isEmpty();
    }

    public PathIterator getPathIterator(BaseTransform baseTransform) {
        return new AreaIterator(this.curves, baseTransform);
    }

    public PathIterator getPathIterator(BaseTransform baseTransform, float f) {
        return new FlatteningPathIterator(this.getPathIterator(baseTransform), f);
    }

    public Area copy() {
        return new Area(this);
    }
}

