/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;

public class Bounds2D {
    public float x1;
    public float y1;
    public float x2;
    public float y2;
    private boolean invalid;

    public Bounds2D() {
        this.invalid = true;
    }

    public Bounds2D(float f, float f2, float f3, float f4) {
        this.setBounds(f, f2, f3, f4);
    }

    public Bounds2D(Bounds2D bounds2D) {
        this.setBounds(bounds2D);
    }

    public Bounds2D(Rectangle rectangle) {
        this.setBounds(rectangle);
    }

    public float getWidth() {
        return this.x2 - this.x1;
    }

    public float getHeight() {
        return this.y2 - this.y1;
    }

    public void setBounds(Bounds2D bounds2D) {
        this.x1 = bounds2D.x1;
        this.y1 = bounds2D.y1;
        this.x2 = bounds2D.x2;
        this.y2 = bounds2D.y2;
        this.invalid = false;
    }

    public void setBounds(float f, float f2, float f3, float f4) {
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
        this.invalid = false;
    }

    public void setBounds(Rectangle rectangle) {
        this.x1 = rectangle.x;
        this.y1 = rectangle.y;
        this.x2 = this.x1 + (float)rectangle.width;
        this.y2 = this.y1 + (float)rectangle.height;
        this.invalid = false;
    }

    public void setFromDiagonal(float f, float f2, float f3, float f4) {
        this.setBounds(f, f2, f3, f4);
        this.normalize();
    }

    public void setFromDiagonal(Point2D point2D, Point2D point2D2) {
        this.setFromDiagonal(point2D.x, point2D.y, point2D2.x, point2D2.y);
    }

    public void unionWith(Bounds2D bounds2D) {
        this.x1 = Math.min(this.x1, bounds2D.x1);
        this.y1 = Math.min(this.y1, bounds2D.y1);
        this.x2 = Math.max(this.x2, bounds2D.x2);
        this.y2 = Math.max(this.y2, bounds2D.y2);
    }

    public void unionWith(float f, float f2, float f3, float f4) {
        this.x1 = Math.min(this.x1, f);
        this.y1 = Math.min(this.y1, f2);
        this.x2 = Math.max(this.x2, f3);
        this.y2 = Math.max(this.y2, f4);
    }

    public void add(float f, float f2) {
        this.unionWith(f, f2, f, f2);
    }

    public void add(Point2D point2D) {
        this.add(point2D.x, point2D.y);
    }

    public void intersectWith(Bounds2D bounds2D) {
        this.x1 = Math.max(this.x1, bounds2D.x1);
        this.y1 = Math.max(this.y1, bounds2D.y1);
        this.x2 = Math.min(this.x2, bounds2D.x2);
        this.y2 = Math.min(this.y2, bounds2D.y2);
    }

    public void intersectWith(Rectangle rectangle) {
        float f = rectangle.x;
        float f2 = rectangle.y;
        this.intersectWith(f, f2, f + (float)rectangle.width, f2 + (float)rectangle.height);
    }

    public void intersectWith(float f, float f2, float f3, float f4) {
        this.x1 = Math.max(this.x1, f);
        this.y1 = Math.max(this.y1, f2);
        this.x2 = Math.min(this.x2, f3);
        this.y2 = Math.min(this.y2, f4);
    }

    public boolean contains(float f, float f2) {
        if (this.isEmpty()) {
            return false;
        }
        return f >= this.x1 && f <= this.x2 && f2 >= this.y1 && f2 <= this.y2;
    }

    public boolean contains(float f, float f2, float f3, float f4) {
        if (this.isEmpty()) {
            return false;
        }
        return this.contains(f, f2) && this.contains(f + f3, f2 + f4);
    }

    public boolean intersects(float f, float f2, float f3, float f4) {
        if (this.isEmpty()) {
            return false;
        }
        return f + f3 > this.x1 && f2 + f4 > this.y1 && f < this.x2 && f2 < this.y2;
    }

    public boolean intersects(Bounds2D bounds2D) {
        if (this.isEmpty()) {
            return false;
        }
        return bounds2D.x2 > this.x1 && bounds2D.y2 > this.y1 && bounds2D.x1 < this.x2 && bounds2D.y1 < this.y2;
    }

    public boolean disjoint(float f, float f2, float f3, float f4) {
        if (this.isEmpty()) {
            return true;
        }
        return f + f3 < this.x1 || f2 + f4 < this.y1 || f > this.x2 || f2 > this.y2;
    }

    public boolean disjoint(Bounds2D bounds2D) {
        if (this.isEmpty()) {
            return true;
        }
        return bounds2D.x2 < this.x1 || bounds2D.y2 < this.y1 || bounds2D.x1 > this.x2 || bounds2D.y1 > this.y2;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public Bounds2D invalidate() {
        this.y2 = 0.0f;
        this.x2 = 0.0f;
        this.y1 = 0.0f;
        this.x1 = 0.0f;
        this.invalid = true;
        return this;
    }

    public boolean isEmpty() {
        return this.x2 <= this.x1 || this.y2 <= this.y1;
    }

    public void roundOut() {
        this.x1 = (float)Math.floor(this.x1);
        this.y1 = (float)Math.floor(this.y1);
        this.x2 = (float)Math.ceil(this.x2);
        this.y2 = (float)Math.ceil(this.y2);
    }

    public void grow(float f, float f2) {
        this.x1 -= f;
        this.x2 += f;
        this.y1 -= f2;
        this.y2 += f2;
    }

    public Bounds2D makeEmpty() {
        this.y2 = 0.0f;
        this.x2 = 0.0f;
        this.y1 = 0.0f;
        this.x1 = 0.0f;
        this.invalid = false;
        return this;
    }

    public void normalize() {
        float f;
        if (this.x1 > this.x2) {
            f = this.x2;
            this.x2 = this.x1;
            this.x1 = f;
        }
        if (this.y1 > this.y2) {
            f = this.y2;
            this.y2 = this.y1;
            this.y1 = f;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Bounds2D bounds2D = (Bounds2D)object;
        if (this.x1 != bounds2D.x1) {
            return false;
        }
        if (this.y1 != bounds2D.y1) {
            return false;
        }
        if (this.x2 != bounds2D.x2) {
            return false;
        }
        return this.y2 == bounds2D.y2;
    }

    public int hashCode() {
        int n = 7;
        n = 79 * n + Float.floatToIntBits(this.x1);
        n = 79 * n + Float.floatToIntBits(this.y1);
        n = 79 * n + Float.floatToIntBits(this.x2);
        n = 79 * n + Float.floatToIntBits(this.y2);
        return n;
    }

    public String toString() {
        return "Bounds { x1:" + this.x1 + ", y1:" + this.y1 + ", x2:" + this.x2 + ", y2:" + this.y2 + " invalid: " + this.invalid + "}";
    }
}

