/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Crossings;
import com.sun.javafx.geom.Order0;
import com.sun.javafx.geom.Order1;
import com.sun.javafx.geom.Order2;
import com.sun.javafx.geom.Order3;
import java.util.Vector;

public abstract class Curve {
    public static final int INCREASING = 1;
    public static final int DECREASING = -1;
    protected int direction;
    public static final float TMIN = 0.001f;

    public static void insertMove(Vector vector, float f, float f2) {
        vector.add(new Order0(f, f2));
    }

    public static void insertLine(Vector vector, float f, float f2, float f3, float f4) {
        if (f2 < f4) {
            vector.add(new Order1(f, f2, f3, f4, 1));
        } else if (f2 > f4) {
            vector.add(new Order1(f3, f4, f, f2, -1));
        }
    }

    public static void insertQuad(Vector vector, float f, float f2, float[] fArray) {
        float f3 = fArray[3];
        if (f2 > f3) {
            Order2.insert(vector, fArray, fArray[2], f3, fArray[0], fArray[1], f, f2, -1);
        } else {
            if (f2 == f3 && f2 == fArray[1]) {
                return;
            }
            Order2.insert(vector, fArray, f, f2, fArray[0], fArray[1], fArray[2], f3, 1);
        }
    }

    public static void insertCubic(Vector vector, float f, float f2, float[] fArray) {
        float f3 = fArray[5];
        if (f2 > f3) {
            Order3.insert(vector, fArray, fArray[4], f3, fArray[2], fArray[3], fArray[0], fArray[1], f, f2, -1);
        } else {
            if (f2 == f3 && f2 == fArray[1] && f2 == fArray[3]) {
                return;
            }
            Order3.insert(vector, fArray, f, f2, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], f3, 1);
        }
    }

    public Curve(int n) {
        this.direction = n;
    }

    public final int getDirection() {
        return this.direction;
    }

    public final Curve getWithDirection(int n) {
        return this.direction == n ? this : this.getReversedCurve();
    }

    public static float round(float f) {
        return f;
    }

    public static int orderof(float f, float f2) {
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        return 0;
    }

    public static long signeddiffbits(float f, float f2) {
        return Float.floatToIntBits(f) - Float.floatToIntBits(f2);
    }

    public static long diffbits(float f, float f2) {
        return Math.abs(Float.floatToIntBits(f) - Float.floatToIntBits(f2));
    }

    public static float prev(float f) {
        return Float.intBitsToFloat(Float.floatToIntBits(f) - 1);
    }

    public static float next(float f) {
        return Float.intBitsToFloat(Float.floatToIntBits(f) + 1);
    }

    public String toString() {
        return "Curve[" + this.getOrder() + ", " + "(" + Curve.round(this.getX0()) + ", " + Curve.round(this.getY0()) + "), " + this.controlPointString() + "(" + Curve.round(this.getX1()) + ", " + Curve.round(this.getY1()) + "), " + (this.direction == 1 ? "D" : "U") + "]";
    }

    public String controlPointString() {
        return "";
    }

    public abstract int getOrder();

    public abstract float getXTop();

    public abstract float getYTop();

    public abstract float getXBot();

    public abstract float getYBot();

    public abstract float getXMin();

    public abstract float getXMax();

    public abstract float getX0();

    public abstract float getY0();

    public abstract float getX1();

    public abstract float getY1();

    public abstract float XforY(float var1);

    public abstract float TforY(float var1);

    public abstract float XforT(float var1);

    public abstract float YforT(float var1);

    public abstract float dXforT(float var1, int var2);

    public abstract float dYforT(float var1, int var2);

    public abstract float nextVertical(float var1, float var2);

    public int crossingsFor(float f, float f2) {
        if (f2 >= this.getYTop() && f2 < this.getYBot() && f < this.getXMax() && (f < this.getXMin() || f < this.XforY(f2))) {
            return 1;
        }
        return 0;
    }

    public boolean accumulateCrossings(Crossings crossings) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = crossings.getXHi();
        if (this.getXMin() >= f5) {
            return false;
        }
        float f6 = crossings.getXLo();
        float f7 = crossings.getYLo();
        float f8 = crossings.getYHi();
        float f9 = this.getYTop();
        float f10 = this.getYBot();
        if (f9 < f7) {
            if (f10 <= f7) {
                return false;
            }
            f4 = f7;
            f3 = this.TforY(f7);
        } else {
            if (f9 >= f8) {
                return false;
            }
            f4 = f9;
            f3 = 0.0f;
        }
        if (f10 > f8) {
            f2 = f8;
            f = this.TforY(f8);
        } else {
            f2 = f10;
            f = 1.0f;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            float f11;
            if ((f11 = this.XforT(f3)) < f5) {
                if (bl2 || f11 > f6) {
                    return true;
                }
                bl = true;
            } else {
                if (bl) {
                    return true;
                }
                bl2 = true;
            }
            if (f3 >= f) break;
            f3 = this.nextVertical(f3, f);
        }
        if (bl) {
            crossings.record(f4, f2, this.direction);
        }
        return false;
    }

    public abstract void enlarge(Bounds2D var1);

    public Curve getSubCurve(float f, float f2) {
        return this.getSubCurve(f, f2, this.direction);
    }

    public abstract Curve getReversedCurve();

    public abstract Curve getSubCurve(float var1, float var2, int var3);

    public int compareTo(Curve curve, float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9 = fArray[0];
        float f10 = fArray[1];
        if ((f10 = Math.min(Math.min(f10, this.getYBot()), curve.getYBot())) <= fArray[0]) {
            System.err.println("this == " + this);
            System.err.println("that == " + curve);
            System.out.println("target range = " + fArray[0] + "=>" + fArray[1]);
            throw new InternalError("backstepping from " + fArray[0] + " to " + f10);
        }
        fArray[1] = f10;
        if (this.getXMax() <= curve.getXMin()) {
            if (this.getXMin() == curve.getXMax()) {
                return 0;
            }
            return -1;
        }
        if (this.getXMin() >= curve.getXMax()) {
            return 1;
        }
        float f11 = this.TforY(f9);
        float f12 = this.YforT(f11);
        if (f12 < f9) {
            f11 = this.refineTforY(f11, f12, f9);
            f12 = this.YforT(f11);
        }
        if (this.YforT(f8 = this.TforY(f10)) < f9) {
            f8 = this.refineTforY(f8, this.YforT(f8), f9);
        }
        if ((f7 = curve.YforT(f6 = curve.TforY(f9))) < f9) {
            f6 = curve.refineTforY(f6, f7, f9);
            f7 = curve.YforT(f6);
        }
        if (curve.YforT(f5 = curve.TforY(f10)) < f9) {
            f5 = curve.refineTforY(f5, curve.YforT(f5), f9);
        }
        float f13 = this.XforT(f11);
        float f14 = curve.XforT(f6);
        float f15 = Math.max(Math.abs(f9), Math.abs(f10));
        float f16 = (float)Math.max((double)f15 * 1.0E-14, 1.0E-300);
        if (this.fairlyClose(f13, f14)) {
            f4 = f16;
            f3 = (float)Math.min((double)f16 * 1.0E13, (double)(f10 - f9) * 0.1);
            for (f2 = f9 + f4; f2 <= f10; f2 += f4) {
                if (this.fairlyClose(this.XforY(f2), curve.XforY(f2))) {
                    float f17;
                    f4 *= 2.0f;
                    if (!(f17 > f3)) continue;
                    f4 = f3;
                    continue;
                }
                f2 -= f4;
                while (!((f = f2 + (f4 /= 2.0f)) <= f2)) {
                    if (!this.fairlyClose(this.XforY(f), curve.XforY(f))) continue;
                    f2 = f;
                }
                break;
            }
            if (f2 > f9) {
                if (f2 < f10) {
                    fArray[1] = f2;
                }
                return 0;
            }
        }
        if (f16 <= 0.0f) {
            System.out.println("ymin = " + f16);
        }
        while (f11 < f8 && f6 < f5) {
            f4 = this.nextVertical(f11, f8);
            f3 = this.XforT(f4);
            f2 = this.YforT(f4);
            f = curve.nextVertical(f6, f5);
            float f18 = curve.XforT(f);
            float f19 = curve.YforT(f);
            try {
                if (this.findIntersect(curve, fArray, f16, 0, 0, f11, f13, f12, f4, f3, f2, f6, f14, f7, f, f18, f19)) {
                    break;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Error: " + throwable);
                System.err.println("y range was " + fArray[0] + "=>" + fArray[1]);
                System.err.println("s y range is " + f12 + "=>" + f2);
                System.err.println("t y range is " + f7 + "=>" + f19);
                System.err.println("ymin is " + f16);
                return 0;
            }
            if (f2 < f19) {
                if (f2 > fArray[0]) {
                    if (!(f2 < fArray[1])) break;
                    fArray[1] = f2;
                    break;
                }
                f11 = f4;
                f13 = f3;
                f12 = f2;
                continue;
            }
            if (f19 > fArray[0]) {
                if (!(f19 < fArray[1])) break;
                fArray[1] = f19;
                break;
            }
            f6 = f;
            f14 = f18;
            f7 = f19;
        }
        f4 = (fArray[0] + fArray[1]) / 2.0f;
        return Curve.orderof(this.XforY(f4), curve.XforY(f4));
    }

    public boolean findIntersect(Curve curve, float[] fArray, float f, int n, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        if (f4 > f13 || f10 > f7) {
            return false;
        }
        if (Math.min(f3, f6) > Math.max(f9, f12) || Math.max(f3, f6) < Math.min(f9, f12)) {
            return false;
        }
        if (f5 - f2 > 0.001f) {
            float f14 = (f2 + f5) / 2.0f;
            float f15 = this.XforT(f14);
            float f16 = this.YforT(f14);
            if (f14 == f2 || f14 == f5) {
                System.out.println("s0 = " + f2);
                System.out.println("s1 = " + f5);
                throw new InternalError("no s progress!");
            }
            if (f11 - f8 > 0.001f) {
                float f17 = (f8 + f11) / 2.0f;
                float f18 = curve.XforT(f17);
                float f19 = curve.YforT(f17);
                if (f17 == f8 || f17 == f11) {
                    System.out.println("t0 = " + f8);
                    System.out.println("t1 = " + f11);
                    throw new InternalError("no t progress!");
                }
                if (f16 >= f10 && f19 >= f4 && this.findIntersect(curve, fArray, f, n + 1, n2 + 1, f2, f3, f4, f14, f15, f16, f8, f9, f10, f17, f18, f19)) {
                    return true;
                }
                if (f16 >= f19 && this.findIntersect(curve, fArray, f, n + 1, n2 + 1, f2, f3, f4, f14, f15, f16, f17, f18, f19, f11, f12, f13)) {
                    return true;
                }
                if (f19 >= f16 && this.findIntersect(curve, fArray, f, n + 1, n2 + 1, f14, f15, f16, f5, f6, f7, f8, f9, f10, f17, f18, f19)) {
                    return true;
                }
                if (f7 >= f19 && f13 >= f16 && this.findIntersect(curve, fArray, f, n + 1, n2 + 1, f14, f15, f16, f5, f6, f7, f17, f18, f19, f11, f12, f13)) {
                    return true;
                }
            } else {
                if (f16 >= f10 && this.findIntersect(curve, fArray, f, n + 1, n2, f2, f3, f4, f14, f15, f16, f8, f9, f10, f11, f12, f13)) {
                    return true;
                }
                if (f13 >= f16 && this.findIntersect(curve, fArray, f, n + 1, n2, f14, f15, f16, f5, f6, f7, f8, f9, f10, f11, f12, f13)) {
                    return true;
                }
            }
        } else if (f11 - f8 > 0.001f) {
            float f20 = (f8 + f11) / 2.0f;
            float f21 = curve.XforT(f20);
            float f22 = curve.YforT(f20);
            if (f20 == f8 || f20 == f11) {
                System.out.println("t0 = " + f8);
                System.out.println("t1 = " + f11);
                throw new InternalError("no t progress!");
            }
            if (f22 >= f4 && this.findIntersect(curve, fArray, f, n, n2 + 1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f20, f21, f22)) {
                return true;
            }
            if (f7 >= f22 && this.findIntersect(curve, fArray, f, n, n2 + 1, f2, f3, f4, f5, f6, f7, f20, f21, f22, f11, f12, f13)) {
                return true;
            }
        } else {
            float f23 = f6 - f3;
            float f24 = f7 - f4;
            float f25 = f12 - f9;
            float f26 = f13 - f10;
            float f27 = f9 - f3;
            float f28 = f10 - f4;
            float f29 = f25 * f24 - f26 * f23;
            if (f29 != 0.0f) {
                float f30 = 1.0f / f29;
                float f31 = (f25 * f28 - f26 * f27) * f30;
                float f32 = (f23 * f28 - f24 * f27) * f30;
                if (f31 >= 0.0f && f31 <= 1.0f && f32 >= 0.0f && f32 <= 1.0f) {
                    float f33;
                    f31 = f2 + f31 * (f5 - f2);
                    f32 = f8 + f32 * (f11 - f8);
                    if (f31 < 0.0f || f31 > 1.0f || f32 < 0.0f || f32 > 1.0f) {
                        System.out.println("Uh oh!");
                    }
                    if ((f33 = (this.YforT(f31) + curve.YforT(f32)) / 2.0f) <= fArray[1] && f33 > fArray[0]) {
                        fArray[1] = f33;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public float refineTforY(float f, float f2, float f3) {
        float f4 = 1.0f;
        while (true) {
            float f5;
            if ((f5 = (f + f4) / 2.0f) == f || f5 == f4) {
                return f4;
            }
            float f6 = this.YforT(f5);
            if (f6 < f3) {
                f = f5;
                f2 = f6;
                continue;
            }
            if (!(f6 > f3)) break;
            f4 = f5;
        }
        return f4;
    }

    public boolean fairlyClose(float f, float f2) {
        return Math.abs(f - f2) < 4.0f * Math.ulp(Math.max(Math.abs(f), Math.abs(f2)));
    }

    public abstract int getSegment(float[] var1);
}

