/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;

final class Edge {
    static final int INIT_PARTS = 4;
    static final int GROW_PARTS = 10;
    Curve curve;
    int ctag;
    int etag;
    float activey;
    int equivalence;
    private Edge lastEdge;
    private int lastResult;
    private float lastLimit;

    public Edge(Curve curve, int n) {
        this(curve, n, 0);
    }

    public Edge(Curve curve, int n, int n2) {
        this.curve = curve;
        this.ctag = n;
        this.etag = n2;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public int getCurveTag() {
        return this.ctag;
    }

    public int getEdgeTag() {
        return this.etag;
    }

    public void setEdgeTag(int n) {
        this.etag = n;
    }

    public int getEquivalence() {
        return this.equivalence;
    }

    public void setEquivalence(int n) {
        this.equivalence = n;
    }

    public int compareTo(Edge edge, float[] fArray) {
        if (edge == this.lastEdge && fArray[0] < this.lastLimit) {
            if (fArray[1] > this.lastLimit) {
                fArray[1] = this.lastLimit;
            }
            return this.lastResult;
        }
        if (this == edge.lastEdge && fArray[0] < edge.lastLimit) {
            if (fArray[1] > edge.lastLimit) {
                fArray[1] = edge.lastLimit;
            }
            return 0 - edge.lastResult;
        }
        int n = this.curve.compareTo(edge.curve, fArray);
        this.lastEdge = edge;
        this.lastLimit = fArray[1];
        this.lastResult = n;
        return n;
    }

    public void record(float f, int n) {
        this.activey = f;
        this.etag = n;
    }

    public boolean isActiveFor(float f, int n) {
        return this.etag == n && this.activey >= f;
    }

    public String toString() {
        return "Edge[" + this.curve + ", " + (this.ctag == 0 ? "L" : "R") + ", " + (this.etag == 1 ? "I" : (this.etag == -1 ? "O" : "N")) + "]";
    }
}

