/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;

public class Path2D
extends Shape {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    float[] floatCoords;

    public Path2D() {
        this(1, 20);
    }

    public Path2D(int n) {
        this(n, 20);
    }

    public Path2D(int n, int n2) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
        this.floatCoords = new float[n2 * 2];
    }

    public Path2D(Shape shape) {
        this(shape, null);
    }

    public Path2D(Shape shape, BaseTransform baseTransform) {
        if (shape instanceof Path2D) {
            Path2D path2D = (Path2D)shape;
            this.setWindingRule(path2D.windingRule);
            this.numTypes = path2D.numTypes;
            this.pointTypes = this.copyOf(path2D.pointTypes, path2D.pointTypes.length);
            this.numCoords = path2D.numCoords;
            this.floatCoords = path2D.cloneCoordsFloat(baseTransform);
        } else {
            PathIterator pathIterator = shape.getPathIterator(baseTransform);
            this.setWindingRule(pathIterator.getWindingRule());
            this.pointTypes = new byte[20];
            this.floatCoords = new float[40];
            this.append(pathIterator, false);
        }
    }

    public Path2D(int n, byte[] byArray, int n2, float[] fArray, int n3) {
        this.windingRule = n;
        this.pointTypes = byArray;
        this.numTypes = n2;
        this.floatCoords = fArray;
        this.numCoords = n3;
    }

    float[] cloneCoordsFloat(BaseTransform baseTransform) {
        float[] fArray;
        if (baseTransform == null) {
            fArray = this.copyOf(this.floatCoords, this.floatCoords.length);
        } else {
            fArray = new float[this.floatCoords.length];
            baseTransform.transform(this.floatCoords, 0, fArray, 0, this.numCoords / 2);
        }
        return fArray;
    }

    void append(float f, float f2) {
        this.floatCoords[this.numCoords++] = f;
        this.floatCoords[this.numCoords++] = f2;
    }

    Point2D getPoint(int n) {
        return new Point2D(this.floatCoords[n], this.floatCoords[n + 1]);
    }

    void needRoom(boolean bl, int n) {
        int n2;
        if (bl && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int n3 = this.pointTypes.length;
        if (this.numTypes >= n3) {
            n2 = n3;
            if (n2 > 500) {
                n2 = 500;
            }
            this.pointTypes = this.copyOf(this.pointTypes, n3 + n2);
        }
        if (this.numCoords + n > (n3 = this.floatCoords.length)) {
            n2 = n3;
            if (n2 > 1000) {
                n2 = 1000;
            }
            if (n2 < n) {
                n2 = n;
            }
            this.floatCoords = this.copyOf(this.floatCoords, n3 + n2);
        }
    }

    public final synchronized void moveTo(float f, float f2) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.floatCoords[this.numCoords - 2] = f;
            this.floatCoords[this.numCoords - 1] = f2;
        } else {
            this.needRoom(false, 2);
            this.pointTypes[this.numTypes++] = 0;
            this.floatCoords[this.numCoords++] = f;
            this.floatCoords[this.numCoords++] = f2;
        }
    }

    public final synchronized void lineTo(float f, float f2) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.floatCoords[this.numCoords++] = f;
        this.floatCoords[this.numCoords++] = f2;
    }

    public final synchronized void quadTo(float f, float f2, float f3, float f4) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = f;
        this.floatCoords[this.numCoords++] = f2;
        this.floatCoords[this.numCoords++] = f3;
        this.floatCoords[this.numCoords++] = f4;
    }

    public final synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = f;
        this.floatCoords[this.numCoords++] = f2;
        this.floatCoords[this.numCoords++] = f3;
        this.floatCoords[this.numCoords++] = f4;
        this.floatCoords[this.numCoords++] = f5;
        this.floatCoords[this.numCoords++] = f6;
    }

    int pointCrossings(float f, float f2) {
        float f3;
        float f4;
        float[] fArray = this.floatCoords;
        float f5 = f4 = fArray[0];
        float f6 = f3 = fArray[1];
        int n = 0;
        int n2 = 2;
        block7: for (int i = 1; i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (f6 != f3) {
                        n += Shape.pointCrossingsForLine(f, f2, f5, f6, f4, f3);
                    }
                    f4 = f5 = fArray[n2++];
                    f3 = f6 = fArray[n2++];
                    continue block7;
                }
                case 1: {
                    float f7 = fArray[n2++];
                    float f8 = fArray[n2++];
                    n += Shape.pointCrossingsForLine(f, f2, f5, f6, f7, f8);
                    f5 = f7;
                    f6 = f8;
                    continue block7;
                }
                case 2: {
                    int n3 = n2++;
                    int n4 = n2++;
                    float f7 = fArray[n2++];
                    float f8 = fArray[n2++];
                    n += Shape.pointCrossingsForQuad(f, f2, f5, f6, fArray[n3], fArray[n4], f7, f8, 0);
                    f5 = f7;
                    f6 = f8;
                    continue block7;
                }
                case 3: {
                    int n5 = n2++;
                    int n6 = n2++;
                    int n7 = n2++;
                    int n8 = n2++;
                    float f7 = fArray[n2++];
                    float f8 = fArray[n2++];
                    n += Shape.pointCrossingsForCubic(f, f2, f5, f6, fArray[n5], fArray[n6], fArray[n7], fArray[n8], f7, f8, 0);
                    f5 = f7;
                    f6 = f8;
                    continue block7;
                }
                case 4: {
                    if (f6 != f3) {
                        n += Shape.pointCrossingsForLine(f, f2, f5, f6, f4, f3);
                    }
                    f5 = f4;
                    f6 = f3;
                }
            }
        }
        if (f6 != f3) {
            n += Shape.pointCrossingsForLine(f, f2, f5, f6, f4, f3);
        }
        return n;
    }

    int rectCrossings(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float[] fArray = this.floatCoords;
        float f7 = f6 = fArray[0];
        float f8 = f5 = fArray[1];
        int n = 0;
        int n2 = 2;
        block7: for (int i = 1; n != Integer.MIN_VALUE && i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (f7 != f6 || f8 != f5) {
                        n = Shape.rectCrossingsForLine(n, f, f2, f3, f4, f7, f8, f6, f5);
                    }
                    f6 = f7 = fArray[n2++];
                    f5 = f8 = fArray[n2++];
                    continue block7;
                }
                case 1: {
                    float f9 = fArray[n2++];
                    float f10 = fArray[n2++];
                    n = Shape.rectCrossingsForLine(n, f, f2, f3, f4, f7, f8, f9, f10);
                    f7 = f9;
                    f8 = f10;
                    continue block7;
                }
                case 2: {
                    int n3 = n2++;
                    int n4 = n2++;
                    float f9 = fArray[n2++];
                    float f10 = fArray[n2++];
                    n = Shape.rectCrossingsForQuad(n, f, f2, f3, f4, f7, f8, fArray[n3], fArray[n4], f9, f10, 0);
                    f7 = f9;
                    f8 = f10;
                    continue block7;
                }
                case 3: {
                    int n5 = n2++;
                    int n6 = n2++;
                    int n7 = n2++;
                    int n8 = n2++;
                    float f9 = fArray[n2++];
                    float f10 = fArray[n2++];
                    n = Shape.rectCrossingsForCubic(n, f, f2, f3, f4, f7, f8, fArray[n5], fArray[n6], fArray[n7], fArray[n8], f9, f10, 0);
                    f7 = f9;
                    f8 = f10;
                    continue block7;
                }
                case 4: {
                    if (f7 != f6 || f8 != f5) {
                        n = Shape.rectCrossingsForLine(n, f, f2, f3, f4, f7, f8, f6, f5);
                    }
                    f7 = f6;
                    f8 = f5;
                }
            }
        }
        if (n != Integer.MIN_VALUE && (f7 != f6 || f8 != f5)) {
            n = Shape.rectCrossingsForLine(n, f, f2, f3, f4, f7, f8, f6, f5);
        }
        return n;
    }

    public final void append(PathIterator pathIterator, boolean bl) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!bl || this.numTypes < 1 || this.numCoords < 1) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.floatCoords[this.numCoords - 2] == fArray[0] && this.floatCoords[this.numCoords - 1] == fArray[1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
            bl = false;
        }
    }

    public final void transform(BaseTransform baseTransform) {
        baseTransform.transform(this.floatCoords, 0, this.floatCoords, 0, this.numCoords / 2);
    }

    public final synchronized Bounds2D getBounds2D() {
        float f;
        float f2;
        float f3;
        float f4;
        int n = this.numCoords;
        if (n > 0) {
            f3 = f4 = this.floatCoords[--n];
            f = f2 = this.floatCoords[--n];
            while (n > 0) {
                float f5;
                float f6 = this.floatCoords[--n];
                if ((f5 = this.floatCoords[--n]) < f) {
                    f = f5;
                }
                if (f6 < f3) {
                    f3 = f6;
                }
                if (f5 > f2) {
                    f2 = f5;
                }
                if (!(f6 > f4)) continue;
                f4 = f6;
            }
        } else {
            f4 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
            f = 0.0f;
        }
        return new Bounds2D(f, f3, f2, f4);
    }

    public final int getNumCommands() {
        return this.numTypes;
    }

    public final byte[] getCommandsNoClone() {
        return this.pointTypes;
    }

    public final float[] getFloatCoordsNoClone() {
        return this.floatCoords;
    }

    public PathIterator getPathIterator(BaseTransform baseTransform) {
        if (baseTransform == null) {
            return new CopyIterator(this);
        }
        return new TxIterator(this, baseTransform);
    }

    public final synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public final void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(null), bl);
    }

    public final synchronized int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final synchronized int getCurrentIndex() {
        int n = this.numCoords;
        if (this.numTypes < 1) return -1;
        if (n < 1) {
            return -1;
        }
        if (this.pointTypes[this.numTypes - 1] != 4) return n - 2;
        int n2 = this.numTypes - 2;
        while (n2 > 0) {
            switch (this.pointTypes[n2]) {
                case 0: {
                    return n - 2;
                }
                case 1: {
                    n -= 2;
                    break;
                }
                case 2: {
                    n -= 4;
                    break;
                }
                case 3: {
                    n -= 6;
                }
            }
            --n2;
        }
        return n - 2;
    }

    public final synchronized Point2D getCurrentPoint() {
        return this.getPoint(this.getCurrentIndex());
    }

    public final synchronized float getCurrentX() {
        return this.floatCoords[this.getCurrentIndex()];
    }

    public final synchronized float getCurrentY() {
        return this.floatCoords[this.getCurrentIndex() + 1];
    }

    public final synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public final synchronized Shape createTransformedShape(BaseTransform baseTransform) {
        int n;
        Path2D path2D = new Path2D();
        path2D.pointTypes = new byte[this.pointTypes.length];
        for (n = 0; n < this.pointTypes.length; ++n) {
            path2D.pointTypes[n] = this.pointTypes[n];
        }
        path2D.numTypes = this.numTypes;
        path2D.numCoords = this.numCoords;
        path2D.windingRule = this.windingRule;
        path2D.floatCoords = new float[this.floatCoords.length];
        for (n = 0; n < this.floatCoords.length; ++n) {
            path2D.floatCoords[n] = this.floatCoords[n];
        }
        if (baseTransform != null) {
            path2D.transform(baseTransform);
        }
        return path2D;
    }

    public Path2D copy() {
        return new Path2D(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Path2D) {
            Path2D path2D = (Path2D)object;
            if (path2D.numTypes == this.numTypes && path2D.numCoords == this.numCoords && path2D.windingRule == this.windingRule) {
                int n;
                for (n = 0; n < this.numTypes; ++n) {
                    if (path2D.pointTypes[n] == this.pointTypes[n]) continue;
                    return false;
                }
                for (n = 0; n < this.numCoords; ++n) {
                    if (path2D.floatCoords[n] == this.floatCoords[n]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2 = 7;
        n2 = 11 * n2 + this.numTypes;
        n2 = 11 * n2 + this.numCoords;
        n2 = 11 * n2 + this.windingRule;
        for (n = 0; n < this.numTypes; ++n) {
            n2 = 11 * n2 + this.pointTypes[n];
        }
        for (n = 0; n < this.numCoords; ++n) {
            n2 = 11 * n2 + Float.floatToIntBits(this.floatCoords[n]);
        }
        return n2;
    }

    public static boolean contains(PathIterator pathIterator, float f, float f2) {
        if (f * 0.0f + f2 * 0.0f == 0.0f) {
            int n = pathIterator.getWindingRule() == 1 ? -1 : 1;
            int n2 = Shape.pointCrossingsForPath(pathIterator, f, f2);
            return (n2 & n) != 0;
        }
        return false;
    }

    public static boolean contains(PathIterator pathIterator, Point2D point2D) {
        return Path2D.contains(pathIterator, point2D.x, point2D.y);
    }

    public final boolean contains(float f, float f2) {
        if (f * 0.0f + f2 * 0.0f == 0.0f) {
            if (this.numTypes < 2) {
                return false;
            }
            int n = this.windingRule == 1 ? -1 : 1;
            return (this.pointCrossings(f, f2) & n) != 0;
        }
        return false;
    }

    public final boolean contains(Point2D point2D) {
        return this.contains(point2D.x, point2D.y);
    }

    public static boolean contains(PathIterator pathIterator, float f, float f2, float f3, float f4) {
        if (Float.isNaN(f + f3) || Float.isNaN(f2 + f4)) {
            return false;
        }
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        int n = pathIterator.getWindingRule() == 1 ? -1 : 2;
        int n2 = Shape.rectCrossingsForPath(pathIterator, f, f2, f + f3, f2 + f4);
        return n2 != Integer.MIN_VALUE && (n2 & n) != 0;
    }

    public final boolean contains(float f, float f2, float f3, float f4) {
        if (Float.isNaN(f + f3) || Float.isNaN(f2 + f4)) {
            return false;
        }
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        int n = this.windingRule == 1 ? -1 : 2;
        int n2 = this.rectCrossings(f, f2, f + f3, f2 + f4);
        return n2 != Integer.MIN_VALUE && (n2 & n) != 0;
    }

    public static boolean intersects(PathIterator pathIterator, float f, float f2, float f3, float f4) {
        if (Float.isNaN(f + f3) || Float.isNaN(f2 + f4)) {
            return false;
        }
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        int n = pathIterator.getWindingRule() == 1 ? -1 : 2;
        int n2 = Shape.rectCrossingsForPath(pathIterator, f, f2, f + f3, f2 + f4);
        return n2 == Integer.MIN_VALUE || (n2 & n) != 0;
    }

    public final boolean intersects(float f, float f2, float f3, float f4) {
        if (Float.isNaN(f + f3) || Float.isNaN(f2 + f4)) {
            return false;
        }
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        int n = this.windingRule == 1 ? -1 : 2;
        int n2 = this.rectCrossings(f, f2, f + f3, f2 + f4);
        return n2 == Integer.MIN_VALUE || (n2 & n) != 0;
    }

    public PathIterator getPathIterator(BaseTransform baseTransform, float f) {
        return new FlatteningPathIterator(this.getPathIterator(baseTransform), f);
    }

    byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    float[] copyOf(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    static class CopyIterator
    extends Iterator {
        float[] floatCoords;

        CopyIterator(Path2D path2D) {
            super(path2D);
            this.floatCoords = path2D.floatCoords;
        }

        public int currentSegment(float[] fArray) {
            byte by = this.path.pointTypes[this.typeIdx];
            int n = curvecoords[by];
            if (n > 0) {
                System.arraycopy(this.floatCoords, this.pointIdx, fArray, 0, n);
            }
            return by;
        }

        public int currentSegment(double[] dArray) {
            byte by = this.path.pointTypes[this.typeIdx];
            int n = curvecoords[by];
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this.floatCoords[this.pointIdx + i];
                }
            }
            return by;
        }
    }

    static abstract class Iterator
    implements PathIterator {
        int typeIdx;
        int pointIdx;
        Path2D path;
        static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};

        Iterator(Path2D path2D) {
            this.path = path2D;
        }

        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        public void next() {
            byte by = this.path.pointTypes[this.typeIdx++];
            this.pointIdx += curvecoords[by];
        }
    }

    static class TxIterator
    extends Iterator {
        float[] floatCoords;
        BaseTransform transform;

        TxIterator(Path2D path2D, BaseTransform baseTransform) {
            super(path2D);
            this.floatCoords = path2D.floatCoords;
            this.transform = baseTransform;
        }

        public int currentSegment(float[] fArray) {
            byte by = this.path.pointTypes[this.typeIdx];
            int n = curvecoords[by];
            if (n > 0) {
                this.transform.transform(this.floatCoords, this.pointIdx, fArray, 0, n / 2);
            }
            return by;
        }

        public int currentSegment(double[] dArray) {
            byte by = this.path.pointTypes[this.typeIdx];
            int n = curvecoords[by];
            if (n > 0) {
                this.transform.transform(this.floatCoords, this.pointIdx, dArray, 0, n / 2);
            }
            return by;
        }
    }
}

