/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;

public abstract class AffineBase
extends BaseTransform {
    protected static final int APPLY_IDENTITY = 0;
    protected static final int APPLY_TRANSLATE = 1;
    protected static final int APPLY_SCALE = 2;
    protected static final int APPLY_SHEAR = 4;
    protected static final int APPLY_3D = 8;
    protected static final int APPLY_2D_MASK = 7;
    protected static final int HI_SHIFT = 4;
    protected static final int HI_IDENTITY = 0;
    protected static final int HI_TRANSLATE = 16;
    protected static final int HI_SCALE = 32;
    protected static final int HI_SHEAR = 64;
    protected static final int HI_3D = 128;
    protected double mxx;
    protected double myx;
    protected double mxy;
    protected double myy;
    protected double mxt;
    protected double myt;
    protected transient int state;
    protected transient int type;
    private static final int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    protected static void stateError() {
        throw new InternalError("missing case in transform state switch");
    }

    protected void updateState() {
        this.updateState2D();
    }

    protected void updateState2D() {
        if (this.mxy == 0.0 && this.myx == 0.0) {
            if (this.mxx == 1.0 && this.myy == 1.0) {
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 0;
                    this.type = 0;
                } else {
                    this.state = 1;
                    this.type = 1;
                }
            } else {
                this.state = this.mxt == 0.0 && this.myt == 0.0 ? 2 : 3;
                this.type = -1;
            }
        } else {
            this.state = this.mxx == 0.0 && this.myy == 0.0 ? (this.mxt == 0.0 && this.myt == 0.0 ? 4 : 5) : (this.mxt == 0.0 && this.myt == 0.0 ? 6 : 7);
            this.type = -1;
        }
    }

    public int getType() {
        if (this.type == -1) {
            this.updateState();
            if (this.type == -1) {
                this.type = this.calculateType();
            }
        }
        return this.type;
    }

    protected int calculateType() {
        int n = (this.state & 8) == 0 ? 0 : 128;
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                n |= 1;
            }
            case 6: {
                boolean bl;
                if (this.mxx * this.mxy + this.myx * this.myy != 0.0) {
                    n |= 0x20;
                    break;
                }
                boolean bl2 = this.mxx >= 0.0;
                boolean bl3 = bl = this.myy >= 0.0;
                if (bl2 == bl) {
                    if (this.mxx != this.myy || this.mxy != -this.myx) {
                        n |= 0x14;
                        break;
                    }
                    if (this.mxx * this.myy - this.mxy * this.myx != 1.0) {
                        n |= 0x12;
                        break;
                    }
                    n |= 0x10;
                    break;
                }
                if (this.mxx != -this.myy || this.mxy != this.myx) {
                    n |= 0x54;
                    break;
                }
                if (this.mxx * this.myy - this.mxy * this.myx != 1.0) {
                    n |= 0x52;
                    break;
                }
                n |= 0x50;
                break;
            }
            case 5: {
                n |= 1;
            }
            case 4: {
                boolean bl;
                boolean bl4 = this.mxy >= 0.0;
                boolean bl5 = bl = this.myx >= 0.0;
                if (bl4 != bl) {
                    if (this.mxy != -this.myx) {
                        n |= 0xC;
                        break;
                    }
                    if (this.mxy != 1.0 && this.myx != -1.0) {
                        n |= 0xA;
                        break;
                    }
                    n |= 8;
                    break;
                }
                if (this.mxy == this.myx) {
                    n |= 0x4A;
                    break;
                }
                n |= 0x4C;
                break;
            }
            case 3: {
                n |= 1;
            }
            case 2: {
                boolean bl;
                boolean bl6 = this.mxx >= 0.0;
                boolean bl7 = bl = this.myy >= 0.0;
                if (bl6 == bl) {
                    if (bl6) {
                        if (this.mxx == this.myy) {
                            n |= 2;
                            break;
                        }
                        n |= 4;
                        break;
                    }
                    if (this.mxx != this.myy) {
                        n |= 0xC;
                        break;
                    }
                    if (this.mxx != -1.0) {
                        n |= 0xA;
                        break;
                    }
                    n |= 8;
                    break;
                }
                if (this.mxx == -this.myy) {
                    if (this.mxx == 1.0 || this.mxx == -1.0) {
                        n |= 0x40;
                        break;
                    }
                    n |= 0x42;
                    break;
                }
                n |= 0x44;
                break;
            }
            case 1: {
                n |= 1;
            }
            case 0: 
        }
        return n;
    }

    public double getMxx() {
        return this.mxx;
    }

    public double getMyy() {
        return this.myy;
    }

    public double getMxy() {
        return this.mxy;
    }

    public double getMyx() {
        return this.myx;
    }

    public double getMxt() {
        return this.mxt;
    }

    public double getMyt() {
        return this.myt;
    }

    public boolean isIdentity() {
        return this.state == 0 || this.getType() == 0;
    }

    public boolean isTranslateOrIdentity() {
        return this.state <= 1 || this.getType() <= 1;
    }

    public boolean is2D() {
        return this.state < 8 || this.getType() <= 127;
    }

    public double getDeterminant() {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                return this.mxx * this.myy - this.mxy * this.myx;
            }
            case 4: 
            case 5: {
                return -(this.mxy * this.myx);
            }
            case 2: 
            case 3: {
                return this.mxx * this.myy;
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    protected abstract void reset3Delements();

    public void setToIdentity() {
        this.myy = 1.0;
        this.mxx = 1.0;
        this.myt = 0.0;
        this.mxt = 0.0;
        this.mxy = 0.0;
        this.myx = 0.0;
        this.reset3Delements();
        this.state = 0;
        this.type = 0;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.mxx = d;
        this.myx = d2;
        this.mxy = d3;
        this.myy = d4;
        this.mxt = d5;
        this.myt = d6;
        this.reset3Delements();
        this.updateState2D();
    }

    public void setToShear(double d, double d2) {
        this.mxx = 1.0;
        this.mxy = d;
        this.myx = d2;
        this.myy = 1.0;
        this.mxt = 0.0;
        this.myt = 0.0;
        this.reset3Delements();
        if (d != 0.0 || d2 != 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public Point2D transform(Point2D point2D) {
        return this.transform(point2D, point2D);
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D();
        }
        double d = point2D.x;
        double d2 = point2D.y;
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                point2D2.setLocation((float)(d * this.mxx + d2 * this.mxy + this.mxt), (float)(d * this.myx + d2 * this.myy + this.myt));
                return point2D2;
            }
            case 6: {
                point2D2.setLocation((float)(d * this.mxx + d2 * this.mxy), (float)(d * this.myx + d2 * this.myy));
                return point2D2;
            }
            case 5: {
                point2D2.setLocation((float)(d2 * this.mxy + this.mxt), (float)(d * this.myx + this.myt));
                return point2D2;
            }
            case 4: {
                point2D2.setLocation((float)(d2 * this.mxy), (float)(d * this.myx));
                return point2D2;
            }
            case 3: {
                point2D2.setLocation((float)(d * this.mxx + this.mxt), (float)(d2 * this.myy + this.myt));
                return point2D2;
            }
            case 2: {
                point2D2.setLocation((float)(d * this.mxx), (float)(d2 * this.myy));
                return point2D2;
            }
            case 1: {
                point2D2.setLocation((float)(d + this.mxt), (float)(d2 + this.myt));
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation((float)d, (float)d2);
        return point2D2;
    }

    public Vec3d transform(Vec3d vec3d, Vec3d vec3d2) {
        if (vec3d2 == null) {
            vec3d2 = new Vec3d();
        }
        double d = vec3d.x;
        double d2 = vec3d.y;
        double d3 = vec3d.z;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                vec3d2.x = d * this.mxx + d2 * this.mxy + this.mxt;
                vec3d2.y = d * this.myx + d2 * this.myy + this.myt;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 6: {
                vec3d2.x = d * this.mxx + d2 * this.mxy;
                vec3d2.y = d * this.myx + d2 * this.myy;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 5: {
                vec3d2.x = d2 * this.mxy + this.mxt;
                vec3d2.y = d * this.myx + this.myt;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 4: {
                vec3d2.x = d2 * this.mxy;
                vec3d2.y = d * this.myx;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 3: {
                vec3d2.x = d * this.mxx + this.mxt;
                vec3d2.y = d2 * this.myy + this.myt;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 2: {
                vec3d2.x = d * this.mxx;
                vec3d2.y = d2 * this.myy;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 1: {
                vec3d2.x = d + this.mxt;
                vec3d2.y = d2 + this.myt;
                vec3d2.z = d3;
                return vec3d2;
            }
            case 0: 
        }
        vec3d2.x = d;
        vec3d2.y = d2;
        vec3d2.z = d3;
        return vec3d2;
    }

    public void transform(Bounds2D bounds2D, Bounds2D bounds2D2) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double d = bounds2D.x1;
                double d2 = bounds2D.y1;
                double d3 = bounds2D.x2;
                double d4 = bounds2D.y2;
                bounds2D2.setFromDiagonal((float)(d * this.mxx + d2 * this.mxy), (float)(d * this.myx + d2 * this.myy), (float)(d3 * this.mxx + d4 * this.mxy), (float)(d3 * this.myx + d4 * this.myy));
                bounds2D2.add((float)(d * this.mxx + d4 * this.mxy), (float)(d * this.myx + d4 * this.myy));
                bounds2D2.add((float)(d3 * this.mxx + d2 * this.mxy), (float)(d3 * this.myx + d2 * this.myy));
                bounds2D2.x1 = (float)((double)bounds2D2.x1 + this.mxt);
                bounds2D2.y1 = (float)((double)bounds2D2.y1 + this.myt);
                bounds2D2.x2 = (float)((double)bounds2D2.x2 + this.mxt);
                bounds2D2.y2 = (float)((double)bounds2D2.y2 + this.myt);
                return;
            }
            case 5: {
                bounds2D2.setFromDiagonal((float)((double)bounds2D.y1 * this.mxy + this.mxt), (float)((double)bounds2D.x1 * this.myx + this.myt), (float)((double)bounds2D.y2 * this.mxy + this.mxt), (float)((double)bounds2D.x2 * this.myx + this.myt));
                break;
            }
            case 4: {
                bounds2D2.setFromDiagonal((float)((double)bounds2D.y1 * this.mxy), (float)((double)bounds2D.x1 * this.myx), (float)((double)bounds2D.y2 * this.mxy), (float)((double)bounds2D.x2 * this.myx));
                break;
            }
            case 3: {
                bounds2D2.setFromDiagonal((float)((double)bounds2D.x1 * this.mxx + this.mxt), (float)((double)bounds2D.y1 * this.myy + this.myt), (float)((double)bounds2D.x2 * this.mxx + this.mxt), (float)((double)bounds2D.y2 * this.myy + this.myt));
                break;
            }
            case 2: {
                bounds2D2.setFromDiagonal((float)((double)bounds2D.x1 * this.mxx), (float)((double)bounds2D.y1 * this.myy), (float)((double)bounds2D.x2 * this.mxx), (float)((double)bounds2D.y2 * this.myy));
                break;
            }
            case 1: {
                bounds2D2.setBounds((float)((double)bounds2D.x1 + this.mxt), (float)((double)bounds2D.y1 + this.myt), (float)((double)bounds2D.x2 + this.mxt), (float)((double)bounds2D.y2 + this.myt));
                return;
            }
            case 0: {
                if (bounds2D != bounds2D2) {
                    bounds2D2.setBounds(bounds2D);
                }
                return;
            }
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray2 == fArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.mxt;
                double d4 = this.myx;
                double d5 = this.myy;
                double d6 = this.myt;
                while (--n3 >= 0) {
                    double d7 = fArray[n++];
                    double d8 = fArray[n++];
                    fArray2[n2++] = (float)(d * d7 + d2 * d8 + d3);
                    fArray2[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
                }
                return;
            }
            case 6: {
                double d = this.mxx;
                double d9 = this.mxy;
                double d10 = this.myx;
                double d11 = this.myy;
                while (--n3 >= 0) {
                    double d12 = fArray[n++];
                    double d13 = fArray[n++];
                    fArray2[n2++] = (float)(d * d12 + d9 * d13);
                    fArray2[n2++] = (float)(d10 * d12 + d11 * d13);
                }
                return;
            }
            case 5: {
                double d = this.mxy;
                double d14 = this.mxt;
                double d15 = this.myx;
                double d16 = this.myt;
                while (--n3 >= 0) {
                    double d17 = fArray[n++];
                    fArray2[n2++] = (float)(d * (double)fArray[n++] + d14);
                    fArray2[n2++] = (float)(d15 * d17 + d16);
                }
                return;
            }
            case 4: {
                double d = this.mxy;
                double d18 = this.myx;
                while (--n3 >= 0) {
                    double d19 = fArray[n++];
                    fArray2[n2++] = (float)(d * (double)fArray[n++]);
                    fArray2[n2++] = (float)(d18 * d19);
                }
                return;
            }
            case 3: {
                double d = this.mxx;
                double d20 = this.mxt;
                double d21 = this.myy;
                double d22 = this.myt;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(d * (double)fArray[n++] + d20);
                    fArray2[n2++] = (float)(d21 * (double)fArray[n++] + d22);
                }
                return;
            }
            case 2: {
                double d = this.mxx;
                double d23 = this.myy;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(d * (double)fArray[n++]);
                    fArray2[n2++] = (float)(d23 * (double)fArray[n++]);
                }
                return;
            }
            case 1: {
                double d = this.mxt;
                double d24 = this.myt;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)((double)fArray[n++] + d);
                    fArray2[n2++] = (float)((double)fArray[n++] + d24);
                }
                return;
            }
            case 0: 
        }
        if (fArray != fArray2 || n != n2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.mxt;
                double d4 = this.myx;
                double d5 = this.myy;
                double d6 = this.myt;
                while (--n3 >= 0) {
                    double d7 = dArray[n++];
                    double d8 = dArray[n++];
                    dArray2[n2++] = d * d7 + d2 * d8 + d3;
                    dArray2[n2++] = d4 * d7 + d5 * d8 + d6;
                }
                return;
            }
            case 6: {
                double d = this.mxx;
                double d9 = this.mxy;
                double d10 = this.myx;
                double d11 = this.myy;
                while (--n3 >= 0) {
                    double d12 = dArray[n++];
                    double d13 = dArray[n++];
                    dArray2[n2++] = d * d12 + d9 * d13;
                    dArray2[n2++] = d10 * d12 + d11 * d13;
                }
                return;
            }
            case 5: {
                double d = this.mxy;
                double d14 = this.mxt;
                double d15 = this.myx;
                double d16 = this.myt;
                while (--n3 >= 0) {
                    double d17 = dArray[n++];
                    dArray2[n2++] = d * dArray[n++] + d14;
                    dArray2[n2++] = d15 * d17 + d16;
                }
                return;
            }
            case 4: {
                double d = this.mxy;
                double d18 = this.myx;
                while (--n3 >= 0) {
                    double d19 = dArray[n++];
                    dArray2[n2++] = d * dArray[n++];
                    dArray2[n2++] = d18 * d19;
                }
                return;
            }
            case 3: {
                double d = this.mxx;
                double d20 = this.mxt;
                double d21 = this.myy;
                double d22 = this.myt;
                while (--n3 >= 0) {
                    dArray2[n2++] = d * dArray[n++] + d20;
                    dArray2[n2++] = d21 * dArray[n++] + d22;
                }
                return;
            }
            case 2: {
                double d = this.mxx;
                double d23 = this.myy;
                while (--n3 >= 0) {
                    dArray2[n2++] = d * dArray[n++];
                    dArray2[n2++] = d23 * dArray[n++];
                }
                return;
            }
            case 1: {
                double d = this.mxt;
                double d24 = this.myt;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] + d;
                    dArray2[n2++] = dArray[n++] + d24;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.mxt;
                double d4 = this.myx;
                double d5 = this.myy;
                double d6 = this.myt;
                while (--n3 >= 0) {
                    double d7 = fArray[n++];
                    double d8 = fArray[n++];
                    dArray[n2++] = d * d7 + d2 * d8 + d3;
                    dArray[n2++] = d4 * d7 + d5 * d8 + d6;
                }
                return;
            }
            case 6: {
                double d = this.mxx;
                double d9 = this.mxy;
                double d10 = this.myx;
                double d11 = this.myy;
                while (--n3 >= 0) {
                    double d12 = fArray[n++];
                    double d13 = fArray[n++];
                    dArray[n2++] = d * d12 + d9 * d13;
                    dArray[n2++] = d10 * d12 + d11 * d13;
                }
                return;
            }
            case 5: {
                double d = this.mxy;
                double d14 = this.mxt;
                double d15 = this.myx;
                double d16 = this.myt;
                while (--n3 >= 0) {
                    double d17 = fArray[n++];
                    dArray[n2++] = d * (double)fArray[n++] + d14;
                    dArray[n2++] = d15 * d17 + d16;
                }
                return;
            }
            case 4: {
                double d = this.mxy;
                double d18 = this.myx;
                while (--n3 >= 0) {
                    double d19 = fArray[n++];
                    dArray[n2++] = d * (double)fArray[n++];
                    dArray[n2++] = d18 * d19;
                }
                return;
            }
            case 3: {
                double d = this.mxx;
                double d20 = this.mxt;
                double d21 = this.myy;
                double d22 = this.myt;
                while (--n3 >= 0) {
                    dArray[n2++] = d * (double)fArray[n++] + d20;
                    dArray[n2++] = d21 * (double)fArray[n++] + d22;
                }
                return;
            }
            case 2: {
                double d = this.mxx;
                double d23 = this.myy;
                while (--n3 >= 0) {
                    dArray[n2++] = d * (double)fArray[n++];
                    dArray[n2++] = d23 * (double)fArray[n++];
                }
                return;
            }
            case 1: {
                double d = this.mxt;
                double d24 = this.myt;
                while (--n3 >= 0) {
                    dArray[n2++] = (double)fArray[n++] + d;
                    dArray[n2++] = (double)fArray[n++] + d24;
                }
                return;
            }
            case 0: 
        }
        while (--n3 >= 0) {
            dArray[n2++] = fArray[n++];
            dArray[n2++] = fArray[n++];
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.mxt;
                double d4 = this.myx;
                double d5 = this.myy;
                double d6 = this.myt;
                while (--n3 >= 0) {
                    double d7 = dArray[n++];
                    double d8 = dArray[n++];
                    fArray[n2++] = (float)(d * d7 + d2 * d8 + d3);
                    fArray[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
                }
                return;
            }
            case 6: {
                double d = this.mxx;
                double d9 = this.mxy;
                double d10 = this.myx;
                double d11 = this.myy;
                while (--n3 >= 0) {
                    double d12 = dArray[n++];
                    double d13 = dArray[n++];
                    fArray[n2++] = (float)(d * d12 + d9 * d13);
                    fArray[n2++] = (float)(d10 * d12 + d11 * d13);
                }
                return;
            }
            case 5: {
                double d = this.mxy;
                double d14 = this.mxt;
                double d15 = this.myx;
                double d16 = this.myt;
                while (--n3 >= 0) {
                    double d17 = dArray[n++];
                    fArray[n2++] = (float)(d * dArray[n++] + d14);
                    fArray[n2++] = (float)(d15 * d17 + d16);
                }
                return;
            }
            case 4: {
                double d = this.mxy;
                double d18 = this.myx;
                while (--n3 >= 0) {
                    double d19 = dArray[n++];
                    fArray[n2++] = (float)(d * dArray[n++]);
                    fArray[n2++] = (float)(d18 * d19);
                }
                return;
            }
            case 3: {
                double d = this.mxx;
                double d20 = this.mxt;
                double d21 = this.myy;
                double d22 = this.myt;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(d * dArray[n++] + d20);
                    fArray[n2++] = (float)(d21 * dArray[n++] + d22);
                }
                return;
            }
            case 2: {
                double d = this.mxx;
                double d23 = this.myy;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(d * dArray[n++]);
                    fArray[n2++] = (float)(d23 * dArray[n++]);
                }
                return;
            }
            case 1: {
                double d = this.mxt;
                double d24 = this.myt;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(dArray[n++] + d);
                    fArray[n2++] = (float)(dArray[n++] + d24);
                }
                return;
            }
            case 0: 
        }
        while (--n3 >= 0) {
            fArray[n2++] = (float)dArray[n++];
            fArray[n2++] = (float)dArray[n++];
        }
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.myx;
                double d4 = this.myy;
                while (--n3 >= 0) {
                    double d5 = dArray[n++];
                    double d6 = dArray[n++];
                    dArray2[n2++] = d5 * d + d6 * d2;
                    dArray2[n2++] = d5 * d3 + d6 * d4;
                }
                return;
            }
            case 4: 
            case 5: {
                double d = this.mxy;
                double d7 = this.myx;
                while (--n3 >= 0) {
                    double d8 = dArray[n++];
                    dArray2[n2++] = dArray[n++] * d;
                    dArray2[n2++] = d8 * d7;
                }
                return;
            }
            case 2: 
            case 3: {
                double d = this.mxx;
                double d9 = this.myy;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] * d;
                    dArray2[n2++] = dArray[n++] * d9;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        if (point2D2 == null) {
            point2D2 = new Point2D();
        }
        double d = point2D.x;
        double d2 = point2D.y;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                d -= this.mxt;
                d2 -= this.myt;
            }
            case 6: {
                double d3 = this.mxx * this.myy - this.mxy * this.myx;
                if (d3 == 0.0 || Math.abs(d3) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d3);
                }
                point2D2.setLocation((float)((d * this.myy - d2 * this.mxy) / d3), (float)((d2 * this.mxx - d * this.myx) / d3));
                return point2D2;
            }
            case 5: {
                d -= this.mxt;
                d2 -= this.myt;
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation((float)(d2 / this.myx), (float)(d / this.mxy));
                return point2D2;
            }
            case 3: {
                d -= this.mxt;
                d2 -= this.myt;
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation((float)(d / this.mxx), (float)(d2 / this.myy));
                return point2D2;
            }
            case 1: {
                point2D2.setLocation((float)(d - this.mxt), (float)(d2 - this.myt));
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation((float)d, (float)d2);
        return point2D2;
    }

    public void inverseTransform(Bounds2D bounds2D, Bounds2D bounds2D2) throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double d = this.mxx * this.myy - this.mxy * this.myx;
                if (d == 0.0 || Math.abs(d) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d);
                }
                double d2 = (double)bounds2D.x1 - this.mxt;
                double d3 = (double)bounds2D.y1 - this.myt;
                double d4 = (double)bounds2D.x2 - this.mxt;
                double d5 = (double)bounds2D.y2 - this.myt;
                bounds2D2.setFromDiagonal((float)((d2 * this.myy - d3 * this.mxy) / d), (float)((d3 * this.mxx - d2 * this.myx) / d), (float)((d4 * this.myy - d5 * this.mxy) / d), (float)((d5 * this.mxx - d4 * this.myx) / d));
                bounds2D2.add((float)((d4 * this.myy - d3 * this.mxy) / d), (float)((d3 * this.mxx - d4 * this.myx) / d));
                bounds2D2.add((float)((d2 * this.myy - d5 * this.mxy) / d), (float)((d5 * this.mxx - d2 * this.myx) / d));
                return;
            }
            case 5: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                bounds2D2.setFromDiagonal((float)(((double)bounds2D.y1 - this.myt) / this.myx), (float)(((double)bounds2D.x1 - this.mxt) / this.mxy), (float)(((double)bounds2D.y2 - this.myt) / this.myx), (float)(((double)bounds2D.x2 - this.mxt) / this.mxy));
                break;
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                bounds2D2.setFromDiagonal((float)((double)bounds2D.y1 / this.myx), (float)((double)bounds2D.x1 / this.mxy), (float)((double)bounds2D.y2 / this.myx), (float)((double)bounds2D.x2 / this.mxy));
                break;
            }
            case 3: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                bounds2D2.setFromDiagonal((float)(((double)bounds2D.x1 - this.mxt) / this.mxx), (float)(((double)bounds2D.y1 - this.myt) / this.myy), (float)(((double)bounds2D.x2 - this.mxt) / this.mxx), (float)(((double)bounds2D.y2 - this.myt) / this.myy));
                break;
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                bounds2D2.setFromDiagonal((float)((double)bounds2D.x1 / this.mxx), (float)((double)bounds2D.y1 / this.myy), (float)((double)bounds2D.x2 / this.mxx), (float)((double)bounds2D.y2 / this.myy));
                break;
            }
            case 1: {
                bounds2D2.setBounds((float)((double)bounds2D.x1 - this.mxt), (float)((double)bounds2D.y1 - this.myt), (float)((double)bounds2D.x2 - this.mxt), (float)((double)bounds2D.y2 - this.myt));
                return;
            }
            case 0: {
                if (bounds2D2 != bounds2D) {
                    bounds2D2.setBounds(bounds2D);
                }
                return;
            }
        }
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.mxt;
                double d4 = this.myx;
                double d5 = this.myy;
                double d6 = this.myt;
                double d7 = d * d5 - d2 * d4;
                if (d7 == 0.0 || Math.abs(d7) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d7);
                }
                while (--n3 >= 0) {
                    double d8 = dArray[n++] - d3;
                    double d9 = dArray[n++] - d6;
                    dArray2[n2++] = (d8 * d5 - d9 * d2) / d7;
                    dArray2[n2++] = (d9 * d - d8 * d4) / d7;
                }
                return;
            }
            case 6: {
                double d = this.mxx;
                double d10 = this.mxy;
                double d11 = this.myx;
                double d12 = this.myy;
                double d13 = d * d12 - d10 * d11;
                if (d13 == 0.0 || Math.abs(d13) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d13);
                }
                while (--n3 >= 0) {
                    double d14 = dArray[n++];
                    double d15 = dArray[n++];
                    dArray2[n2++] = (d14 * d12 - d15 * d10) / d13;
                    dArray2[n2++] = (d15 * d - d14 * d11) / d13;
                }
                return;
            }
            case 5: {
                double d = this.mxy;
                double d16 = this.mxt;
                double d17 = this.myx;
                double d18 = this.myt;
                if (d == 0.0 || d17 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    double d19 = dArray[n++] - d16;
                    dArray2[n2++] = (dArray[n++] - d18) / d17;
                    dArray2[n2++] = d19 / d;
                }
                return;
            }
            case 4: {
                double d = this.mxy;
                double d20 = this.myx;
                if (d == 0.0 || d20 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    double d21 = dArray[n++];
                    dArray2[n2++] = dArray[n++] / d20;
                    dArray2[n2++] = d21 / d;
                }
                return;
            }
            case 3: {
                double d = this.mxx;
                double d22 = this.mxt;
                double d23 = this.myy;
                double d24 = this.myt;
                if (d == 0.0 || d23 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    dArray2[n2++] = (dArray[n++] - d22) / d;
                    dArray2[n2++] = (dArray[n++] - d24) / d23;
                }
                return;
            }
            case 2: {
                double d = this.mxx;
                double d25 = this.myy;
                if (d == 0.0 || d25 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] / d;
                    dArray2[n2++] = dArray[n++] / d25;
                }
                return;
            }
            case 1: {
                double d = this.mxt;
                double d26 = this.myt;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] - d;
                    dArray2[n2++] = dArray[n++] - d26;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public Shape createTransformedShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        return new Path2D(shape, this);
    }

    public void translate(double d, double d2) {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                this.mxt = d * this.mxx + d2 * this.mxy + this.mxt;
                this.myt = d * this.myx + d2 * this.myy + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 6;
                    if (this.type != -1) {
                        this.type &= 0xFFFFFFFE;
                    }
                }
                return;
            }
            case 6: {
                this.mxt = d * this.mxx + d2 * this.mxy;
                this.myt = d * this.myx + d2 * this.myy;
                if (this.mxt != 0.0 || this.myt != 0.0) {
                    this.state = 7;
                    this.type |= 1;
                }
                return;
            }
            case 5: {
                this.mxt = d2 * this.mxy + this.mxt;
                this.myt = d * this.myx + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 4;
                    if (this.type != -1) {
                        this.type &= 0xFFFFFFFE;
                    }
                }
                return;
            }
            case 4: {
                this.mxt = d2 * this.mxy;
                this.myt = d * this.myx;
                if (this.mxt != 0.0 || this.myt != 0.0) {
                    this.state = 5;
                    this.type |= 1;
                }
                return;
            }
            case 3: {
                this.mxt = d * this.mxx + this.mxt;
                this.myt = d2 * this.myy + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 2;
                    if (this.type != -1) {
                        this.type &= 0xFFFFFFFE;
                    }
                }
                return;
            }
            case 2: {
                this.mxt = d * this.mxx;
                this.myt = d2 * this.myy;
                if (this.mxt != 0.0 || this.myt != 0.0) {
                    this.state = 3;
                    this.type |= 1;
                }
                return;
            }
            case 1: {
                this.mxt = d + this.mxt;
                this.myt = d2 + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 0;
                    this.type = 0;
                }
                return;
            }
            case 0: 
        }
        this.mxt = d;
        this.myt = d2;
        if (d != 0.0 || d2 != 0.0) {
            this.state = 1;
            this.type = 1;
        }
    }

    protected final void rotate90() {
        double d = this.mxx;
        this.mxx = this.mxy;
        this.mxy = -d;
        d = this.myx;
        this.myx = this.myy;
        this.myy = -d;
        int n = rot90conversion[this.state];
        if ((n & 6) == 2 && this.mxx == 1.0 && this.myy == 1.0) {
            n -= 2;
        }
        this.state = n;
        this.type = -1;
    }

    protected final void rotate180() {
        this.mxx = -this.mxx;
        this.myy = -this.myy;
        int n = this.state;
        if ((n & 4) != 0) {
            this.mxy = -this.mxy;
            this.myx = -this.myx;
        } else {
            this.state = this.mxx == 1.0 && this.myy == 1.0 ? n & 0xFFFFFFFD : n | 2;
        }
        this.type = -1;
    }

    protected final void rotate270() {
        double d = this.mxx;
        this.mxx = -this.mxy;
        this.mxy = d;
        d = this.myx;
        this.myx = -this.myy;
        this.myy = d;
        int n = rot90conversion[this.state];
        if ((n & 6) == 2 && this.mxx == 1.0 && this.myy == 1.0) {
            n -= 2;
        }
        this.state = n;
        this.type = -1;
    }

    public void rotate(double d) {
        double d2 = Math.sin(d);
        if (d2 == 1.0) {
            this.rotate90();
        } else if (d2 == -1.0) {
            this.rotate270();
        } else {
            double d3 = Math.cos(d);
            if (d3 == -1.0) {
                this.rotate180();
            } else if (d3 != 1.0) {
                double d4 = this.mxx;
                double d5 = this.mxy;
                this.mxx = d3 * d4 + d2 * d5;
                this.mxy = -d2 * d4 + d3 * d5;
                d4 = this.myx;
                d5 = this.myy;
                this.myx = d3 * d4 + d2 * d5;
                this.myy = -d2 * d4 + d3 * d5;
                this.updateState2D();
            }
        }
    }

    public void scale(double d, double d2) {
        int n = this.state;
        switch (n) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                this.mxx *= d;
                this.myy *= d2;
            }
            case 4: 
            case 5: {
                this.mxy *= d2;
                this.myx *= d;
                if (this.mxy == 0.0 && this.myx == 0.0) {
                    n &= 1;
                    if (this.mxx == 1.0 && this.myy == 1.0) {
                        this.type = n == 0 ? 0 : 1;
                    } else {
                        n |= 2;
                        this.type = -1;
                    }
                    this.state = n;
                }
                return;
            }
            case 2: 
            case 3: {
                this.mxx *= d;
                this.myy *= d2;
                if (this.mxx == 1.0 && this.myy == 1.0) {
                    this.state = n &= 1;
                    this.type = n == 0 ? 0 : 1;
                } else {
                    this.type = -1;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.mxx = d;
        this.myy = d2;
        if (d != 1.0 || d2 != 1.0) {
            this.state = n | 2;
            this.type = -1;
        }
    }

    public void shear(double d, double d2) {
        int n = this.state;
        switch (n) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double d3 = this.mxx;
                double d4 = this.mxy;
                this.mxx = d3 + d4 * d2;
                this.mxy = d3 * d + d4;
                d3 = this.myx;
                d4 = this.myy;
                this.myx = d3 + d4 * d2;
                this.myy = d3 * d + d4;
                this.updateState2D();
                return;
            }
            case 4: 
            case 5: {
                this.mxx = this.mxy * d2;
                this.myy = this.myx * d;
                if (this.mxx != 0.0 || this.myy != 0.0) {
                    this.state = n | 2;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.mxy = this.mxx * d;
                this.myx = this.myy * d2;
                if (this.mxy != 0.0 || this.myx != 0.0) {
                    this.state = n | 4;
                }
                this.type = -1;
                return;
            }
            case 0: 
            case 1: 
        }
        this.mxy = d;
        this.myx = d2;
        if (this.mxy != 0.0 || this.myx != 0.0) {
            this.state = n | 2 | 4;
            this.type = -1;
        }
    }

    public void concatenate(BaseTransform baseTransform) {
        switch (baseTransform.getDegree()) {
            case IDENTITY: {
                return;
            }
            case TRANSLATE_2D: {
                this.translate(baseTransform.getMxt(), baseTransform.getMyt());
                return;
            }
            case AFFINE_2D: {
                break;
            }
            default: {
                if (!baseTransform.is2D()) {
                    AffineBase.degreeError(BaseTransform.Degree.AFFINE_2D);
                }
                if (baseTransform instanceof AffineBase) break;
                baseTransform = new Affine2D(baseTransform);
            }
        }
        int n = this.state;
        AffineBase affineBase = (AffineBase)baseTransform;
        int n2 = affineBase.state;
        switch (n2 << 4 | n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 112: {
                this.mxy = affineBase.mxy;
                this.myx = affineBase.myx;
            }
            case 48: {
                this.mxx = affineBase.mxx;
                this.myy = affineBase.myy;
            }
            case 16: {
                this.mxt = affineBase.mxt;
                this.myt = affineBase.myt;
                this.state = n2;
                this.type = affineBase.type;
                return;
            }
            case 96: {
                this.mxy = affineBase.mxy;
                this.myx = affineBase.myx;
            }
            case 32: {
                this.mxx = affineBase.mxx;
                this.myy = affineBase.myy;
                this.state = n2;
                this.type = affineBase.type;
                return;
            }
            case 80: {
                this.mxt = affineBase.mxt;
                this.myt = affineBase.myt;
            }
            case 64: {
                this.mxy = affineBase.mxy;
                this.myx = affineBase.myx;
                this.myy = 0.0;
                this.mxx = 0.0;
                this.state = n2;
                this.type = affineBase.type;
                return;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.translate(affineBase.mxt, affineBase.myt);
                return;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                this.scale(affineBase.mxx, affineBase.myy);
                return;
            }
            case 70: 
            case 71: {
                double d = affineBase.mxy;
                double d2 = affineBase.myx;
                double d3 = this.mxx;
                this.mxx = this.mxy * d2;
                this.mxy = d3 * d;
                d3 = this.myx;
                this.myx = this.myy * d2;
                this.myy = d3 * d;
                this.type = -1;
                return;
            }
            case 68: 
            case 69: {
                this.mxx = this.mxy * affineBase.myx;
                this.mxy = 0.0;
                this.myy = this.myx * affineBase.mxy;
                this.myx = 0.0;
                this.state = n ^ 6;
                this.type = -1;
                return;
            }
            case 66: 
            case 67: {
                this.mxy = this.mxx * affineBase.mxy;
                this.mxx = 0.0;
                this.myx = this.myy * affineBase.myx;
                this.myy = 0.0;
                this.state = n ^ 6;
                this.type = -1;
                return;
            }
            case 65: {
                this.mxx = 0.0;
                this.mxy = affineBase.mxy;
                this.myx = affineBase.myx;
                this.myy = 0.0;
                this.state = 5;
                this.type = -1;
                return;
            }
        }
        double d = affineBase.mxx;
        double d4 = affineBase.mxy;
        double d5 = affineBase.mxt;
        double d6 = affineBase.myx;
        double d7 = affineBase.myy;
        double d8 = affineBase.myt;
        switch (n) {
            default: {
                AffineBase.stateError();
            }
            case 6: {
                this.state = n | n2;
            }
            case 7: {
                double d9 = this.mxx;
                double d10 = this.mxy;
                this.mxx = d * d9 + d6 * d10;
                this.mxy = d4 * d9 + d7 * d10;
                this.mxt += d5 * d9 + d8 * d10;
                d9 = this.myx;
                d10 = this.myy;
                this.myx = d * d9 + d6 * d10;
                this.myy = d4 * d9 + d7 * d10;
                this.myt += d5 * d9 + d8 * d10;
                this.type = -1;
                return;
            }
            case 4: 
            case 5: {
                double d11 = this.mxy;
                this.mxx = d6 * d11;
                this.mxy = d7 * d11;
                this.mxt += d8 * d11;
                d11 = this.myx;
                this.myx = d * d11;
                this.myy = d4 * d11;
                this.myt += d5 * d11;
                break;
            }
            case 2: 
            case 3: {
                double d12 = this.mxx;
                this.mxx = d * d12;
                this.mxy = d4 * d12;
                this.mxt += d5 * d12;
                d12 = this.myy;
                this.myx = d6 * d12;
                this.myy = d7 * d12;
                this.myt += d8 * d12;
                break;
            }
            case 1: {
                this.mxx = d;
                this.mxy = d4;
                this.mxt += d5;
                this.myx = d6;
                this.myy = d7;
                this.myt += d8;
                this.state = n2 | 1;
                this.type = -1;
                return;
            }
        }
        this.updateState2D();
    }

    public void invert() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double d = this.mxx;
                double d2 = this.mxy;
                double d3 = this.mxt;
                double d4 = this.myx;
                double d5 = this.myy;
                double d6 = this.myt;
                double d7 = d * d5 - d2 * d4;
                if (d7 == 0.0 || Math.abs(d7) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d7);
                }
                this.mxx = d5 / d7;
                this.myx = -d4 / d7;
                this.mxy = -d2 / d7;
                this.myy = d / d7;
                this.mxt = (d2 * d6 - d5 * d3) / d7;
                this.myt = (d4 * d3 - d * d6) / d7;
                break;
            }
            case 6: {
                double d = this.mxx;
                double d8 = this.mxy;
                double d9 = this.myx;
                double d10 = this.myy;
                double d11 = d * d10 - d8 * d9;
                if (d11 == 0.0 || Math.abs(d11) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d11);
                }
                this.mxx = d10 / d11;
                this.myx = -d9 / d11;
                this.mxy = -d8 / d11;
                this.myy = d / d11;
                break;
            }
            case 5: {
                double d = this.mxy;
                double d12 = this.mxt;
                double d13 = this.myx;
                double d14 = this.myt;
                if (d == 0.0 || d13 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.myx = 1.0 / d;
                this.mxy = 1.0 / d13;
                this.mxt = -d14 / d13;
                this.myt = -d12 / d;
                break;
            }
            case 4: {
                double d = this.mxy;
                double d15 = this.myx;
                if (d == 0.0 || d15 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.myx = 1.0 / d;
                this.mxy = 1.0 / d15;
                break;
            }
            case 3: {
                double d = this.mxx;
                double d16 = this.mxt;
                double d17 = this.myy;
                double d18 = this.myt;
                if (d == 0.0 || d17 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.mxx = 1.0 / d;
                this.myy = 1.0 / d17;
                this.mxt = -d16 / d;
                this.myt = -d18 / d17;
                break;
            }
            case 2: {
                double d = this.mxx;
                double d19 = this.myy;
                if (d == 0.0 || d19 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.mxx = 1.0 / d;
                this.myy = 1.0 / d19;
                break;
            }
            case 1: {
                this.mxt = -this.mxt;
                this.myt = -this.myt;
            }
            case 0: 
        }
    }
}

