/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;

public class Translate2D
extends BaseTransform {
    private double mxt;
    private double myt;
    private static final long BASE_HASH;

    public static BaseTransform getInstance(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate2D(d, d2);
    }

    public Translate2D(double d, double d2) {
        this.mxt = d;
        this.myt = d2;
    }

    public Translate2D(BaseTransform baseTransform) {
        if (!baseTransform.isTranslateOrIdentity()) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = baseTransform.getMxt();
        this.myt = baseTransform.getMyt();
    }

    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.TRANSLATE_2D;
    }

    public double getDeterminant() {
        return 1.0;
    }

    public double getMxt() {
        return this.mxt;
    }

    public double getMyt() {
        return this.myt;
    }

    public int getType() {
        return this.mxt == 0.0 && this.myt == 0.0 ? 0 : 1;
    }

    public boolean isIdentity() {
        return this.mxt == 0.0 && this.myt == 0.0;
    }

    public boolean isTranslateOrIdentity() {
        return true;
    }

    public boolean is2D() {
        return true;
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = Translate2D.makePoint(point2D, point2D2);
        }
        point2D2.setLocation((float)((double)point2D.x + this.mxt), (float)((double)point2D.y + this.myt));
        return point2D2;
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = Translate2D.makePoint(point2D, point2D2);
        }
        point2D2.setLocation((float)((double)point2D.x - this.mxt), (float)((double)point2D.y - this.myt));
        return point2D2;
    }

    public Vec3d transform(Vec3d vec3d, Vec3d vec3d2) {
        if (vec3d2 == null) {
            vec3d2 = new Vec3d();
        }
        vec3d2.x = vec3d.x + this.mxt;
        vec3d2.y = vec3d.y + this.myt;
        vec3d2.z = vec3d.z;
        return vec3d2;
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray == fArray2 && n == n2 && this.isIdentity()) {
            return;
        }
        float f = (float)this.mxt;
        float f2 = (float)this.myt;
        for (int i = 0; i < n3; ++i) {
            fArray2[n2++] = fArray[n++] + f;
            fArray2[n2++] = fArray[n++] + f2;
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == dArray2 && n == n2 && this.isIdentity()) {
            return;
        }
        double d = this.mxt;
        double d2 = this.myt;
        for (int i = 0; i < n3; ++i) {
            dArray2[n2++] = dArray[n++] + d;
            dArray2[n2++] = dArray[n++] + d2;
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        double d = this.mxt;
        double d2 = this.myt;
        for (int i = 0; i < n3; ++i) {
            dArray[n2++] = (double)fArray[n++] + d;
            dArray[n2++] = (double)fArray[n++] + d2;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        double d = this.mxt;
        double d2 = this.myt;
        for (int i = 0; i < n3; ++i) {
            fArray[n2++] = (float)(dArray[n++] + d);
            fArray[n2++] = (float)(dArray[n++] + d2);
        }
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        IDENTITY_TRANSFORM.transform(dArray, n, dArray2, n2, n3);
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == dArray2 && n == n2 && this.isIdentity()) {
            return;
        }
        double d = this.mxt;
        double d2 = this.myt;
        for (int i = 0; i < n3; ++i) {
            dArray2[n2++] = dArray[n++] - d;
            dArray2[n2++] = dArray[n++] - d2;
        }
    }

    public void transform(Bounds2D bounds2D, Bounds2D bounds2D2) {
        bounds2D2.setBounds((float)((double)bounds2D.x1 + this.mxt), (float)((double)bounds2D.y1 + this.myt), (float)((double)bounds2D.x2 + this.mxt), (float)((double)bounds2D.y2 + this.myt));
    }

    public void inverseTransform(Bounds2D bounds2D, Bounds2D bounds2D2) {
        bounds2D2.setBounds((float)((double)bounds2D.x1 - this.mxt), (float)((double)bounds2D.y1 - this.myt), (float)((double)bounds2D.x2 - this.mxt), (float)((double)bounds2D.y2 - this.myt));
    }

    public Shape createTransformedShape(Shape shape) {
        return new Path2D(shape, this);
    }

    public void setToIdentity() {
        this.myt = 0.0;
        this.mxt = 0.0;
    }

    public void setTransform(BaseTransform baseTransform) {
        if (!baseTransform.isTranslateOrIdentity()) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = baseTransform.getMxt();
        this.myt = baseTransform.getMyt();
    }

    public void invert() {
        this.mxt = -this.mxt;
        this.myt = -this.myt;
    }

    public void restoreTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d != 1.0 || d2 != 0.0 || d3 != 0.0 || d4 != 1.0) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = d5;
        this.myt = d6;
    }

    public void restoreTransform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        if (d != 1.0 || d2 != 0.0 || d3 != 0.0 || d5 != 0.0 || d6 != 1.0 || d7 != 0.0 || d9 != 0.0 || d10 != 0.0 || d11 != 1.0 || d12 != 0.0) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = d4;
        this.myt = d8;
    }

    public BaseTransform deriveWithTranslation(double d, double d2) {
        this.mxt += d;
        this.myt += d2;
        return this;
    }

    public BaseTransform deriveWithPreTranslation(double d, double d2) {
        this.mxt += d;
        this.myt += d2;
        return this;
    }

    public BaseTransform deriveWithConcatenation(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d == 1.0 && d2 == 0.0 && d3 == 0.0 && d4 == 1.0) {
            this.mxt += d5;
            this.myt += d6;
            return this;
        }
        return new Affine2D(d, d2, d3, d4, this.mxt + d5, this.myt + d6);
    }

    public BaseTransform deriveWithConcatenation(BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            this.mxt += baseTransform.getMxt();
            this.myt += baseTransform.getMyt();
            return this;
        }
        if (baseTransform.is2D()) {
            return Translate2D.getInstance(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), this.mxt + baseTransform.getMxt(), this.myt + baseTransform.getMyt());
        }
        Affine3D affine3D = new Affine3D(baseTransform);
        affine3D.preTranslate(this.mxt, this.myt, 0.0);
        return affine3D;
    }

    public BaseTransform deriveWithNewTransform(BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            this.mxt = baseTransform.getMxt();
            this.myt = baseTransform.getMyt();
            return this;
        }
        return Translate2D.getInstance(baseTransform);
    }

    public BaseTransform createInverse() {
        if (this.isIdentity()) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate2D(-this.mxt, -this.myt);
    }

    private static double _matround(double d) {
        return Math.rint(d * 1.0E15) / 1.0E15;
    }

    public String toString() {
        return "Translate2D[" + Translate2D._matround(this.mxt) + ", " + Translate2D._matround(this.myt) + "]";
    }

    public BaseTransform copy() {
        return new Translate2D(this.mxt, this.myt);
    }

    public boolean equals(Object object) {
        if (object instanceof BaseTransform) {
            BaseTransform baseTransform = (BaseTransform)object;
            return baseTransform.isTranslateOrIdentity() && baseTransform.getMxt() == this.mxt && baseTransform.getMyt() == this.myt;
        }
        return false;
    }

    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        long l = BASE_HASH;
        l = l * 31L + Double.doubleToLongBits(this.getMyt());
        l = l * 31L + Double.doubleToLongBits(this.getMxt());
        return (int)l ^ (int)(l >> 32);
    }

    static {
        long l = 0L;
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzz());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzy());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzx());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyz());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxz());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyy());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyx());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxy());
        l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxx());
        BASE_HASH = l = l * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzt());
    }
}

