/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io;

import com.sun.javafx.io.FileContents;
import com.sun.javafx.io.FileContentsImpl;
import com.sun.javafx.io.MuffinStore;
import com.sun.javafx.io.Properties;
import com.sun.javafx.io.SameDomainAccessException;
import com.sun.javafx.io.Storage;
import com.sun.javafx.io.StorageListener;
import com.sun.javafx.io.URLUtil;
import com.sun.javafx.io.impl.AbstractFactory;
import com.sun.javafx.io.impl.AbstractFile;
import com.sun.javafx.io.impl.AbstractStorage;
import com.sun.javafx.runtime.SystemProperties;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class StorageImpl
implements Storage {
    public static final int CACHED = 0;
    public static final int TEMPORARY = 1;
    public static final int DIRTY = 2;
    static final int MUFFIN_TAG_INDEX = 0;
    static final int MUFFIN_MAXSIZE_INDEX = 1;
    private long _appLimit = -1L;
    private long _fileLimit = -1L;
    private static StorageImpl _instance = null;
    private static Properties _prop = null;
    public static boolean DEBUG = AbstractFactory.getAbstractStorage().isTraceEnabled();

    private StorageImpl() {
        AbstractStorage abstractStorage = AbstractFactory.getAbstractStorage();
        this._appLimit = abstractStorage.getApplicationSizeLimit();
        this._fileLimit = abstractStorage.getFileSizeLimit();
        StorageImpl.print("_appLimit=" + this._appLimit);
    }

    public long getFileSizeLimit() {
        return this._fileLimit;
    }

    public static synchronized StorageImpl getInstance() {
        if (_instance == null) {
            _instance = new StorageImpl();
        }
        return _instance;
    }

    public boolean exists(String string) {
        StorageImpl.print("exists START: name=" + string);
        final String string2 = StorageImpl.getURLName(string);
        StorageImpl.print("exists 01: name=" + string + " url=" + string2);
        AbstractFile abstractFile = AccessController.doPrivileged(new PrivilegedAction<AbstractFile>(){

            @Override
            public AbstractFile run() {
                return MuffinStore.getMuffinAttributeFile(string2);
            }
        });
        if (abstractFile == null) {
            StorageImpl.print("exists: returning false");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getURLName(String string) {
        if (string.length() <= 0) return StorageImpl.getCodebase() + string;
        if (string.charAt(0) != '/') return StorageImpl.getCodebase() + string;
        if (!AbstractFactory.getAbstractStorage().isSharingEnabled()) throw new SecurityException("Sharing is disabled");
        return StorageImpl.getDomain() + string.substring(1);
    }

    public static String getCodebase() {
        String string = SystemProperties.getCodebase();
        if (string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        return string;
    }

    public static String getDomain() {
        String string = StorageImpl.getCodebase();
        String string2 = URLUtil.getBaseURL(string);
        if (string2 != null && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        StorageImpl.print("getDomain: codebase=" + string + " domain=" + string2);
        if ("file:".equals(string2)) {
            return StorageImpl.getCodebase();
        }
        return string2;
    }

    public long getLength(final String string) throws IOException {
        this.checkAccess(string);
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return MuffinStore.getMuffinSize(string);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        return (Long)object;
    }

    public long getMaxLength(final String string) throws IOException {
        try {
            this.checkAccess(string);
        }
        catch (SameDomainAccessException sameDomainAccessException) {
            StorageImpl.print("getMaxLength: sde=" + sameDomainAccessException);
        }
        catch (IOException iOException) {
            StorageImpl.print("getMaxLength: ioe=" + iOException + ": unexpected exception, need to be investigated. Re-throw it.");
            throw iOException;
        }
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    long[] lArray = MuffinStore.getMuffinAttributes(string);
                    if (lArray == null) {
                        return new Long(-1L);
                    }
                    return new Long(lArray[1]);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        StorageImpl.print("getMaxLength: privRet=" + (Long)object);
        return (Long)object;
    }

    public long setMaxLength(final String string, long l) throws IOException {
        long l2 = l;
        this.checkAccess(string);
        if (l < 0L) {
            throw new IOException("Error: attempt to set maxSize to " + l);
        }
        l2 = this.checkSetMaxSize(string, l);
        if (l2 < 0L) {
            throw new IOException("Error: attempt to set maxSize to " + l + " rejected; too big?");
        }
        final long l3 = l2;
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    MuffinStore.putMuffinAttributes(string, StorageImpl.this.getTag(string), l3);
                    return null;
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        StorageImpl.print("setMaxLength: url=" + string + " maxsize=" + l + " privRet=" + object + " newmaxsize=" + l2);
        if (null != object && object instanceof IOException) {
            throw (IOException)object;
        }
        return l2;
    }

    private long checkSetMaxSize(final String string, long l) throws IOException {
        StorageImpl.print("checkSetMaxSize: url=" + string);
        String[] stringArray = null;
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return MuffinStore.getAccessibleMuffins(string);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        stringArray = (String[])object;
        long l2 = 0L;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                if (stringArray[i] == null || (string2 = stringArray[i]).equals(string)) continue;
                Object var10_9 = null;
                StorageImpl.print("checkSetMaxSize: friendMuffin=" + string2);
                object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            long l = StorageImpl.this.getMaxLength(string2);
                            return new Long(l);
                        }
                        catch (IOException iOException) {
                            return iOException;
                        }
                    }
                });
                if (object instanceof IOException) {
                    throw (IOException)object;
                }
                l2 += ((Long)object).longValue();
            }
        }
        long l3 = l + l2;
        StorageImpl.print("checkSetMaxSize:_appLimit=" + this._appLimit + " maxsize=" + l + " totalRequestedMaxSize=" + l3 + " friendMuffinsTotalMaxSize=" + l2);
        if (l3 > this._appLimit) {
            return this.reconcileMaxSize(l, l2, this._appLimit);
        }
        return l;
    }

    private long reconcileMaxSize(long l, long l2, long l3) {
        long l4 = l + l2;
        return l3 - l2;
    }

    private String[] getAccessibleMuffins(String string) throws IOException {
        return MuffinStore.getAccessibleMuffins(string);
    }

    public long create(final String string, long l) throws IOException {
        this.checkAccess(string);
        long l2 = l;
        if (l > 0L && (l2 = this.checkSetMaxSize(string, l)) < 0L) {
            return -1L;
        }
        final long l3 = l2;
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    MuffinStore.createMuffinEntry(string, 0, l3);
                    return new Long(l3);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        StorageImpl.print("create(url=" + string + " maxsize=" + l + ") 6 l=" + (Long)object);
        return (Long)object;
    }

    public FileContents getFileContents(final String string, StorageListener storageListener) throws IOException {
        this.checkAccess(string);
        AbstractFile abstractFile = null;
        StorageImpl.print("getFileContents(url=" + string + ")");
        abstractFile = (AbstractFile)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return MuffinStore.getMuffinFile(string);
            }
        });
        if (abstractFile == null) {
            StorageImpl.print("getFileContents(" + string + "): f=null");
            throw new IOException("File not found: " + string);
        }
        return new FileContentsImpl(abstractFile, string, this.getMaxLength(string), storageListener);
    }

    public void delete(final String string) throws IOException {
        this.checkAccess(string);
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    MuffinStore.removeMuffinEntry(string);
                    return null;
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (null != object && object instanceof IOException) {
            throw (IOException)object;
        }
    }

    public boolean clear() throws IOException {
        return this.clear(StorageImpl.getCodebase());
    }

    public boolean clear(String string) throws IOException {
        StorageImpl.print("StorageImpl.clear: START");
        final String string2 = string;
        final String[] stringArray = this.list(string);
        if (stringArray == null) {
            return true;
        }
        StorageImpl.print("clear: names.length=" + stringArray.length);
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        StorageImpl.print("clear: names[" + i + "]=" + stringArray[i]);
                        MuffinStore.removeMuffinEntry(string2 + stringArray[i]);
                    }
                }
                catch (IOException iOException) {
                    return iOException;
                }
                return null;
            }
        });
        if (object != null) {
            throw (IOException)object;
        }
        return true;
    }

    public long getAvailableBytes() {
        long l;
        block5: {
            if (!AbstractFactory.getAbstractStorage().isEnabled()) {
                return 0L;
            }
            l = 0L;
            try {
                String[] stringArray = this.list();
                if (stringArray == null) {
                    return this.getTotalBytes();
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    l += this.getLength(StorageImpl.getCodebase() + stringArray[i]);
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block5;
                iOException.printStackTrace();
            }
        }
        StorageImpl.print("getAvailableBytes: total=" + this.getTotalBytes() + " used=" + l + " available=" + (this.getTotalBytes() - l));
        return this.getTotalBytes() - l;
    }

    public long getTotalBytes() {
        if (!AbstractFactory.getAbstractStorage().isEnabled()) {
            return 0L;
        }
        return this._appLimit;
    }

    public String[] list() throws IOException {
        return this.list(StorageImpl.getCodebase());
    }

    private String[] list(String string) throws IOException {
        return this.getNames(string);
    }

    private String[] getNames(final String string) throws IOException {
        String[] stringArray = null;
        String string2 = null;
        final String string3 = string2 = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string2 = URLUtil.asPathURL(string);
                StorageImpl.print("getNames: url=" + string + " purl=" + string2);
                return string2;
            }
        });
        this.checkAccess(string3);
        stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String[] stringArray = MuffinStore.getMuffinNames(string3);
                StorageImpl.print("getNames(" + string + ") 3: pathUrl=" + string3 + " names=" + stringArray);
                return stringArray;
            }
        });
        return stringArray;
    }

    public int getTag(final String string) throws IOException {
        Object var2_2 = null;
        this.checkAccess(string);
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    long[] lArray = MuffinStore.getMuffinAttributes(string);
                    if (lArray == null) {
                        // empty if block
                    }
                    return new Integer((int)lArray[0]);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (null != object && object instanceof IOException) {
            throw (IOException)object;
        }
        return (Integer)object;
    }

    public void setTag(final String string, final int n) throws IOException {
        this.checkAccess(string);
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    MuffinStore.putMuffinAttributes(string, n, StorageImpl.this.getMaxLength(string));
                    return null;
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (null != object && object instanceof IOException) {
            throw (IOException)object;
        }
    }

    private void checkAccess(String string) throws IOException {
        if (!AbstractFactory.getAbstractStorage().isEnabled()) {
            throw new SecurityException("Storage is Disabled");
        }
        String string2 = StorageImpl.getCodebase();
        if (string2 != null) {
            int n;
            String string3;
            if (string == null || !URLUtil.getHost(string2).equals(URLUtil.getHost(string))) {
                StorageImpl.print("checkAccess 2: codebase=" + string2 + " url=" + string);
                this.throwAccessDenied(string);
            }
            if ((string3 = URLUtil.getFile(string)) == null) {
                this.throwAccessDenied(string);
            }
            if ((n = string3.lastIndexOf(47)) == -1) {
                return;
            }
            if (!URLUtil.getFile(string2).startsWith(string3.substring(0, n))) {
                StorageImpl.print("checkAccess 4: codebase.getFile=" + URLUtil.getFile(string2) + " url=" + string + " file.substring=" + string3.substring(0, n + 1));
                throw new SameDomainAccessException("Access denied to " + string + " from the same domain");
            }
        }
    }

    private void throwAccessDenied(String string) throws IOException {
        throw new IOException("Access denied to " + string);
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("StorageImpl." + string);
        }
    }
}

