/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.BaseTask;
import com.sun.javafx.io.http.impl.BufferingInputStream;
import com.sun.javafx.io.http.impl.Connection;
import com.sun.javafx.io.http.impl.HttpProgress;
import com.sun.javafx.io.http.impl.Profile;
import com.sun.javafx.io.http.impl.Progress;
import com.sun.javafx.io.http.impl.Request;
import com.sun.javafx.io.http.impl.WaitingInputStream;
import com.sun.javafx.io.http.impl.WaitingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTask
extends BaseTask {
    private static final String CANCELLED_TEXT = "Cancelled";
    private Connection connection = null;

    public HttpTask(int n, Request request, Progress progress, Profile profile) {
        super(n, request, progress, profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.notifyStart();
        try {
            this.tryRun();
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                this.setException((Exception)throwable);
            } else {
                boolean bl = throwable instanceof Error;
                String string = bl ? "encountered Error, rethrowing: " : "encountered Throwable: ";
                this.setException(new Exception(string + throwable.toString()));
                if (bl) {
                    throw (Error)throwable;
                }
            }
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean canWrite() {
        String string = this.request.getMethod();
        return !"GET".equals(string) && !"HEAD".equals(string) && !"DELETE".equals(string);
    }

    @Override
    public OutputStream getOutputStream(Map<String, String> map) throws IOException {
        if (this.canWrite()) {
            return this.connection == null ? null : new WaitingOutputStream(this.connection.getOutputStream(), this.calculateDefaultStreamSize(this.getContentLength(map)));
        }
        return null;
    }

    private boolean canRead() {
        String string = this.request.getMethod();
        return !"HEAD".equals(string) && !"DELETE".equals(string);
    }

    @Override
    public InputStream getInputStream(Map<String, String> map) throws IOException {
        if (this.canRead()) {
            return this.connection == null ? null : new BufferingInputStream(this.connection.getInputStream(), this.calculateDefaultStreamSize(this.getContentLength(map)));
        }
        return null;
    }

    private int calculateDefaultStreamSize(long l) {
        if (l < 0L) {
            return this.profile.getMaxChunkSize();
        }
        if (l < (long)this.profile.getMinChunkSize()) {
            return this.profile.getMinChunkSize();
        }
        return (int)l;
    }

    private long getContentLength(Map<String, String> map) {
        String string;
        long l = -1L;
        if (map != null && (string = map.get("content-length")) instanceof String) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(InputStream inputStream, OutputStream outputStream, boolean bl, long l) throws IOException {
        try {
            int n;
            if (this.isCancelled()) {
                throw new InterruptedIOException(CANCELLED_TEXT);
            }
            byte[] byArray = new byte[this.optimalChunkSize(l)];
            long l2 = 0L;
            this.notifyProgress(bl, true, l);
            while ((n = inputStream.read(byArray)) != -1) {
                if (this.isCancelled()) {
                    throw new InterruptedIOException(CANCELLED_TEXT);
                }
                outputStream.write(byArray, 0, n);
                outputStream.flush();
                this.notifyProgress(bl, false, l2 += (long)n);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            finally {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRun() throws IOException, InterruptedException {
        Object object;
        InputStream inputStream;
        Object object2;
        this.connection = this.profile.newConnection();
        this.connection.open(this.request.getLocation());
        this.connection.setMethod(this.request.getMethod());
        if (this.request.getHeaders() != null) {
            for (Map.Entry<String, String> object3 : this.request.getHeaders().entrySet()) {
                this.connection.setRequestProperty(object3.getKey(), object3.getValue());
            }
        }
        this.notifyConnect(true);
        this.connection.connect();
        this.notifyConnect(false);
        InputStream inputStream2 = this.request.getSource();
        if (inputStream2 != null && this.canWrite()) {
            this.notifyWrite(true);
            this.transfer(inputStream2, this.connection.getOutputStream(), false, this.getContentLength(this.request.getHeaders()));
            this.notifyWrite(false);
        } else {
            OutputStream n = this.getOutputStream(this.request.getHeaders());
            if (n != null) {
                this.notifyWrite(true);
                try {
                    this.notifyOutput(n);
                    if (n instanceof WaitingOutputStream) {
                        object2 = (WaitingOutputStream)n;
                        ((WaitingOutputStream)object2).waitUntilClosed();
                        ((WaitingOutputStream)object2).transfer(this, this.getContentLength(this.request.getHeaders()));
                    }
                }
                finally {
                    n.close();
                }
                this.notifyWrite(false);
            }
        }
        this.notifyHeaders(true);
        int n = this.connection.getResponseCode();
        if (n != 0) {
            this.notifyResponseCode(n);
        }
        if ((object2 = this.connection.getResponseMessage()) != null) {
            this.notifyResponseMessage((String)object2);
        }
        if ((inputStream = this.connection.getErrorStream()) != null) {
            this.notifyError(inputStream);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String string = this.connection.getHeaderFieldKey(i);
            object = this.connection.getHeaderField(i);
            if (string == null && object == null) break;
            linkedHashMap.put(string == null ? null : string.toLowerCase(), (String)object);
        }
        this.notifyResponseHeaders(linkedHashMap);
        this.notifyHeaders(false);
        long l = this.getContentLength(linkedHashMap);
        object = this.request.getSink();
        if (object != null && this.canRead()) {
            this.notifyRead(true);
            this.transfer(this.connection.getInputStream(), (OutputStream)object, true, l);
            this.notifyRead(false);
        } else {
            InputStream inputStream3 = this.getInputStream(linkedHashMap);
            if (inputStream3 != null) {
                this.notifyRead(true);
                try {
                    if (inputStream3 instanceof BufferingInputStream) {
                        BufferingInputStream bufferingInputStream = (BufferingInputStream)inputStream3;
                        WaitingInputStream waitingInputStream = new WaitingInputStream(bufferingInputStream.transfer(this, l));
                        if (bufferingInputStream.available() > 0) {
                            this.notifyInput(waitingInputStream);
                            waitingInputStream.waitUntilClosed();
                        }
                    } else {
                        this.notifyInput(inputStream3);
                    }
                }
                finally {
                    inputStream3.close();
                }
                this.notifyRead(false);
            }
        }
    }

    protected void notifyError(InputStream inputStream) {
        this.profile.deferTask(new ErrorNotifier(this.progress, inputStream));
    }

    protected void notifyResponseCode(int n) {
        this.profile.deferTask(new ResponseCodeNotifier(this.progress, n));
    }

    protected void notifyResponseMessage(String string) {
        this.profile.deferTask(new ResponseMessageNotifier(this.progress, string));
    }

    protected void notifyResponseHeaders(Map<String, String> map) {
        this.profile.deferTask(new ResponseHeadersNotifier(this.progress, map));
    }

    public static String encodeURL(String string, boolean bl, boolean bl2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes("utf-8");
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 65 && by <= 90 || by >= 97 && by <= 122 || by >= 48 && by <= 57 || by == 45 || by == 95 || by == 46 || by == 126 || by == 42 && !bl) {
                stringBuffer.append((char)by);
                continue;
            }
            if (by == 32 && !bl2) {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            String string2 = Integer.toHexString(by & 0xFF).toUpperCase();
            if (string2.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static final class ErrorNotifier
    extends BaseTask.Notifier {
        private final InputStream is;

        ErrorNotifier(Progress progress, InputStream inputStream) {
            super(progress);
            this.is = inputStream;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http error stream to non-http progress");
            }
        }

        public void run() {
            ((HttpProgress)this.progress).setError(this.is);
        }
    }

    static final class ResponseCodeNotifier
    extends BaseTask.Notifier {
        private final int code;

        ResponseCodeNotifier(Progress progress, int n) {
            super(progress);
            this.code = n;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http response code to non-http progress");
            }
        }

        public void run() {
            ((HttpProgress)this.progress).setResponseCode(this.code);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ResponseHeadersNotifier
    extends BaseTask.Notifier {
        private final Map<String, String> headers;

        ResponseHeadersNotifier(Progress progress, Map<String, String> map) {
            super(progress);
            this.headers = map;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http response headers to non-http progress");
            }
        }

        @Override
        public void run() {
            ((HttpProgress)this.progress).setResponseHeaders(this.headers);
        }
    }

    static final class ResponseMessageNotifier
    extends BaseTask.Notifier {
        private final String message;

        ResponseMessageNotifier(Progress progress, String string) {
            super(progress);
            this.message = string;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http response message to non-http progress");
            }
        }

        public void run() {
            ((HttpProgress)this.progress).setResponseMessage(this.message);
        }
    }
}

