/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import java.io.IOException;
import java.io.InputStream;

class WaitingInputStream
extends InputStream {
    private final InputStream is;
    private volatile boolean closed;

    WaitingInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("\"InputStream in\" has illegal value: null");
        }
        this.is = inputStream;
        this.closed = false;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.is.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.is.read(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        WaitingInputStream waitingInputStream = this;
        synchronized (waitingInputStream) {
            if (!this.closed) {
                this.is.close();
                this.closed = true;
            }
            this.notifyAll();
        }
    }

    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    public void mark(int n) {
        this.is.mark(n);
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilClosed() throws InterruptedException {
        WaitingInputStream waitingInputStream = this;
        synchronized (waitingInputStream) {
            while (!this.closed) {
                this.wait();
            }
        }
    }
}

