/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.DependentsManager;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class DependentsGraphWriter {
    private static final String GXL_NS = "http://www.gupro.de/GXL/gxl-1.0.dtd";
    private static final String GXL = "gxl";
    private static final String GRAPH = "graph";
    private static final String NODE = "node";
    private static final String EDGE = "edge";
    private static final String ATTR = "attr";
    private static final String STRING = "string";
    private static final String BOOL = "bool";
    private static final String ID = "id";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String EDGEMODE = "edgemode";
    private static final String NAME = "name";
    private static final String DIRECTED = "directed";
    private static final String ATTR_ID = "ID";
    private static final String ATTR_IDREF = "IDREF";
    private static final String ATTR_CDATA = "CDATA";
    private static final String ATTR_NMTOKEN = "NMTOKEN";
    private static final String COLOR = "color";
    private static final String INTEROBJECT_EDGE_COLOR = "red";
    private Map<FXObject, FXObject> allObjects = new IdentityHashMap<FXObject, FXObject>();
    private AttributesImpl attrs = new AttributesImpl();
    private ContentHandler handler;
    private boolean followFields;

    public static void write(FXObject fXObject, String string) {
        DependentsGraphWriter.write(fXObject, string, false);
    }

    public static void write(FXObject fXObject, String string, boolean bl) {
        DependentsGraphWriter.write(fXObject, new File(string), bl);
    }

    public static void write(FXObject fXObject, File file) {
        DependentsGraphWriter.write(fXObject, file, false);
    }

    public static void write(FXObject fXObject, File file, boolean bl) {
        DependentsGraphWriter dependentsGraphWriter = new DependentsGraphWriter(file, bl);
        dependentsGraphWriter.start(file.getName());
        dependentsGraphWriter.writeDependencies(fXObject);
        dependentsGraphWriter.end();
    }

    private DependentsGraphWriter(File file, boolean bl) {
        this.handler = DependentsGraphWriter.makeContentHandler(file);
        this.followFields = bl;
    }

    private static ContentHandler makeContentHandler(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            StreamResult streamResult = new StreamResult(bufferedOutputStream);
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(streamResult);
            return transformerHandler;
        }
        catch (Exception exception) {
            throw DependentsGraphWriter.wrapException(exception);
        }
    }

    private void start(String string) {
        this.startDocument();
        this.startElement(GXL);
        this.attrs.clear();
        this.attrs.addAttribute("", ID, ID, ATTR_ID, string);
        this.attrs.addAttribute("", EDGEMODE, EDGEMODE, ATTR_CDATA, DIRECTED);
        this.startElement(GRAPH, this.attrs);
    }

    private void end() {
        for (FXObject fXObject : this.allObjects.keySet()) {
            this.attrs.clear();
            this.attrs.addAttribute("", ID, ID, ATTR_ID, this.id(fXObject));
            this.startElement(NODE, this.attrs);
            this.endElement(NODE);
        }
        this.endElement(GRAPH);
        this.endElement(GXL);
        this.endDocument();
        this.allObjects.clear();
        this.attrs.clear();
        this.allObjects = null;
        this.attrs = null;
        this.handler = null;
    }

    private void writeDependencies(FXObject fXObject) {
        if (this.allObjects.containsKey(fXObject)) {
            return;
        }
        this.allObjects.put(fXObject, fXObject);
        List<FXObject> list = DependentsManager.getDependents(fXObject);
        for (FXObject fXObject2 : list) {
            this.writeDependency(fXObject2, fXObject);
            this.writeDependencies(fXObject2);
        }
        if (this.followFields) {
            int n = fXObject.count$();
            for (int i = 0; i < n; ++i) {
                Sequence sequence;
                Object object = fXObject.get$(i);
                if (object instanceof FXObject) {
                    this.writeDependencies((FXObject)object);
                    continue;
                }
                if (!(object instanceof Sequence) || (sequence = (Sequence)object).getElementType() != TypeInfo.Object) continue;
                for (Object t : sequence) {
                    if (!(t instanceof FXObject)) continue;
                    this.writeDependencies((FXObject)t);
                }
            }
        }
    }

    private void writeDependency(FXObject fXObject, FXObject fXObject2) {
        this.attrs.clear();
        this.attrs.addAttribute("", FROM, FROM, ATTR_IDREF, this.id(fXObject));
        this.attrs.addAttribute("", TO, TO, ATTR_IDREF, this.id(fXObject2));
        this.startElement(EDGE, this.attrs);
        this.attrs.clear();
        this.attrs.addAttribute("", NAME, NAME, ATTR_NMTOKEN, COLOR);
        this.startElement(ATTR, this.attrs);
        this.startElement(STRING);
        this.emitData(INTEROBJECT_EDGE_COLOR);
        this.endElement(STRING);
        this.endElement(ATTR);
        this.endElement(EDGE);
    }

    private String id(FXObject fXObject) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fXObject.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(System.identityHashCode(fXObject)));
        return stringBuilder.toString();
    }

    private void startDocument() {
        try {
            this.handler.startDocument();
        }
        catch (Exception exception) {
            throw DependentsGraphWriter.wrapException(exception);
        }
    }

    private void endDocument() {
        try {
            this.handler.endDocument();
        }
        catch (Exception exception) {
            throw DependentsGraphWriter.wrapException(exception);
        }
    }

    private void startElement(String string) {
        this.attrs.clear();
        this.startElement(string, this.attrs);
    }

    private void startElement(String string, Attributes attributes) {
        try {
            this.handler.startElement(GXL_NS, string, string, attributes);
        }
        catch (Exception exception) {
            throw DependentsGraphWriter.wrapException(exception);
        }
    }

    private void endElement(String string) {
        try {
            this.handler.endElement(GXL_NS, string, string);
        }
        catch (Exception exception) {
            throw DependentsGraphWriter.wrapException(exception);
        }
    }

    private void emitData(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        try {
            this.handler.characters(cArray, 0, cArray.length);
        }
        catch (Exception exception) {
            throw DependentsGraphWriter.wrapException(exception);
        }
    }

    private static RuntimeException wrapException(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }
}

