/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.Dep;
import com.sun.javafx.runtime.DepChain;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.WeakBinderRef;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependentsManager {
    public static void addDependent(FXObject fXObject, int n, FXObject fXObject2, int n2) {
        Dep dep = Dep.newDependency(fXObject2, n2);
        dep.linkToBindee(fXObject, n);
        WeakBinderRef.checkForCleanups();
    }

    public static void removeDependent(FXObject fXObject, int n, FXObject fXObject2) {
        DepChain depChain = DepChain.find(n, fXObject.getDepChain$internal$());
        if (depChain == null) {
            return;
        }
        Dep dep = null;
        WeakBinderRef weakBinderRef = WeakBinderRef.instance(fXObject2);
        Dep dep2 = weakBinderRef.bindees;
        while (dep2 != null) {
            Dep dep3 = dep2.nextInBindees;
            if (dep2.chain == depChain) {
                if (dep == null) {
                    weakBinderRef.bindees = dep3;
                } else {
                    dep.nextInBindees = dep3;
                }
                dep2.unlinkFromBindee();
                return;
            }
            dep = dep2;
            dep2 = dep3;
        }
    }

    public static void switchDependence(FXObject fXObject, FXObject fXObject2, int n, FXObject fXObject3, int n2, int n3) {
        if (fXObject2 != null) {
            fXObject2.removeDependent$(n, fXObject);
        }
        if (fXObject3 != null) {
            fXObject3.addDependent$(n2, fXObject, n3);
        }
    }

    public static void notifyDependents(FXObject fXObject, int n, int n2, int n3, int n4, int n5) {
        DepChain depChain = DepChain.find(n, fXObject.getDepChain$internal$());
        if (depChain == null) {
            return;
        }
        Dep dep = depChain.dependencies;
        while (dep != null) {
            Dep dep2 = dep.nextInBinders;
            WeakBinderRef weakBinderRef = dep.binderRef;
            if (weakBinderRef != null) {
                FXObject fXObject2 = (FXObject)weakBinderRef.get();
                if (fXObject2 == null) {
                    weakBinderRef.cleanup();
                } else {
                    boolean bl = true;
                    try {
                        bl = fXObject2.update$(fXObject, dep.depNum, n2, n3, n4, n5);
                    }
                    catch (RuntimeException runtimeException) {
                        ErrorHandler.bindException(runtimeException);
                    }
                    if (!bl) {
                        Dep dep3 = null;
                        Dep dep4 = weakBinderRef.bindees;
                        while (dep4 != null) {
                            Dep dep5 = dep4.nextInBindees;
                            if (dep4 == dep) {
                                if (dep3 == null) {
                                    weakBinderRef.bindees = dep5;
                                } else {
                                    dep3.nextInBindees = dep5;
                                }
                                dep.unlinkFromBindee();
                                break;
                            }
                            dep3 = dep4;
                            dep4 = dep5;
                        }
                    }
                }
            }
            dep = dep2;
        }
    }

    public static int getListenerCount(FXObject fXObject) {
        return DependentsManager.getListenerCount(fXObject.getDepChain$internal$());
    }

    private static int getListenerCount(DepChain depChain) {
        if (depChain == null) {
            return 0;
        }
        int n = 0;
        Dep dep = depChain.dependencies;
        while (dep != null) {
            WeakBinderRef weakBinderRef = dep.binderRef;
            if (weakBinderRef != null && weakBinderRef.get() != null) {
                ++n;
            }
            dep = dep.nextInBinders;
        }
        return n + DependentsManager.getListenerCount(depChain.child0) + DependentsManager.getListenerCount(depChain.child1);
    }

    public static List<FXObject> getDependents(FXObject fXObject) {
        ArrayList<FXObject> arrayList = new ArrayList<FXObject>();
        DependentsManager.getDependents(fXObject.getDepChain$internal$(), arrayList);
        return arrayList;
    }

    private static void getDependents(DepChain depChain, List<FXObject> list) {
        if (depChain == null) {
            return;
        }
        Dep dep = depChain.dependencies;
        while (dep != null) {
            WeakBinderRef weakBinderRef = dep.binderRef;
            if (weakBinderRef != null && weakBinderRef.get() != null) {
                list.add((FXObject)weakBinderRef.get());
            }
            dep = dep.nextInBinders;
        }
        DependentsManager.getDependents(depChain.child0, list);
        DependentsManager.getDependents(depChain.child1, list);
    }
}

