/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericTypeInfo<T extends Number>
extends TypeInfo<T> {
    public NumericTypeInfo(T t, TypeInfo.Types types) {
        super(t, types);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public long longValue(T t) {
        return ((Number)t).longValue();
    }

    public int intValue(T t) {
        return ((Number)t).intValue();
    }

    public short shortValue(T t) {
        return ((Number)t).shortValue();
    }

    public byte byteValue(T t) {
        return ((Number)t).byteValue();
    }

    public double doubleValue(T t) {
        return ((Number)t).doubleValue();
    }

    public float floatValue(T t) {
        return ((Number)t).floatValue();
    }

    public T[] makeArray(int n) {
        return Util.newNumberArray((int)n);
    }

    public <V extends Number> T asPreferred(NumericTypeInfo<V> numericTypeInfo, V v) {
        switch (this.type) {
            case INT: {
                return (T)java.lang.Integer.valueOf(numericTypeInfo.intValue(v));
            }
            case SHORT: {
                return (T)java.lang.Short.valueOf(numericTypeInfo.shortValue(v));
            }
            case BYTE: {
                return (T)java.lang.Byte.valueOf(numericTypeInfo.byteValue(v));
            }
            case LONG: {
                return (T)java.lang.Long.valueOf(numericTypeInfo.longValue(v));
            }
            case FLOAT: {
                return (T)java.lang.Float.valueOf(numericTypeInfo.floatValue(v));
            }
            case DOUBLE: {
                return (T)java.lang.Double.valueOf(numericTypeInfo.doubleValue(v));
            }
        }
        throw new IllegalArgumentException();
    }
}

