/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.date;

import com.sun.javafx.runtime.date.BaseCalendar;
import com.sun.javafx.runtime.date.DateTimeEngine;
import com.sun.javafx.runtime.date.Gregorian;
import java.util.TimeZone;

class DateTimeEngineImpl
extends DateTimeEngine {
    static final Gregorian gcal = Gregorian.getInstance();
    private BaseCalendar.Date gdate;

    DateTimeEngineImpl() {
        this.gdate = gcal.newCalendarDate(null);
    }

    DateTimeEngineImpl(long l, TimeZone timeZone) {
        this.gdate = gcal.getCalendarDate(l, timeZone);
    }

    public long getInstant() {
        return gcal.getTime(this.gdate);
    }

    public int getYear() {
        int n = this.gdate.getYear();
        if (n <= 0) {
            --n;
        }
        return n;
    }

    public void setYear(int n) {
        if (n < 0) {
            ++n;
        }
        this.gdate.setYear(n);
    }

    public int getMonth() {
        return this.gdate.getMonth();
    }

    public void setMonth(int n) {
        this.gdate.setMonth(n);
    }

    public int getDayOfMonth() {
        return this.gdate.getDayOfMonth();
    }

    public void setDayOfMonth(int n) {
        this.gdate.setDayOfMonth(n);
    }

    public int getDayOfWeek() {
        return this.gdate.getDayOfWeek();
    }

    public int getHours() {
        return this.gdate.getHours();
    }

    public void setHours(int n) {
        this.gdate.setHours(n);
    }

    public int getMinutes() {
        return this.gdate.getMinutes();
    }

    public void setMinutes(int n) {
        this.gdate.setMinutes(n);
    }

    public int getSeconds() {
        return this.gdate.getSeconds();
    }

    public void setSeconds(int n) {
        this.gdate.setSeconds(n);
    }

    public int getMillis() {
        return this.gdate.getMillis();
    }

    public void setMillis(int n) {
        this.gdate.setMillis(n);
    }

    public void setDate(int n, int n2, int n3) {
        if (n < 0) {
            ++n;
        }
        this.gdate.setDate(n, n2, n3);
    }

    public void setTimeOfDay(int n, int n2, int n3, int n4) {
        this.gdate.setTimeOfDay(n, n2, n3, n4);
    }

    public int getZoneOffset() {
        return this.gdate.getZoneOffset();
    }

    public int getDaylightSaving() {
        return this.gdate.getDaylightSaving();
    }

    public void setDaylightSaving(int n) {
        this.gdate.setDaylightSaving(n);
    }

    public void setDaylightTime(boolean bl) {
        this.gdate.setDaylightTime(bl);
    }

    public TimeZone getZone() {
        return this.gdate.getZone();
    }

    public void setZone(TimeZone timeZone) {
        this.gdate.setZone(timeZone);
    }

    public boolean validate() {
        return gcal.validate(this.gdate);
    }

    public boolean isNormalized() {
        return this.gdate.isNormalized();
    }

    public void resetNormalized() {
        this.gdate.setNormalized(false);
    }

    public String toString() {
        return this.gdate.toString();
    }
}

