/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import com.sun.javafx.runtime.liveconnect.FXTypeDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.reflect.FXClassType;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXFunctionType;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;
import javafx.reflect.FXVarMember;

public class FXClassDelegate
extends FXTypeDelegate {
    private FXClassType clazz;
    private Bridge bridge;
    private Map<String, FXVarMember> varMap;
    private Map<String, FXVarMember> lowerCaseVarMap;
    private Map<String, FunctionBundle> functionMap;
    private Map<String, FunctionBundle> lowerCaseFunctionMap;

    public FXClassDelegate(FXClassType fXClassType, Bridge bridge) {
        this.clazz = fXClassType;
        this.bridge = bridge;
    }

    public boolean invoke(String string, Object object, Object[] objectArray, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
        FunctionBundle functionBundle;
        if (this.functionMap == null) {
            this.collectFunctions();
        }
        if ((functionBundle = this.functionMap.get(string)) == null) {
            functionBundle = this.lowerCaseFunctionMap.get(string.toLowerCase());
        }
        if (functionBundle == null) {
            throw new NoSuchMethodException(string + " in class: " + this.clazz.getName());
        }
        resultArray[0] = functionBundle.invoke(object, objectArray);
        return true;
    }

    public boolean getField(String string, Object object, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
        FXValue fXValue = this.getField0(string, object, bl, bl2);
        if (fXValue != null) {
            resultArray[0] = new Result(this.unbox(fXValue), false);
        }
        return true;
    }

    private FXValue getField0(String string, Object object, boolean bl, boolean bl2) throws Exception {
        FXVarMember fXVarMember;
        if (this.varMap == null) {
            this.collectVariables();
        }
        if ((fXVarMember = this.varMap.get(string)) == null) {
            fXVarMember = this.lowerCaseVarMap.get(string);
        }
        if (fXVarMember == null) {
            throw new NoSuchFieldException(string);
        }
        return fXVarMember.getValue((FXObjectValue)object);
    }

    public boolean setField(String string, Object object, Object object2, boolean bl, boolean bl2) throws Exception {
        this.setField0(string, (FXObjectValue)object, object2, bl, bl2);
        return true;
    }

    private void setField0(String string, FXObjectValue fXObjectValue, Object object, boolean bl, boolean bl2) throws Exception {
        FXVarMember fXVarMember;
        if (this.varMap == null) {
            this.collectVariables();
        }
        if ((fXVarMember = this.varMap.get(string)) == null) {
            fXVarMember = this.lowerCaseVarMap.get(string);
        }
        if (fXVarMember == null) {
            throw new NoSuchFieldException(string);
        }
        fXVarMember.setValue(fXObjectValue, (FXValue)this.bridge.convert(object, (Object)fXVarMember.getType()));
    }

    public boolean hasField(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        blArray[0] = this.hasField0(string, (FXValue)object, bl2);
        return true;
    }

    private boolean hasField0(String string, FXValue fXValue, boolean bl) {
        FXVarMember fXVarMember;
        if (this.varMap == null) {
            this.collectVariables();
        }
        if ((fXVarMember = this.varMap.get(string)) == null) {
            fXVarMember = this.lowerCaseVarMap.get(string);
        }
        return fXVarMember != null;
    }

    public boolean hasMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        blArray[0] = this.hasMethod0(string, (FXObjectValue)object, bl2);
        return true;
    }

    private boolean hasMethod0(String string, FXObjectValue fXObjectValue, boolean bl) {
        FunctionBundle functionBundle;
        if (this.functionMap == null) {
            this.collectFunctions();
        }
        if ((functionBundle = this.functionMap.get(string)) != null) {
            return true;
        }
        functionBundle = this.lowerCaseFunctionMap.get(string.toLowerCase());
        return functionBundle != null;
    }

    public boolean hasFieldOrMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        blArray[0] = bl3 = this.hasField0(string, (FXObjectValue)object, bl2) || this.hasMethod0(string, (FXObjectValue)object, bl2);
        return true;
    }

    public Object findClass(String string) {
        return null;
    }

    public Object newInstance(Object object, Object[] objectArray) throws Exception {
        return null;
    }

    private void collectVariables() {
        List<FXVarMember> list = this.clazz.getVariables(true);
        HashMap<String, FXVarMember> hashMap = new HashMap<String, FXVarMember>();
        HashMap<String, FXVarMember> hashMap2 = new HashMap<String, FXVarMember>();
        for (FXVarMember fXVarMember : list) {
            hashMap.put(fXVarMember.getName(), fXVarMember);
            hashMap2.put(fXVarMember.getName().toLowerCase(), fXVarMember);
        }
        this.varMap = hashMap;
        this.lowerCaseVarMap = hashMap2;
    }

    private void collectFunctions() {
        List<FXFunctionMember> list = this.clazz.getFunctions(true);
        HashMap<String, FunctionBundle> hashMap = new HashMap<String, FunctionBundle>();
        HashMap<String, FunctionBundle> hashMap2 = new HashMap<String, FunctionBundle>();
        for (FXFunctionMember fXFunctionMember : list) {
            FunctionBundle functionBundle = (FunctionBundle)hashMap.get(fXFunctionMember.getName());
            if (functionBundle == null) {
                functionBundle = new FunctionBundle();
                hashMap.put(fXFunctionMember.getName(), functionBundle);
            }
            functionBundle.add(fXFunctionMember);
            String string = fXFunctionMember.getName().toLowerCase();
            functionBundle = (FunctionBundle)hashMap2.get(string);
            if (functionBundle == null) {
                functionBundle = new FunctionBundle();
                hashMap2.put(string, functionBundle);
            }
            functionBundle.add(fXFunctionMember);
        }
        this.functionMap = hashMap;
        this.lowerCaseFunctionMap = hashMap2;
    }

    private static String argsToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                Object object = objectArray[i];
                String string = null;
                if (object != null) {
                    string = object.getClass().getName();
                }
                stringBuffer.append(string);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class FunctionBundle {
        protected List<FunctionInfo> functions = new ArrayList<FunctionInfo>();

        private FunctionBundle() {
        }

        public void add(FXFunctionMember fXFunctionMember) {
            FunctionInfo functionInfo = new FunctionInfo(fXFunctionMember);
            if (!this.functions.contains(functionInfo)) {
                this.functions.add(functionInfo);
            }
        }

        public Result invoke(Object object, Object[] objectArray) throws Exception {
            FunctionInfo functionInfo = null;
            FunctionInfo functionInfo2 = null;
            FXType[] fXTypeArray = null;
            int n = 0;
            boolean bl = false;
            for (FunctionInfo functionInfo3 : this.functions) {
                FXType[] fXTypeArray2 = functionInfo3.getArgumentTypes();
                if (objectArray == null ? fXTypeArray2.length != 0 : fXTypeArray2.length != objectArray.length) continue;
                int n2 = 0;
                for (int i = 0; i < fXTypeArray2.length; ++i) {
                    Object object2 = objectArray[i];
                    FXType fXType = fXTypeArray2[i];
                    int n3 = FXClassDelegate.this.bridge.conversionCost(object2, (Object)fXType);
                    if (n3 < 0) {
                        n2 = -1;
                        break;
                    }
                    n2 += n3;
                }
                if (n2 < 0) continue;
                if (functionInfo == null || n2 < n) {
                    functionInfo = functionInfo3;
                    fXTypeArray = functionInfo3.getArgumentTypes();
                    n = n2;
                    bl = false;
                    continue;
                }
                if (n2 != n) continue;
                bl = true;
                functionInfo2 = functionInfo3;
            }
            if (functionInfo == null) {
                throw new IllegalArgumentException("No method found matching name " + this.functions.get(0).getName() + " and arguments " + FXClassDelegate.argsToString(objectArray));
            }
            if (bl) {
                throw new IllegalArgumentException("More than one method matching name " + this.functions.get(0).getName() + " and arguments " + FXClassDelegate.argsToString(objectArray) + "\n  Method 1: " + functionInfo.getFunction().toString() + "\n  Method 2: " + functionInfo2.getFunction().toString());
            }
            Object[] objectArray2 = null;
            if (objectArray != null) {
                objectArray2 = new FXValue[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (FXValue)FXClassDelegate.this.bridge.convert(objectArray[i], (Object)fXTypeArray[i]);
                }
            } else {
                objectArray2 = new FXValue[]{};
            }
            Object object3 = functionInfo.invoke(object, objectArray2);
            return new Result(FXClassDelegate.this.unbox(object3), false);
        }
    }

    private class FunctionInfo {
        private FXFunctionMember function;
        private FXType[] argumentTypes;
        private boolean returnsVoid;

        public FunctionInfo(FXFunctionMember fXFunctionMember) {
            this.function = fXFunctionMember;
            FXFunctionType fXFunctionType = fXFunctionMember.getType();
            this.argumentTypes = new FXType[fXFunctionType.minArgs()];
            for (int i = 0; i < this.argumentTypes.length; ++i) {
                this.argumentTypes[i] = fXFunctionType.getArgumentType(i);
            }
            FXType fXType = this.getReturnType();
            if (fXType.equals(FXClassDelegate.this.voidType)) {
                this.returnsVoid = true;
            }
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            FunctionInfo functionInfo = this;
            FunctionInfo functionInfo2 = (FunctionInfo)object;
            return functionInfo.getName().equals(functionInfo2.getName()) && functionInfo.getReturnType().equals(functionInfo2.getReturnType()) && this.arraysEqual(functionInfo.getArgumentTypes(), functionInfo2.getArgumentTypes());
        }

        private boolean arraysEqual(FXType[] fXTypeArray, FXType[] fXTypeArray2) {
            if (fXTypeArray == null != (fXTypeArray2 == null)) {
                return false;
            }
            if (fXTypeArray == null) {
                return true;
            }
            if (fXTypeArray.length != fXTypeArray2.length) {
                return false;
            }
            for (int i = 0; i < fXTypeArray.length; ++i) {
                if (fXTypeArray[i].equals(fXTypeArray2[i])) continue;
                return false;
            }
            return true;
        }

        public FXFunctionMember getFunction() {
            return this.function;
        }

        public String getName() {
            return this.getFunction().getName();
        }

        public FXType[] getArgumentTypes() {
            return this.argumentTypes;
        }

        public Object invoke(Object object, Object[] objectArray) throws Exception {
            FXValue fXValue = this.function.invoke((FXObjectValue)object, (FXValue[])objectArray);
            if (fXValue == null && this.returnsVoid) {
                return Void.TYPE;
            }
            return fXValue;
        }

        public FXType getReturnType() {
            return this.function.getType().getReturnType();
        }

        public String toString() {
            return this.function.toString();
        }
    }
}

