/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.JavaNameSpace;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import com.sun.javafx.runtime.liveconnect.FXClassDelegate;
import com.sun.javafx.runtime.liveconnect.FXSequenceDelegate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.reflect.FXClassType;
import javafx.reflect.FXLocal;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXSequenceValue;

public class FXDelegate
implements InvocationDelegate {
    private Bridge bridge;
    private String scriptClassName;
    private FXLocal.Context context = FXLocal.getContext();
    private Map<FXClassType, FXClassDelegate> classDelegates = new HashMap<FXClassType, FXClassDelegate>();
    private Set<String> notFXClasses = new HashSet<String>();
    private FXSequenceDelegate sequenceDelegate;
    private FXClassType scriptClass;

    public FXDelegate(Bridge bridge, String string) {
        this.bridge = bridge;
        this.scriptClassName = string;
    }

    public boolean invoke(String string, Object object, Object[] objectArray, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
        Object[] objectArray2 = new Object[]{object};
        InvocationDelegate invocationDelegate = this.getDelegate(objectArray2, bl, bl2);
        if (invocationDelegate == null) {
            return false;
        }
        return invocationDelegate.invoke(string, bl ? null : objectArray2[0], objectArray, bl, bl2, resultArray);
    }

    public boolean getField(String string, Object object, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
        if (bl2 && string.equalsIgnoreCase("script")) {
            resultArray[0] = new Result((Object)new JavaNameSpace(this.scriptClassName), false);
            return true;
        }
        Object[] objectArray = new Object[]{object};
        InvocationDelegate invocationDelegate = this.getDelegate(objectArray, bl, bl2);
        if (invocationDelegate == null) {
            return false;
        }
        return invocationDelegate.getField(string, bl ? null : objectArray[0], bl, bl2, resultArray);
    }

    public boolean setField(String string, Object object, Object object2, boolean bl, boolean bl2) throws Exception {
        Object[] objectArray = new Object[]{object};
        InvocationDelegate invocationDelegate = this.getDelegate(objectArray, bl, bl2);
        if (invocationDelegate == null) {
            return false;
        }
        return invocationDelegate.setField(string, bl ? null : objectArray[0], object2, bl, bl2);
    }

    public boolean hasField(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl2 && string.equalsIgnoreCase("script")) {
            blArray[0] = true;
            return true;
        }
        Object[] objectArray = new Object[]{object};
        InvocationDelegate invocationDelegate = this.getDelegate(objectArray, bl, bl2);
        if (invocationDelegate == null) {
            return false;
        }
        return invocationDelegate.hasField(string, bl ? null : objectArray[0], bl, bl2, blArray);
    }

    public boolean hasMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        Object[] objectArray = new Object[]{object};
        InvocationDelegate invocationDelegate = this.getDelegate(objectArray, bl, bl2);
        if (invocationDelegate == null) {
            return false;
        }
        return invocationDelegate.hasMethod(string, bl ? null : objectArray[0], bl, bl2, blArray);
    }

    public boolean hasFieldOrMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl2 && string.equalsIgnoreCase("script")) {
            blArray[0] = true;
            return true;
        }
        Object[] objectArray = new Object[]{object};
        InvocationDelegate invocationDelegate = this.getDelegate(objectArray, bl, bl2);
        if (invocationDelegate == null) {
            return false;
        }
        return invocationDelegate.hasFieldOrMethod(string, bl ? null : objectArray[0], bl, bl2, blArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findClass(String string) {
        Object object;
        if (this.notFXClasses.contains(string)) {
            return null;
        }
        try {
            object = this.context.findClass(string);
            if (object != null && ((FXClassType)object).isJfxType()) {
                return object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = this;
        synchronized (object) {
            this.notFXClasses.add(string);
        }
        return null;
    }

    public Object newInstance(Object object, Object[] objectArray) throws Exception {
        throw new UnsupportedOperationException("Instantiation of JavaFX classes not yet supported");
    }

    private synchronized InvocationDelegate getDelegate(Object[] objectArray, boolean bl, boolean bl2) {
        FXLocal.ObjectValue objectValue;
        FXClassType fXClassType;
        Object object = objectArray[0];
        if (object instanceof FXClassType || object instanceof FXObjectValue) {
            if (bl) {
                return this.getClassDelegate((FXClassType)object);
            }
            FXObjectValue fXObjectValue = (FXObjectValue)object;
            return this.getClassDelegate(fXObjectValue.getClassType());
        }
        if (object instanceof FXSequenceValue) {
            if (this.sequenceDelegate == null) {
                this.sequenceDelegate = new FXSequenceDelegate(this.bridge);
            }
            return this.sequenceDelegate;
        }
        if (bl2 && (fXClassType = ((FXObjectValue)(objectValue = this.context.mirrorOf(object))).getClassType()).isJfxType()) {
            objectArray[0] = objectValue;
            return this.getClassDelegate(fXClassType);
        }
        return null;
    }

    private InvocationDelegate getClassDelegate(FXClassType fXClassType) {
        FXClassDelegate fXClassDelegate = this.classDelegates.get(fXClassType);
        if (fXClassDelegate == null) {
            fXClassDelegate = new FXClassDelegate(fXClassType, this.bridge);
            this.classDelegates.put(fXClassType, fXClassDelegate);
        }
        return fXClassDelegate;
    }

    private FXClassType getScriptClass(String string) {
        if (this.scriptClass == null) {
            this.scriptClass = this.context.findClass(string);
        }
        return this.scriptClass;
    }
}

