/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArraySequence
extends ArraySequence<Character> {
    char[] array;

    public CharArraySequence(int n, TypeInfo<Character> typeInfo) {
        super(typeInfo);
        this.array = new char[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public CharArraySequence(int n) {
        this(n, TypeInfo.Character);
    }

    public CharArraySequence() {
        this(16, TypeInfo.Character);
    }

    public CharArraySequence(TypeInfo<Character> typeInfo, char ... cArray) {
        this(typeInfo, cArray, false);
    }

    public CharArraySequence(TypeInfo<Character> typeInfo, char[] cArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = cArray;
        } else {
            this.array = new char[cArray.length];
            System.arraycopy(cArray, 0, this.array, 0, cArray.length);
        }
        this.gapStart = this.gapEnd = cArray.length;
    }

    public CharArraySequence(char[] cArray, int n, int n2) {
        super(TypeInfo.Character);
        this.array = new char[n2];
        System.arraycopy(cArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public CharArraySequence(Sequence<? extends Character> sequence) {
        super(TypeInfo.Character);
        int n = sequence.size();
        this.array = new char[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new char[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (char[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Character getRawArrayElementAsObject(int n) {
        return Character.valueOf(this.array[n]);
    }

    public CharArraySequence makeNew(int n) {
        return new CharArraySequence(n, this.getElementType());
    }

    @Override
    public char getAsChar(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return '\u0000';
        }
        return this.array[n];
    }

    public void add(char c) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = c;
    }

    @Override
    public void add(Sequence<? extends Character> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, char[] cArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, cArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, cArray, n3, n2);
    }

    @Override
    protected CharArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        CharArraySequence charArraySequence = new CharArraySequence(n3, this.getElementType());
        charArraySequence.addFromArray(this.array, 0, n);
        charArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return charArraySequence;
    }

    public void replace(int n, char c) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = c;
    }

    public void replace(int n, int n2, char c, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, c);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = c;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Character> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static char extractOldElement(ArraySequence<Character> arraySequence, Sequence<? extends Character> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3).charValue();
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3).charValue();
            }
        }
        return ((Character)arraySequence.getDefaultValue()).charValue();
    }

    public static char extractNewElement(ArraySequence<Character> arraySequence, int n, Sequence<? extends Character> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2).charValue();
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2).charValue();
        }
        return ((Character)arraySequence.getDefaultValue()).charValue();
    }
}

