/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArraySequence
extends ArraySequence<Float> {
    float[] array;

    public FloatArraySequence(int n, TypeInfo<Float> typeInfo) {
        super(typeInfo);
        this.array = new float[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public FloatArraySequence(int n) {
        this(n, TypeInfo.Float);
    }

    public FloatArraySequence() {
        this(16, TypeInfo.Float);
    }

    public FloatArraySequence(TypeInfo<Float> typeInfo, float ... fArray) {
        this(typeInfo, fArray, false);
    }

    public FloatArraySequence(TypeInfo<Float> typeInfo, float[] fArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = fArray;
        } else {
            this.array = new float[fArray.length];
            System.arraycopy(fArray, 0, this.array, 0, fArray.length);
        }
        this.gapStart = this.gapEnd = fArray.length;
    }

    public FloatArraySequence(float[] fArray, int n, int n2) {
        super(TypeInfo.Float);
        this.array = new float[n2];
        System.arraycopy(fArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public FloatArraySequence(Sequence<? extends Float> sequence) {
        super(TypeInfo.Float);
        int n = sequence.size();
        this.array = new float[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new float[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (float[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Float getRawArrayElementAsObject(int n) {
        return Float.valueOf(this.array[n]);
    }

    public FloatArraySequence makeNew(int n) {
        return new FloatArraySequence(n, this.getElementType());
    }

    @Override
    public float getAsFloat(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return 0.0f;
        }
        return this.array[n];
    }

    public void add(float f) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = f;
    }

    @Override
    public void add(Sequence<? extends Float> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, float[] fArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, fArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, fArray, n3, n2);
    }

    @Override
    protected FloatArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        FloatArraySequence floatArraySequence = new FloatArraySequence(n3, this.getElementType());
        floatArraySequence.addFromArray(this.array, 0, n);
        floatArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return floatArraySequence;
    }

    public void replace(int n, float f) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = f;
    }

    public void replace(int n, int n2, float f, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, f);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = f;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Float> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static float extractOldElement(ArraySequence<Float> arraySequence, Sequence<? extends Float> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3).floatValue();
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3).floatValue();
            }
        }
        return ((Float)arraySequence.getDefaultValue()).floatValue();
    }

    public static float extractNewElement(ArraySequence<Float> arraySequence, int n, Sequence<? extends Float> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2).floatValue();
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2).floatValue();
        }
        return ((Float)arraySequence.getDefaultValue()).floatValue();
    }
}

