/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.NumericTypeInfo;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.BooleanArraySequence;
import com.sun.javafx.runtime.sequence.ByteArraySequence;
import com.sun.javafx.runtime.sequence.CharArraySequence;
import com.sun.javafx.runtime.sequence.DoubleArraySequence;
import com.sun.javafx.runtime.sequence.FloatArraySequence;
import com.sun.javafx.runtime.sequence.IntArraySequence;
import com.sun.javafx.runtime.sequence.IntRangeSequence;
import com.sun.javafx.runtime.sequence.LongArraySequence;
import com.sun.javafx.runtime.sequence.NumberRangeSequence;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequenceProxy;
import com.sun.javafx.runtime.sequence.SequenceRef;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.runtime.sequence.ShortArraySequence;
import com.sun.javafx.runtime.sequence.SingletonSequence;
import com.sun.javafx.runtime.sequence.SubSequence;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencesBase {
    public static final int UNDEFINED_MARKER_INT = -1000;

    public static <T> Sequence<T> fromArray(TypeInfo<T> typeInfo, T[] TArray) {
        if (TArray == null) {
            return typeInfo.emptySequence;
        }
        return new ObjectArraySequence<T>(typeInfo, TArray);
    }

    public static Sequence<Long> fromArray(long[] lArray) {
        if (lArray == null) {
            return TypeInfo.Long.emptySequence;
        }
        return new LongArraySequence(lArray, 0, lArray.length);
    }

    public static Sequence<Integer> fromArray(int[] nArray) {
        if (nArray == null) {
            return TypeInfo.Integer.emptySequence;
        }
        return new IntArraySequence(nArray, 0, nArray.length);
    }

    public static Sequence<Short> fromArray(short[] sArray) {
        if (sArray == null) {
            return TypeInfo.Short.emptySequence;
        }
        return new ShortArraySequence(sArray, 0, sArray.length);
    }

    public static Sequence<Character> fromArray(char[] cArray) {
        if (cArray == null) {
            return TypeInfo.Character.emptySequence;
        }
        return new CharArraySequence(cArray, 0, cArray.length);
    }

    public static Sequence<Byte> fromArray(byte[] byArray) {
        if (byArray == null) {
            return TypeInfo.Byte.emptySequence;
        }
        return new ByteArraySequence(byArray, 0, byArray.length);
    }

    public static Sequence<Double> fromArray(double[] dArray) {
        if (dArray == null) {
            return TypeInfo.Double.emptySequence;
        }
        return new DoubleArraySequence(dArray, 0, dArray.length);
    }

    public static Sequence<Float> fromArray(float[] fArray) {
        if (fArray == null) {
            return TypeInfo.Float.emptySequence;
        }
        return new FloatArraySequence(fArray, 0, fArray.length);
    }

    public static Sequence<Boolean> fromArray(boolean[] blArray) {
        if (blArray == null) {
            return TypeInfo.Boolean.emptySequence;
        }
        return new BooleanArraySequence(blArray, 0, blArray.length);
    }

    public static <T> T[] toArray(Sequence<? extends T> sequence) {
        T[] TArray = Util.newObjectArray(sequence.size());
        int n = 0;
        for (T t : sequence) {
            TArray[n++] = t;
        }
        return TArray;
    }

    public static long[] toLongArray(Sequence<? extends Number> sequence) {
        int n = sequence.size();
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = sequence.getAsLong(n2);
        }
        return lArray;
    }

    public static int[] toIntArray(Sequence<? extends Number> sequence) {
        int n = sequence.size();
        int[] nArray = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            nArray[n2] = sequence.getAsInt(n2);
        }
        return nArray;
    }

    public static short[] toShortArray(Sequence<? extends Number> sequence) {
        int n = sequence.size();
        short[] sArray = new short[n];
        int n2 = n;
        while (--n2 >= 0) {
            sArray[n2] = sequence.getAsShort(n2);
        }
        return sArray;
    }

    public static byte[] toByteArray(Sequence<? extends Number> sequence) {
        int n = sequence.size();
        byte[] byArray = new byte[n];
        int n2 = n;
        while (--n2 >= 0) {
            byArray[n2] = sequence.getAsByte(n2);
        }
        return byArray;
    }

    public static double[] toDoubleArray(Sequence<? extends Number> sequence) {
        int n = sequence.size();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = sequence.getAsDouble(n2);
        }
        return dArray;
    }

    public static float[] toFloatArray(Sequence<? extends Number> sequence) {
        int n = sequence.size();
        float[] fArray = new float[n];
        int n2 = n;
        while (--n2 >= 0) {
            fArray[n2] = sequence.getAsFloat(n2);
        }
        return fArray;
    }

    public static boolean[] toBooleanArray(Sequence<? extends Boolean> sequence) {
        int n = sequence.size();
        boolean[] blArray = new boolean[n];
        int n2 = n;
        while (--n2 >= 0) {
            blArray[n2] = sequence.getAsBoolean(n2);
        }
        return blArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T> ObjectArraySequence<T> forceNonSharedObjectArraySequence(TypeInfo<T> var0, Sequence<? extends T> var1_1) {
        if (!(var1_1 instanceof ObjectArraySequence)) ** GOTO lbl-1000
        var2_2 /* !! */  = (ObjectArraySequence<T>)var1_1;
        if (!var2_2 /* !! */ .isShared()) {
            return var2_2 /* !! */ ;
        }
        if (var2_2 /* !! */ .array.length == 0) {
            var2_2 /* !! */  = new ObjectArraySequence<T>(var0, var2_2 /* !! */ .array, true);
        } else lbl-1000:
        // 2 sources

        {
            var2_2 /* !! */  = new ObjectArraySequence<T>(var0, var1_1);
        }
        var2_2 /* !! */ .incrementSharing();
        return var2_2 /* !! */ ;
    }

    public static <T> ArraySequence<T> forceNonSharedArraySequence(TypeInfo<T> typeInfo, Sequence<? extends T> sequence) {
        ArraySequence<? extends T> arraySequence;
        if (sequence instanceof ArraySequence && !(arraySequence = (ArraySequence<? extends T>)sequence).isShared()) {
            return arraySequence;
        }
        arraySequence = typeInfo.emptySequence.makeNew(0);
        arraySequence.add(sequence);
        arraySequence.incrementSharing();
        return arraySequence;
    }

    public static <T> T incrementSharing(T t) {
        if (t instanceof ArraySequence) {
            ((ArraySequence)t).incrementSharing();
        }
        return t;
    }

    public static <T> Sequence<T> make(TypeInfo<T> typeInfo, T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return typeInfo.emptySequence;
        }
        return new ObjectArraySequence<T>(typeInfo, TArray);
    }

    public static <T> Sequence<T> make(TypeInfo<T> typeInfo, T[] TArray, int n) {
        if (TArray == null || n <= 0) {
            return typeInfo.emptySequence;
        }
        return new ObjectArraySequence<T>(typeInfo, TArray, 0, n);
    }

    public static <T> Sequence<T> makeViaHandoff(TypeInfo<T> typeInfo, T[] TArray) {
        return new ObjectArraySequence<T>(typeInfo, TArray, true);
    }

    public static <T> Sequence<T> make(TypeInfo<T> typeInfo, List<? extends T> list) {
        if (list == null || list.size() == 0) {
            return typeInfo.emptySequence;
        }
        return new ObjectArraySequence<T>(typeInfo, list);
    }

    public static Sequence<Integer> range(int n, int n2) {
        return new IntRangeSequence(n, n2);
    }

    public static Sequence<Integer> range(int n, int n2, int n3) {
        return new IntRangeSequence(n, n2, n3);
    }

    public static Sequence<Integer> rangeExclusive(int n, int n2) {
        return new IntRangeSequence(n, n2, true);
    }

    public static Sequence<Integer> rangeExclusive(int n, int n2, int n3) {
        return new IntRangeSequence(n, n2, n3, true);
    }

    public static Sequence<Float> range(float f, float f2) {
        return new NumberRangeSequence(f, f2, 1.0f);
    }

    public static Sequence<Float> range(float f, float f2, float f3) {
        return new NumberRangeSequence(f, f2, f3);
    }

    public static Sequence<Float> rangeExclusive(float f, float f2) {
        return new NumberRangeSequence(f, f2, 1.0f, true);
    }

    public static Sequence<Float> rangeExclusive(float f, float f2, float f3) {
        return new NumberRangeSequence(f, f2, f3, true);
    }

    public static <T> Sequence<T> filter(Sequence<T> sequence, BitSet bitSet) {
        int n = bitSet.cardinality();
        if (n == 0) {
            return sequence.getEmptySequence();
        }
        if (n == sequence.size() && bitSet.nextClearBit(0) == sequence.size()) {
            return sequence;
        }
        ObjectArraySequence<T> objectArraySequence = new ObjectArraySequence<T>(n, sequence.getElementType());
        int n2 = bitSet.nextSetBit(0);
        boolean bl = false;
        while (n2 >= 0) {
            objectArraySequence.add(sequence.get(n2));
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return objectArraySequence;
    }

    public static <T> Sequence<T> subsequence(Sequence<T> sequence, int n, int n2) {
        if (n >= n2) {
            return sequence.getEmptySequence();
        }
        if (n <= 0 && n2 >= sequence.size()) {
            return sequence;
        }
        n = Math.max(n, 0);
        n2 = Math.min(n2, sequence.size());
        return SubSequence.make(sequence, n2 - n, n, 1);
    }

    public static int calculateIntRangeSize(int n, int n2, int n3, boolean bl) {
        if (n3 == 0) {
            return 0;
        }
        if (Math.abs((long)n - (long)n2) + (long)(bl ? 0 : 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range sequence too big");
        }
        if (n2 == n) {
            return bl ? 0 : 1;
        }
        int n4 = Math.max(0, (n2 - n) / n3 + 1);
        if (bl) {
            boolean bl2;
            boolean bl3 = n3 > 0 ? n + (n4 - 1) * n3 >= n2 : (bl2 = n + (n4 - 1) * n3 <= n2);
            if (bl2 && n4 > 0) {
                --n4;
            }
        }
        return n4;
    }

    public static int calculateFloatRangeSize(float f, float f2, float f3, boolean bl) {
        long l;
        if (f3 == 0.0f) {
            return 0;
        }
        if (f2 == f) {
            return bl ? 0 : 1;
        }
        long l2 = l = f2 < f && f3 > 0.0f || f2 > f && f3 < 0.0f ? 0L : Math.max(0L, (long)((f2 - f) / f3) + 1L);
        if (bl) {
            boolean bl2;
            boolean bl3 = f3 > 0.0f ? f + (float)(l - 1L) * f3 >= f2 : (bl2 = f + (float)(l - 1L) * f3 <= f2);
            if (bl2 && l > 0L) {
                --l;
            }
        }
        if (l > Integer.MAX_VALUE || l < 0L) {
            throw new IllegalArgumentException("Range sequence too big");
        }
        return (int)l;
    }

    public static <T> Sequence<T> singleton(TypeInfo<T> typeInfo, T t) {
        if (t == null) {
            return typeInfo.emptySequence;
        }
        return new SingletonSequence<T>(typeInfo, t);
    }

    public static <T> Sequence<T> emptySequence(Class<T> clazz) {
        return TypeInfo.getTypeInfo(clazz).emptySequence;
    }

    public static <T> Sequence<T> reverse(Sequence<T> sequence) {
        int n = sequence.size();
        return SubSequence.make(sequence, n, n - 1, -1);
    }

    public static <T> Sequence<T> fromCollection(TypeInfo<T> typeInfo, Collection<T> collection) {
        if (collection == null) {
            return typeInfo.emptySequence;
        }
        return new ObjectArraySequence<Object>(typeInfo, collection.toArray());
    }

    public static <T> Sequence<T> upcast(Sequence<? extends T> sequence) {
        return sequence;
    }

    public static Sequence<? extends Object> convertObjectToSequence(Object object) {
        if (object instanceof Sequence) {
            return (Sequence)object;
        }
        return SequencesBase.singleton(TypeInfo.Object, object);
    }

    public static <T extends Number, V extends Number> Sequence<T> convertNumberSequence(NumericTypeInfo<T> numericTypeInfo, NumericTypeInfo<V> numericTypeInfo2, Sequence<? extends V> sequence) {
        if (Sequences.size(sequence) == 0) {
            return numericTypeInfo.emptySequence;
        }
        int n = sequence.size();
        Number[] numberArray = numericTypeInfo.makeArray(n);
        int n2 = 0;
        for (Number number : sequence) {
            numberArray[n2++] = numericTypeInfo.asPreferred(numericTypeInfo2, number);
        }
        return new ObjectArraySequence<Number>((TypeInfo<Number>)numericTypeInfo, (T[])numberArray, 0, n);
    }

    public static <V extends Number> Sequence<Character> convertNumberToCharSequence(NumericTypeInfo<V> numericTypeInfo, Sequence<? extends V> sequence) {
        if (Sequences.size(sequence) == 0) {
            return TypeInfo.Character.emptySequence;
        }
        int n = sequence.size();
        Character[] characterArray = new Character[n];
        int n2 = 0;
        for (Number number : sequence) {
            characterArray[n2++] = Character.valueOf((char)number.intValue());
        }
        return new ObjectArraySequence<Character>(TypeInfo.Character, (T[])characterArray, 0, n);
    }

    public static <V extends Number> Sequence<V> convertCharToNumberSequence(NumericTypeInfo<V> numericTypeInfo, Sequence<? extends Character> sequence) {
        if (Sequences.size(sequence) == 0) {
            return numericTypeInfo.emptySequence;
        }
        int n = sequence.size();
        Number[] numberArray = numericTypeInfo.makeArray(n);
        int n2 = 0;
        for (Character c : sequence) {
            numberArray[n2++] = numericTypeInfo.asPreferred(TypeInfo.Integer, Integer.valueOf(c.charValue()));
        }
        return new ObjectArraySequence<Number>((TypeInfo<Number>)numericTypeInfo, (T[])numberArray, 0, n);
    }

    public static int size(Object object) {
        if (object instanceof Sequence) {
            return ((Sequence)object).size();
        }
        return object == null ? 0 : 1;
    }

    public static int size(Sequence sequence) {
        return sequence == null ? 0 : sequence.size();
    }

    public static <T> Iterator<T> iterator(Sequence<T> sequence) {
        return sequence == null ? TypeInfo.Object.emptySequence.iterator() : sequence.iterator();
    }

    public static <T> Iterator<T> iterator(Sequence<T> sequence, int n, int n2) {
        return sequence == null ? TypeInfo.Object.emptySequence.iterator() : sequence.iterator(n, n2);
    }

    public static <T> boolean isEqual(Sequence<?> sequence, Sequence<?> sequence2) {
        int n = SequencesBase.size(sequence);
        int n2 = SequencesBase.size(sequence2);
        if (n == 0) {
            return n2 == 0;
        }
        if (n != n2) {
            return false;
        }
        Iterator<?> iterator = sequence.iterator();
        Iterator<?> iterator2 = sequence2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEqualByContentIdentity(Sequence<? extends T> sequence, Sequence<? extends T> sequence2) {
        int n = SequencesBase.size(sequence);
        if (n == 0) {
            return SequencesBase.size(sequence2) == 0;
        }
        if (n != SequencesBase.size(sequence2)) {
            return false;
        }
        Iterator<T> iterator = sequence.iterator();
        Iterator<T> iterator2 = sequence2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean sliceEqual(Sequence<? extends T> sequence, int n, int n2, Sequence<? extends T> sequence2) {
        int n3 = SequencesBase.size(sequence2);
        if (n2 - n != n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (sequence.get(n + i).equals(sequence2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> Sequence<? extends T> forceNonNull(TypeInfo<T> typeInfo, Sequence<? extends T> sequence) {
        return sequence == null ? typeInfo.emptySequence : sequence;
    }

    public static <T> T getSingleValue(Sequence<T> sequence) {
        if (sequence == null || sequence.size() != 1) {
            return null;
        }
        return sequence.get(0);
    }

    public static <T extends Comparable> int binarySearch(Sequence<? extends T> sequence, T t) {
        if (sequence.isEmpty()) {
            return -1;
        }
        int n = sequence.size();
        Object[] objectArray = Util.newComparableArray((int)n);
        sequence.toArray(0, n, objectArray, 0);
        return Arrays.binarySearch(objectArray, t);
    }

    public static <T> int binarySearch(Sequence<? extends T> sequence, T t, Comparator<? super T> comparator) {
        if (sequence.isEmpty()) {
            return -1;
        }
        int n = sequence.size();
        Object[] objectArray = Util.newObjectArray(n);
        sequence.toArray(0, n, objectArray, 0);
        return Arrays.binarySearch(objectArray, t, comparator);
    }

    public static <T> int indexByIdentity(Sequence<? extends T> sequence, T t) {
        return SequencesBase.nextIndexByIdentity(sequence, t, 0);
    }

    public static <T> int indexOf(Sequence<? extends T> sequence, T t) {
        return SequencesBase.nextIndexOf(sequence, t, 0);
    }

    public static <T extends Comparable> T max(Sequence<T> sequence) {
        if (sequence == null || sequence.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.max");
        }
        Comparable comparable = (Comparable)sequence.get(0);
        for (Comparable comparable2 : sequence) {
            if (comparable.compareTo(comparable2) >= 0) continue;
            comparable = comparable2;
        }
        return (T)comparable;
    }

    public static <T> T max(Sequence<T> sequence, Comparator<? super T> comparator) {
        if (sequence == null || sequence.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.max");
        }
        if (comparator == null) {
            return SequencesBase.max(sequence);
        }
        T t = sequence.get(0);
        for (T t2 : sequence) {
            if (comparator.compare(t, t2) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T extends Comparable> T min(Sequence<T> sequence) {
        if (sequence == null || sequence.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.min");
        }
        Comparable comparable = (Comparable)sequence.get(0);
        for (Comparable comparable2 : sequence) {
            if (comparable.compareTo(comparable2) <= 0) continue;
            comparable = comparable2;
        }
        return (T)comparable;
    }

    public static <T> T min(Sequence<T> sequence, Comparator<? super T> comparator) {
        if (sequence == null || sequence.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.min");
        }
        if (comparator == null) {
            return SequencesBase.min(sequence);
        }
        T t = sequence.get(0);
        for (T t2 : sequence) {
            if (comparator.compare(t, t2) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> int nextIndexByIdentity(Sequence<? extends T> sequence, T t, int n) {
        int n2;
        if (sequence == null) {
            return -1;
        }
        if (t == null) {
            throw new NullPointerException();
        }
        Iterator<T> iterator = sequence.iterator();
        for (n2 = 0; n2 < n && iterator.hasNext(); ++n2) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            if (iterator.next() == t) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static <T> int nextIndexOf(Sequence<? extends T> sequence, T t, int n) {
        int n2;
        if (sequence == null) {
            return -1;
        }
        if (t == null) {
            throw new NullPointerException();
        }
        Iterator<T> iterator = sequence.iterator();
        for (n2 = 0; n2 < n && iterator.hasNext(); ++n2) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            if (iterator.next().equals(t)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static <T extends Comparable> Sequence<? extends T> sort(Sequence<T> sequence) {
        if (sequence.isEmpty()) {
            return sequence.getEmptySequence();
        }
        int n = sequence.size();
        Object[] objectArray = Util.newComparableArray((int)n);
        sequence.toArray(0, n, objectArray, 0);
        Arrays.sort(objectArray);
        return Sequences.make(sequence.getElementType(), objectArray);
    }

    public static <T> Sequence<? extends T> sort(Sequence<T> sequence, Comparator<? super T> comparator) {
        if (sequence.isEmpty()) {
            return sequence.getEmptySequence();
        }
        int n = sequence.size();
        Object[] objectArray = Util.newObjectArray(n);
        sequence.toArray(0, n, objectArray, 0);
        Arrays.sort(objectArray, comparator);
        return Sequences.make(sequence.getElementType(), objectArray);
    }

    public static <T> Sequence<T> shuffle(Sequence<T> sequence) {
        T[] TArray = SequencesBase.toArray(sequence);
        List<T> list = Arrays.asList(TArray);
        Collections.shuffle(list);
        return Sequences.make(sequence.getElementType(), list);
    }

    public static <T> T getFromNewElements(FXObject fXObject, int n, int n2, int n3, int n4) {
        if (n4 >= n3) {
            n4 = -1;
        } else if (n4 >= 0) {
            n4 += n2;
        }
        return (T)fXObject.elem$(n, n4);
    }

    public static <T> Sequence<? extends T> getNewElements(Sequence<? extends T> sequence, int n, int n2) {
        return Sequences.subsequence(sequence, n, n + n2);
    }

    public static <T> Sequence<? extends T> replaceSlice(Sequence<? extends T> sequence, T t, int n, int n2) {
        if (SequencesBase.preReplaceSlice(sequence, t, n, n2)) {
            return SequencesBase.replaceSliceInternal(sequence, t, n, n2, false);
        }
        return sequence;
    }

    private static <T> boolean preReplaceSlice(Sequence<? extends T> sequence, T t, int n, int n2) {
        if (t == null) {
            return SequencesBase.preReplaceSlice(sequence, (Sequence)null, n, n2);
        }
        int n3 = sequence.size();
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        } else if (n2 < n) {
            n2 = n;
        }
        return n2 != n + 1 || !t.equals(sequence.get(n));
    }

    private static <T> Sequence<? extends T> replaceSliceInternal(Sequence<? extends T> sequence, T t, int n, int n2, boolean bl) {
        if (t == null) {
            return SequencesBase.replaceSliceInternal(sequence, (Sequence)null, n, n2, bl);
        }
        int n3 = sequence.size();
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        } else if (n2 < n) {
            n2 = n;
        }
        ObjectArraySequence<T> objectArraySequence = SequencesBase.forceNonSharedObjectArraySequence(sequence.getElementType(), sequence);
        objectArraySequence.replace(n, n2, t, bl);
        if (bl) {
            objectArraySequence.clearOldValues(n2 - n);
        }
        return objectArraySequence;
    }

    public static <T> void replaceSlice(FXObject fXObject, int n, T t, int n2, int n3) {
        boolean bl = fXObject.varTestBits$(n, 16, 0);
        fXObject.varChangeBits$(n, 24, 24);
        if (fXObject.varTestBits$(n, 768, 768)) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence sequence = (Sequence)fXObject.get$(n);
        while (sequence instanceof SequenceProxy) {
            SequenceProxy sequenceProxy = (SequenceProxy)sequence;
            fXObject = sequenceProxy.instance();
            n = sequenceProxy.varNum();
            fXObject.varChangeBits$(n, 24, 24);
            sequence = (Sequence)fXObject.get$(n);
        }
        if (SequencesBase.preReplaceSlice(sequence, t, n2, n3) || bl) {
            int n4 = t == null ? 0 : 1;
            fXObject.invalidate$(n, n2, n3, n4, 65);
            Sequence<T> sequence2 = SequencesBase.replaceSliceInternal(sequence, t, n2, n3, true);
            fXObject.seq$(n, sequence2);
            fXObject.invalidate$(n, n2, n3, n4, 92);
        }
    }

    public static <T> Sequence<? extends T> replaceSlice(Sequence<? extends T> sequence, Sequence<? extends T> sequence2, int n, int n2) {
        int n3;
        int n4 = sequence.size();
        if (n < 0) {
            n = 0;
        } else if (n > n4) {
            n = n4;
        }
        if (n2 > n4) {
            n2 = n4;
        } else if (n2 < n) {
            n2 = n;
        }
        int n5 = n3 = sequence2 == null ? 0 : sequence2.size();
        if (n == 0 && n2 == n4 && !(sequence2 instanceof SequenceRef) && !(sequence2 instanceof SequenceProxy)) {
            if (sequence2 == null) {
                sequence2 = sequence.getEmptySequence();
            }
            sequence2.incrementSharing();
            return sequence2;
        }
        ArraySequence<T> arraySequence = SequencesBase.forceNonSharedArraySequence(sequence.getElementType(), sequence);
        arraySequence.replace(n, n2, sequence2, 0, n3, false);
        return arraySequence;
    }

    private static <T> boolean preReplaceSlice(Sequence<? extends T> sequence, Sequence<? extends T> sequence2, int n, int n2) {
        int n3 = sequence.size();
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        } else if (n2 < n) {
            n2 = n;
        }
        return !(sequence2 == null ? n == n2 : SequencesBase.sliceEqual(sequence, n, n2, sequence2));
    }

    private static <T> Sequence<? extends T> replaceSliceInternal(Sequence<? extends T> sequence, Sequence<? extends T> sequence2, int n, int n2, boolean bl) {
        int n3;
        int n4 = sequence.size();
        if (n < 0) {
            n = 0;
        } else if (n > n4) {
            n = n4;
        }
        if (n2 > n4) {
            n2 = n4;
        } else if (n2 < n) {
            n2 = n;
        }
        int n5 = n3 = sequence2 == null ? 0 : sequence2.size();
        if (n == 0 && n2 == n4 && !(sequence2 instanceof SequenceRef) && !(sequence2 instanceof SequenceProxy)) {
            if (sequence2 == null) {
                sequence2 = sequence.getEmptySequence();
            }
            sequence2.incrementSharing();
            return sequence2;
        }
        ArraySequence<T> arraySequence = SequencesBase.forceNonSharedArraySequence(sequence.getElementType(), sequence);
        arraySequence.replace(n, n2, sequence2, 0, n3, bl);
        if (bl) {
            arraySequence.clearOldValues(n2 - n);
        }
        return arraySequence;
    }

    public static <T> void replaceSlice(FXObject fXObject, int n, Sequence<? extends T> sequence, int n2, int n3) {
        boolean bl = fXObject.varTestBits$(n, 16, 0);
        fXObject.varChangeBits$(n, 24, 24);
        if (fXObject.varTestBits$(n, 768, 768)) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence sequence2 = (Sequence)fXObject.get$(n);
        while (sequence2 instanceof SequenceProxy) {
            SequenceProxy sequenceProxy = (SequenceProxy)sequence2;
            fXObject = sequenceProxy.instance();
            n = sequenceProxy.varNum();
            fXObject.varChangeBits$(n, 24, 24);
            sequence2 = (Sequence)fXObject.get$(n);
        }
        if (SequencesBase.preReplaceSlice(sequence2, sequence, n2, n3) || bl) {
            int n4 = sequence == null ? 0 : sequence.size();
            fXObject.invalidate$(n, n2, n3, n4, 65);
            Sequence<? extends T> sequence3 = SequencesBase.replaceSliceInternal(sequence2, sequence, n2, n3, true);
            fXObject.seq$(n, sequence3);
            fXObject.invalidate$(n, n2, n3, n4, 92);
        }
    }

    public static <T> Sequence<? extends T> set(Sequence<? extends T> sequence, Sequence<? extends T> sequence2) {
        if (sequence2 instanceof SequenceRef || sequence2 instanceof SequenceProxy) {
            return SequencesBase.replaceSlice(sequence, sequence2, 0, sequence.size());
        }
        sequence2.incrementSharing();
        return sequence2;
    }

    public static <T> Sequence<? extends T> set(FXObject fXObject, int n, Sequence<? extends T> sequence) {
        SequencesBase.replaceSlice(fXObject, n, sequence, 0, fXObject.size$(n));
        return sequence;
    }

    public static <T> Sequence<? extends T> set(Sequence<? extends T> sequence, T t, int n) {
        return SequencesBase.replaceSlice(sequence, t, n, n + 1);
    }

    public static <T> T set(FXObject fXObject, int n, T t, int n2) {
        SequencesBase.replaceSlice(fXObject, n, t, n2, n2 + 1);
        return t;
    }

    public static <T> ArraySequence<? extends T> copy(Sequence<? extends T> sequence) {
        ArraySequence<T> arraySequence = sequence.getElementType().emptySequence.makeNew(0);
        arraySequence.add(sequence);
        arraySequence.incrementSharing();
        return arraySequence;
    }

    public static <T> Sequence<? extends T> insert(Sequence<? extends T> sequence, T t) {
        if (t == null) {
            return sequence;
        }
        int n = sequence.size();
        ObjectArraySequence<T> objectArraySequence = SequencesBase.forceNonSharedObjectArraySequence(sequence.getElementType(), sequence);
        objectArraySequence.replace(n, n, t, true);
        return objectArraySequence;
    }

    public static <T> void insert(FXObject fXObject, int n, T t) {
        if (t == null) {
            return;
        }
        fXObject.varChangeBits$(n, 24, 24);
        Sequence sequence = (Sequence)fXObject.get$(n);
        while (sequence instanceof SequenceProxy) {
            SequenceProxy sequenceProxy = (SequenceProxy)sequence;
            fXObject = sequenceProxy.instance();
            n = sequenceProxy.varNum();
            fXObject.varChangeBits$(n, 24, 24);
            sequence = (Sequence)fXObject.get$(n);
        }
        int n2 = sequence.size();
        int n3 = t == null ? 0 : 1;
        Sequence<T> sequence2 = SequencesBase.insert(sequence, t);
        fXObject.invalidate$(n, n2, n2, n3, 65);
        fXObject.seq$(n, sequence2);
        fXObject.invalidate$(n, n2, n2, n3, 92);
    }

    public static <T> Sequence<? extends T> insert(Sequence<? extends T> sequence, Sequence<? extends T> sequence2) {
        int n = sequence2.size();
        if (n == 0) {
            return sequence;
        }
        int n2 = sequence.size();
        ArraySequence<T> arraySequence = SequencesBase.forceNonSharedArraySequence(sequence.getElementType(), sequence);
        arraySequence.replace(n2, n2, sequence2, 0, n, true);
        return arraySequence;
    }

    public static <T> void insert(FXObject fXObject, int n, Sequence<? extends T> sequence) {
        int n2 = sequence.size();
        if (n2 == 0) {
            return;
        }
        fXObject.varChangeBits$(n, 24, 24);
        Sequence sequence2 = (Sequence)fXObject.get$(n);
        while (sequence2 instanceof SequenceProxy) {
            SequenceProxy sequenceProxy = (SequenceProxy)sequence2;
            fXObject = sequenceProxy.instance();
            n = sequenceProxy.varNum();
            fXObject.varChangeBits$(n, 24, 24);
            sequence2 = (Sequence)fXObject.get$(n);
        }
        int n3 = sequence2.size();
        int n4 = sequence == null ? 0 : sequence.size();
        Sequence<? extends T> sequence3 = SequencesBase.insert(sequence2, sequence);
        fXObject.invalidate$(n, n3, n3, n4, 65);
        fXObject.seq$(n, sequence3);
        fXObject.invalidate$(n, n3, n3, n4, 92);
    }

    public static <T> void insertBefore(FXObject fXObject, int n, T t, int n2) {
        SequencesBase.replaceSlice(fXObject, n, t, n2, n2);
    }

    public static <T> void insertBefore(FXObject fXObject, int n, Sequence<? extends T> sequence, int n2) {
        SequencesBase.replaceSlice(fXObject, n, sequence, n2, n2);
    }

    public static <T> Sequence<? extends T> insertBefore(Sequence<? extends T> sequence, T t, int n) {
        return SequencesBase.replaceSlice(sequence, t, n, n);
    }

    public static <T> Sequence<? extends T> insertBefore(Sequence<? extends T> sequence, Sequence<? extends T> sequence2, int n) {
        return SequencesBase.replaceSlice(sequence, sequence2, n, n);
    }

    public static <T> void deleteIndexed(FXObject fXObject, int n, int n2) {
        SequencesBase.replaceSlice(fXObject, n, (Sequence)null, n2, n2 + 1);
    }

    public static <T> Sequence<? extends T> deleteIndexed(Sequence<? extends T> sequence, int n) {
        return SequencesBase.replaceSlice(sequence, (Sequence)null, n, n + 1);
    }

    public static <T> void deleteSlice(FXObject fXObject, int n, int n2, int n3) {
        SequencesBase.replaceSlice(fXObject, n, (Sequence)null, n2, n3);
    }

    public static <T> Sequence<? extends T> deleteSlice(Sequence<? extends T> sequence, int n, int n2) {
        return SequencesBase.replaceSlice(sequence, (Sequence)null, n, n2);
    }

    public static <T> void deleteValue(FXObject fXObject, int n, T t) {
        if (fXObject.varTestBits$(n, 768, 768)) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence sequence = (Sequence)fXObject.get$(n);
        while (sequence instanceof SequenceProxy) {
            SequenceProxy sequenceProxy = (SequenceProxy)sequence;
            fXObject = sequenceProxy.instance();
            n = sequenceProxy.varNum();
            sequence = (Sequence)fXObject.get$(n);
        }
        int n2 = -1;
        int n3 = sequence.size();
        do {
            boolean bl;
            boolean bl2 = bl = --n3 < 0 ? false : sequence.get(n3).equals(t);
            if (bl) {
                if (n2 >= 0) continue;
                n2 = n3;
                continue;
            }
            if (n2 < 0) continue;
            SequencesBase.deleteSlice(fXObject, n, n3 + 1, n2 + 1);
            sequence = (Sequence)fXObject.get$(n);
            n2 = -1;
        } while (n3 >= 0);
    }

    public static <T> Sequence<? extends T> deleteValue(Sequence<? extends T> sequence, T t) {
        int n = -1;
        int n2 = sequence.size();
        do {
            boolean bl;
            boolean bl2 = bl = --n2 < 0 ? false : sequence.get(n2).equals(t);
            if (bl) {
                if (n >= 0) continue;
                n = n2;
                continue;
            }
            if (n < 0) continue;
            sequence = SequencesBase.deleteSlice(sequence, n2 + 1, n + 1);
            n = -1;
        } while (n2 >= 0);
        return sequence;
    }

    public static <T> Sequence<? extends T> deleteAll(Sequence<? extends T> sequence) {
        return sequence.getEmptySequence();
    }

    public static <T> void deleteAll(FXObject fXObject, int n) {
        int n2 = fXObject.size$(n);
        SequencesBase.replaceSlice(fXObject, n, (Sequence)null, 0, n2);
    }

    public static boolean withinBounds(FXObject fXObject, int n, int n2) {
        return n2 >= 0 && n2 < fXObject.size$(n);
    }
}

