/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubSequence<T>
extends AbstractSequence<T> {
    protected final Sequence<? extends T> sequence;
    protected final int size;
    private final int startPos;
    private final int step;

    public SubSequence(Sequence<T> sequence, int n, int n2) {
        this(sequence, n2 - n, n, 1);
    }

    private SubSequence(Sequence<T> sequence, int n, int n2, int n3) {
        super(sequence.getElementType());
        this.startPos = n2;
        this.step = n3;
        this.sequence = sequence;
        this.size = n;
    }

    static <T> Sequence make(Sequence<T> sequence, int n, int n2, int n3) {
        if (n <= 0) {
            return sequence.getElementType().emptySequence;
        }
        if (sequence instanceof SubSequence) {
            SubSequence subSequence = (SubSequence)sequence;
            n2 = subSequence.startPos + subSequence.step * n2;
            n3 = subSequence.step * n3;
            sequence = subSequence.sequence;
        }
        sequence.incrementSharing();
        return new SubSequence<T>(sequence, n, n2, n3);
    }

    @Override
    public T get(int n) {
        if (n < 0 || n >= this.size) {
            return this.getDefaultValue();
        }
        return this.sequence.get(this.startPos + this.step * n);
    }

    @Override
    public boolean getAsBoolean(int n) {
        if (n < 0 || n >= this.size) {
            return false;
        }
        return this.sequence.getAsBoolean(this.startPos + this.step * n);
    }

    @Override
    public char getAsChar(int n) {
        if (n < 0 || n >= this.size) {
            return '\u0000';
        }
        return this.sequence.getAsChar(this.startPos + this.step * n);
    }

    @Override
    public byte getAsByte(int n) {
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.sequence.getAsByte(this.startPos + this.step * n);
    }

    @Override
    public short getAsShort(int n) {
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.sequence.getAsShort(this.startPos + this.step * n);
    }

    @Override
    public int getAsInt(int n) {
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.sequence.getAsInt(this.startPos + this.step * n);
    }

    @Override
    public long getAsLong(int n) {
        if (n < 0 || n >= this.size) {
            return 0L;
        }
        return this.sequence.getAsLong(this.startPos + this.step * n);
    }

    @Override
    public float getAsFloat(int n) {
        if (n < 0 || n >= this.size) {
            return 0.0f;
        }
        return this.sequence.getAsFloat(this.startPos + this.step * n);
    }

    @Override
    public double getAsDouble(int n) {
        if (n < 0 || n >= this.size) {
            return 0.0;
        }
        return this.sequence.getAsDouble(this.startPos + this.step * n);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void toArray(int n, int n2, Object[] objectArray, int n3) {
        if (n < 0 || n2 > 0 && n + n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.step == 1) {
            this.sequence.toArray(this.startPos + n, n2, objectArray, n3);
        } else {
            int n4 = this.startPos + this.step * n;
            int n5 = 0;
            while (n5 < n2) {
                objectArray[n5 + n3] = this.sequence.get(n4);
                ++n5;
                n4 += this.step;
            }
        }
    }
}

