/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.PGNode;

public abstract class BaseNode
implements PGNode {
    protected static final float[] TMP_ARR = new float[8];
    protected static final Bounds2D TEMP_BOUNDS = new Bounds2D();
    protected BaseTransform tx = BaseTransform.IDENTITY_TRANSFORM;
    protected final Bounds2D cachedTxBounds = new Bounds2D();
    protected final Bounds2D cachedBounds = new Bounds2D();
    protected final Bounds2D lastTxBounds = new Bounds2D();
    protected boolean visible = true;
    protected boolean dirty = true;
    protected boolean boundsChanged = true;

    protected BaseNode() {
    }

    public final Point2D parentToLocal(Point2D point2D) {
        if (this.tx.isIdentity()) {
            return point2D;
        }
        try {
            this.tx.inverseTransform(point2D, point2D);
            return point2D;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return point2D;
        }
    }

    protected abstract void invalidateCache();

    protected abstract void markParentsDirty();

    public boolean isClean() {
        return !this.dirty;
    }

    protected void clearDirty() {
        this.dirty = false;
        this.lastTxBounds.invalidate();
    }

    protected final void updateTxBounds() {
        if (this.cachedTxBounds.isInvalid()) {
            this.getClippedBounds(this.cachedTxBounds, this.tx);
        }
    }

    public final void completeBoundsChanged(boolean bl) {
        if (!this.visible) {
            this.cachedTxBounds.invalidate();
        } else {
            if (!this.cachedTxBounds.isInvalid()) {
                if (this.lastTxBounds.isInvalid()) {
                    this.lastTxBounds.setBounds(this.cachedTxBounds);
                } else {
                    this.lastTxBounds.unionWith(this.cachedTxBounds);
                }
            }
            this.cachedTxBounds.invalidate();
            this.boundsChanged = true;
            if (bl) {
                this.dirty = true;
            }
            this.markParentsDirty();
        }
    }

    protected final void contentBoundsChanged(boolean bl) {
        this.invalidateCache();
        this.cachedBounds.invalidate();
        this.completeBoundsChanged(bl);
    }

    public Bounds2D accumulateDirtyRegions(Bounds2D bounds2D, Bounds2D bounds2D2, BaseTransform baseTransform) {
        if (!this.visible && this.isClean()) {
            return bounds2D2;
        }
        if (this.isClean()) {
            return bounds2D2;
        }
        float f = bounds2D2.x1;
        float f2 = bounds2D2.y1;
        float f3 = bounds2D2.x2;
        float f4 = bounds2D2.y2;
        if ((bounds2D2 = this.computeDirtyRegion(bounds2D, bounds2D2, baseTransform)) == null) {
            return null;
        }
        if (bounds2D2.isEmpty() || bounds2D.disjoint(bounds2D2)) {
            bounds2D2.setBounds(f, f2, f3, f4);
            return bounds2D2;
        }
        if (f != 0.0f || f2 != 0.0f || f3 != 0.0f || f4 != 0.0f) {
            bounds2D2.unionWith(f, f2, f3, f4);
        }
        if (bounds2D2.x1 <= bounds2D.x1 && bounds2D2.y1 <= bounds2D.y1 && bounds2D2.x2 >= bounds2D.x2 && bounds2D2.y2 >= bounds2D.y2) {
            return null;
        }
        bounds2D2.x1 = Math.max(bounds2D2.x1, bounds2D.x1);
        bounds2D2.y1 = Math.max(bounds2D2.y1, bounds2D.y1);
        bounds2D2.x2 = Math.min(bounds2D2.x2, bounds2D.x2);
        bounds2D2.y2 = Math.min(bounds2D2.y2, bounds2D.y2);
        return bounds2D2;
    }

    protected Bounds2D computeDirtyRegion(Bounds2D bounds2D, Bounds2D bounds2D2, BaseTransform baseTransform) {
        this.updateTxBounds();
        if (!this.lastTxBounds.isInvalid()) {
            bounds2D2.setBounds(this.lastTxBounds);
            bounds2D2.unionWith(this.cachedTxBounds);
        } else {
            bounds2D2.setBounds(this.cachedTxBounds);
        }
        bounds2D2.x1 -= 1.0f;
        bounds2D2.y1 -= 1.0f;
        bounds2D2.x2 += 1.0f;
        bounds2D2.y2 += 1.0f;
        BaseNode.transform(bounds2D2, baseTransform);
        return bounds2D2;
    }

    public static void transform(float[] fArray, BaseTransform baseTransform) {
        if (!baseTransform.isIdentity()) {
            if (fArray != TMP_ARR) {
                BaseNode.TMP_ARR[0] = fArray[0];
                BaseNode.TMP_ARR[1] = fArray[1];
                BaseNode.TMP_ARR[2] = fArray[2];
                BaseNode.TMP_ARR[3] = fArray[3];
            }
            baseTransform.transform(TMP_ARR, 0, TMP_ARR, 0, 2);
            if (fArray != TMP_ARR) {
                fArray[0] = TMP_ARR[0];
                fArray[1] = TMP_ARR[1];
                fArray[2] = TMP_ARR[2];
                fArray[3] = TMP_ARR[3];
            }
        }
    }

    public static void transform(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (baseTransform != null && !baseTransform.isIdentity()) {
            BaseNode.TMP_ARR[0] = bounds2D.x1;
            BaseNode.TMP_ARR[1] = bounds2D.y1;
            BaseNode.TMP_ARR[2] = bounds2D.x2;
            BaseNode.TMP_ARR[3] = bounds2D.y1;
            BaseNode.TMP_ARR[4] = bounds2D.x2;
            BaseNode.TMP_ARR[5] = bounds2D.y2;
            BaseNode.TMP_ARR[6] = bounds2D.x1;
            BaseNode.TMP_ARR[7] = bounds2D.y2;
            baseTransform.transform(TMP_ARR, 0, TMP_ARR, 0, 4);
            float f = Math.min(Math.min(TMP_ARR[0], TMP_ARR[2]), Math.min(TMP_ARR[4], TMP_ARR[6]));
            float f2 = Math.max(Math.max(TMP_ARR[0], TMP_ARR[2]), Math.max(TMP_ARR[4], TMP_ARR[6]));
            float f3 = Math.min(Math.min(TMP_ARR[1], TMP_ARR[3]), Math.min(TMP_ARR[5], TMP_ARR[7]));
            float f4 = Math.max(Math.max(TMP_ARR[1], TMP_ARR[3]), Math.max(TMP_ARR[5], TMP_ARR[7]));
            bounds2D.setBounds(f, f3, f2, f4);
        }
    }
}

