/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGNode;
import java.util.List;

public class GroupBoundsHelper {
    static float[] TMP_ARR = new float[4];
    List<PGNode> content;
    Bounds2D tmp = new Bounds2D();
    Bounds2D cachedBounds = new Bounds2D();
    boolean boundsInvalid = true;
    PGNode top;
    PGNode left;
    PGNode bottom;
    PGNode right;

    public GroupBoundsHelper(PGGroup pGGroup) {
        this.content = pGGroup.getContent();
    }

    public boolean isBoundsDirty() {
        return this.boundsInvalid;
    }

    public void invalidate() {
        this.boundsInvalid = true;
    }

    public Bounds2D getContentBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            if (this.boundsInvalid) {
                this.recomputeBounds();
            }
            if (baseTransform != null && !baseTransform.isIdentity()) {
                bounds2D.setBounds((float)((double)this.cachedBounds.x1 + baseTransform.getMxt()), (float)((double)this.cachedBounds.y1 + baseTransform.getMyt()), (float)((double)this.cachedBounds.x2 + baseTransform.getMxt()), (float)((double)this.cachedBounds.y2 + baseTransform.getMyt()));
            } else {
                bounds2D.setBounds(this.cachedBounds);
            }
            return bounds2D;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = true;
        for (int i = 0; i < this.content.size(); ++i) {
            PGNode pGNode = this.content.get(i);
            if (!pGNode.isVisible()) continue;
            pGNode.getCompleteBounds(bounds2D, baseTransform);
            if (bl) {
                f = bounds2D.x1;
                f2 = bounds2D.y1;
                f3 = bounds2D.x2;
                f4 = bounds2D.y2;
                bl = false;
                continue;
            }
            f = Math.min(bounds2D.x1, f);
            f2 = Math.min(bounds2D.y1, f2);
            f3 = Math.max(bounds2D.x2, f3);
            f4 = Math.max(bounds2D.y2, f4);
        }
        bounds2D.setBounds(f, f2, f3, f4);
        return bounds2D;
    }

    public boolean childAdded(PGNode pGNode) {
        if (this.cachedBounds.isInvalid()) {
            return true;
        }
        if (this.top == null || this.bottom == null || this.left == null || this.right == null) {
            this.cachedBounds.invalidate();
            this.invalidate();
            return true;
        }
        boolean bl = false;
        if (pGNode.isVisible()) {
            pGNode.getCompleteBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (!this.tmp.isEmpty()) {
                pGNode.setBoundsHaveChanged(false);
                float f = this.tmp.x1;
                float f2 = this.tmp.y1;
                float f3 = this.tmp.x2;
                float f4 = this.tmp.y2;
                float f5 = this.cachedBounds.x1;
                float f6 = this.cachedBounds.y1;
                float f7 = this.cachedBounds.x2;
                float f8 = this.cachedBounds.y2;
                float f9 = Math.min(f, f5);
                float f10 = Math.min(f2, f6);
                float f11 = Math.max(f3, f7);
                float f12 = Math.max(f4, f8);
                if (f2 < f6) {
                    bl = true;
                    this.top = pGNode;
                }
                if (f < f5) {
                    bl = true;
                    this.left = pGNode;
                }
                if (f4 > f8) {
                    bl = true;
                    this.bottom = pGNode;
                }
                if (f3 > f7) {
                    bl = true;
                    this.right = pGNode;
                }
                this.cachedBounds.setBounds(f9, f10, f11, f12);
            }
        }
        return bl;
    }

    public boolean childRemoved(PGNode pGNode) {
        if (this.cachedBounds.isInvalid()) {
            return true;
        }
        if (pGNode == this.top) {
            this.top = null;
        }
        if (pGNode == this.left) {
            this.left = null;
        }
        if (pGNode == this.bottom) {
            this.bottom = null;
        }
        if (pGNode == this.right) {
            this.right = null;
        }
        if (this.top == null || this.bottom == null || this.left == null || this.right == null) {
            this.cachedBounds.invalidate();
            this.invalidate();
            return true;
        }
        return false;
    }

    void recomputeBounds() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        if (!this.cachedBounds.isInvalid() && this.top != null && this.left != null && this.bottom != null && this.right != null && this.top.isVisible() && this.left.isVisible() && this.bottom.isVisible() && this.right.isVisible()) {
            boolean bl = false;
            f5 = this.cachedBounds.x1;
            f4 = this.cachedBounds.y1;
            f3 = this.cachedBounds.x2;
            float f6 = this.cachedBounds.y2;
            float f7 = f5;
            float f8 = f4;
            f2 = f3;
            f = f6;
            for (int i = 0; i < this.content.size(); ++i) {
                PGNode pGNode = this.content.get(i);
                if (pGNode.isVisible() && pGNode.getBoundsHaveChanged()) {
                    pGNode.getCompleteBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                    if (this.tmp.isEmpty()) {
                        if (pGNode == this.top) {
                            bl = true;
                            break;
                        }
                        if (pGNode == this.left) {
                            bl = true;
                            break;
                        }
                        if (pGNode == this.bottom) {
                            bl = true;
                            break;
                        }
                        if (pGNode == this.right) {
                            bl = true;
                            break;
                        }
                    } else {
                        float f9 = this.tmp.x1;
                        float f10 = this.tmp.y1;
                        float f11 = this.tmp.x2;
                        float f12 = this.tmp.y2;
                        if (pGNode == this.top && f10 > f4) {
                            bl = true;
                            break;
                        }
                        if (pGNode == this.left && f9 > f5) {
                            bl = true;
                            break;
                        }
                        if (pGNode == this.bottom && f12 < f6) {
                            bl = true;
                            break;
                        }
                        if (pGNode == this.right && f11 < f3) {
                            bl = true;
                            break;
                        }
                        if (f10 < f8) {
                            f8 = f10;
                            this.top = pGNode;
                        }
                        if (f9 < f7) {
                            f7 = f9;
                            this.left = pGNode;
                        }
                        if (f12 > f) {
                            f = f12;
                            this.bottom = pGNode;
                        }
                        if (f11 > f2) {
                            f2 = f11;
                            this.right = pGNode;
                        }
                    }
                }
                pGNode.setBoundsHaveChanged(false);
            }
            if (!bl) {
                this.boundsInvalid = false;
                this.cachedBounds.setBounds(f7, f8, f2, f);
                return;
            }
        }
        float f13 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        boolean bl = true;
        for (int i = 0; i < this.content.size(); ++i) {
            PGNode pGNode = this.content.get(i);
            pGNode.setBoundsHaveChanged(false);
            if (!pGNode.isVisible()) continue;
            pGNode.getCompleteBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (this.tmp.isEmpty()) continue;
            f2 = this.tmp.x1;
            f = this.tmp.y1;
            float f14 = this.tmp.x2;
            float f15 = this.tmp.y2;
            if (bl) {
                this.bottom = this.right = pGNode;
                this.left = this.right;
                this.top = this.right;
                f13 = f2;
                f5 = f;
                f4 = f14;
                f3 = f15;
                bl = false;
                continue;
            }
            if (f < f5) {
                f5 = f;
                this.top = pGNode;
            }
            if (f2 < f13) {
                f13 = f2;
                this.left = pGNode;
            }
            if (f15 > f3) {
                f3 = f15;
                this.bottom = pGNode;
            }
            if (!(f14 > f4)) continue;
            f4 = f14;
            this.right = pGNode;
        }
        this.boundsInvalid = false;
        if (bl) {
            this.right = null;
            this.bottom = null;
            this.left = null;
            this.top = null;
            this.cachedBounds.invalidate();
        } else {
            this.cachedBounds.setBounds(f13, f5, f4, f3);
        }
    }
}

