/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.desktop;

import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.ToolkitAccessor;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.animation.AnimationPulse;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class MasterTimer
extends AbstractMasterTimer {
    private static PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.nogaps")) {
                nogaps = Settings.getBoolean("com.sun.scenario.animation.nogaps");
            } else if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.fullspeed")) {
                fullspeed = Settings.getBoolean("com.sun.scenario.animation.fullspeed");
            } else if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.adaptivepulse")) {
                useAdaptivePulse = Settings.getBoolean("com.sun.scenario.animation.adaptivepulse");
            } else if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.hires")) {
                hires = Settings.getBoolean("com.sun.scenario.animation.hires");
                if (hires) {
                    MasterTimer.startHiResSleep();
                } else {
                    MasterTimer.stopHiResSleep();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.AnimationMBean.enabled")) {
                AnimationPulse.getDefaultBean().setEnabled(Settings.getBoolean("com.sun.scenario.animation.AnimationMBean.enabled"));
            }
        }
    };
    private static ReflectAppContext reflectInfo = null;
    private static LongSleepingThread hiResWorkaround;
    private static final Object MASTER_TIMER_KEY;

    private static void startHiResSleep() {
        hiResWorkaround = new LongSleepingThread();
        hiResWorkaround.start();
    }

    private static void stopHiResSleep() {
        if (hiResWorkaround != null) {
            hiResWorkaround.interrupt();
        }
        hiResWorkaround = null;
    }

    private MasterTimer() {
    }

    public static synchronized MasterTimer getInstance() {
        Map<Object, Object> map = ToolkitAccessor.getContextMap();
        MasterTimer masterTimer = (MasterTimer)map.get(MASTER_TIMER_KEY);
        if (masterTimer == null) {
            masterTimer = new MasterTimer();
            map.put(MASTER_TIMER_KEY, masterTimer);
            if (Settings.getBoolean("com.sun.scenario.animation.AnimationMBean.enabled", false) && System.getSecurityManager() == null) {
                try {
                    MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                    ObjectName objectName = new ObjectName(":type=AnimationPulse");
                    AnimationPulse animationPulse = AnimationPulse.getDefaultBean();
                    animationPulse.setEnabled(true);
                    mBeanServer.registerMBean(animationPulse, objectName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return masterTimer;
    }

    protected boolean shouldUseNanoTime() {
        boolean bl = false;
        try {
            System.nanoTime();
            bl = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return bl;
    }

    protected int getPulseDuration(int n) {
        int n2 = n / 60;
        if (Settings.get("javafx.animation.framerate") != null) {
            int n3 = Settings.getInt("javafx.animation.framerate", 60);
            if (n3 > 0) {
                n2 = n / n3;
            }
        } else if (Settings.get("com.sun.scenario.animation.pulse") != null) {
            int n4 = Settings.getInt("com.sun.scenario.animation.pulse", 60);
            if (n4 > 0) {
                n2 = n / n4;
            }
        } else {
            int n5 = ToolkitAccessor.getRefreshRate();
            if (n5 > 0) {
                n2 = n / n5;
            }
        }
        return n2;
    }

    protected void postUpdateAnimationRunnable(DelayedRunnable delayedRunnable) {
        ToolkitAccessor.setAnimationRunnable(delayedRunnable);
    }

    static void timePulse(long l) {
        MasterTimer.getInstance().timePulseImpl(l);
    }

    protected void recordStart(long l) {
        AnimationPulse.getDefaultBean().recordStart(l);
    }

    protected void recordEnd() {
        AnimationPulse.getDefaultBean().recordEnd();
    }

    protected void recordAnimationEnd() {
        AnimationPulse.getDefaultBean().recordAnimationEnd();
    }

    static {
        Settings.addPropertyChangeListener("com.sun.scenario.animation.nogaps", pcl);
        Settings.addPropertyChangeListener("com.sun.scenario.animation.adaptivepulse", pcl);
        Settings.addPropertyChangeListener("com.sun.scenario.animation.fullspeed", pcl);
        Settings.addPropertyChangeListener("com.sun.scenario.animation.hires", pcl);
        Settings.addPropertyChangeListener("com.sun.scenario.animation.AnimationMBean.enabled", pcl);
        hires = Settings.getBoolean("com.sun.scenario.animation.hires", hires);
        if (hires) {
            MasterTimer.startHiResSleep();
        }
        MASTER_TIMER_KEY = new StringBuilder("MasterTimerKey");
    }

    private static class LongSleepingThread
    extends Thread {
        public LongSleepingThread() {
            super("Long sleeping thread");
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!hires) {
                        return;
                    }
                    Boolean bl = Boolean.FALSE;
                    if (reflectInfo == null) {
                        reflectInfo = new ReflectAppContext();
                        AccessController.doPrivileged(reflectInfo);
                    }
                    if (reflectInfo.clazz == null || reflectInfo.getAppCtx == null || reflectInfo.isDisposed == null) continue;
                    try {
                        Object object = reflectInfo.getAppCtx.invoke((Object)reflectInfo.clazz, (Object[])null);
                        bl = (Boolean)reflectInfo.isDisposed.invoke(object, (Object[])null);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    if (!bl.booleanValue()) continue;
                    return;
                }
                break;
            }
        }
    }

    private static class ReflectAppContext
    implements PrivilegedAction {
        Class clazz = null;
        Method getAppCtx = null;
        Method isDisposed = null;

        private ReflectAppContext() {
        }

        public Object run() {
            try {
                this.clazz = Class.forName("sun.awt.AppContext", true, null);
                this.getAppCtx = this.clazz.getDeclaredMethod("getAppContext", null);
                this.isDisposed = this.clazz.getDeclaredMethod("isDisposed", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }
    }
}

