/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.scene.transfer.Clipboard;
import com.sun.javafx.scene.transfer.UTI;
import com.sun.javafx.tk.swing.UtiTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javafx.scene.image.Image;

class SwingTransferableUtils {
    SwingTransferableUtils() {
    }

    public static Transferable createDefaultTransferable(final Clipboard clipboard) {
        return new UtiTransferable(clipboard){

            public Object getTransferData(DataFlavor dataFlavor) {
                if (clipboard.hasImage()) {
                    Image image = (Image)clipboard.getContent(UTI.IMAGE);
                    return image.impl_getPlatformImage();
                }
                return clipboard.getContent(clipboard.getContentType());
            }
        };
    }

    public static Transferable createDefaultTransferable(UTI uTI, Object object) {
        return new UtiTransferable(uTI, object);
    }

    public static Transferable createImageTransferable(final Image image) {
        return new UtiTransferable(UTI.IMAGE){

            public Object getTransferData(DataFlavor dataFlavor) {
                if (!dataFlavor.equals(DataFlavor.imageFlavor)) {
                    return null;
                }
                return image.impl_getPlatformImage();
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(DataFlavor.imageFlavor);
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }
        };
    }
}

