/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd;

import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDParser;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;

public abstract class FXDExpression {
    public final String className;

    protected FXDExpression(String string) {
        this.className = string;
    }

    public boolean isEnumeration() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public static FXDExpression parse(String string, FXDParser fXDParser) throws FXDException {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        int n2 = string.indexOf(40, n);
        if (n2 == -1) {
            return new Enum(string2, string.substring(n + 1));
        }
        String string3 = string.substring(n + 1, n2);
        n = string.lastIndexOf(41);
        if (n == -1) {
            throw new FXDSyntaxErrorException("Unclosed function call; missing the right ')'", fXDParser.getPosition());
        }
        String string4 = string.substring(n2 + 1, n);
        Object[] objectArray = ContainerUtils.tokenizeToValues(string4, ",", fXDParser);
        return new Function(string2, string3, objectArray, string);
    }

    public static final class Enum
    extends FXDExpression {
        public final String varName;

        private Enum(String string, String string2) {
            super(string);
            this.varName = string2;
        }

        public boolean isEnumeration() {
            return true;
        }

        public String toString() {
            return this.className + "." + this.varName;
        }
    }

    public static final class Function
    extends FXDExpression {
        private final String str;
        public final String methodName;
        public final Object[] args;

        private Function(String string, String string2, Object[] objectArray, String string3) {
            super(string);
            this.methodName = string2;
            this.args = objectArray;
            this.str = string3;
        }

        public boolean isFunction() {
            return true;
        }

        public int getArgCount() {
            return this.args.length;
        }

        public float getArgNumber(int n) {
            return ContainerUtils.parseNumber(this.args[n]);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.className);
            stringBuilder.append(".");
            stringBuilder.append(this.methodName);
            stringBuilder.append("(");
            String string = "";
            for (Object object : this.args) {
                stringBuilder.append(string);
                stringBuilder.append(object);
                string = ",";
            }
            stringBuilder.append(") [");
            stringBuilder.append(this.str);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

