/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.scene.fxd;

import com.sun.javafx.tools.fxd.FXDArrayElement;
import com.sun.javafx.tools.fxd.FXDElement;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import com.sun.javafx.tools.fxd.container.scene.fxd.MutableFXDObjectElement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class FXDNodeImpl
implements MutableFXDObjectElement {
    private static final int FLAG_LEAF = 1;
    private static final Enumeration NO_NAMES = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public String nextElement() {
            throw new NoSuchElementException();
        }
    };
    protected String m_typeName;
    protected final Map<String, Object> m_attrs;
    protected Map<String, Object> m_metaData = null;
    protected byte m_flags;
    protected int m_refID = -1;
    protected DocumentParser m_docParser;

    FXDNodeImpl(String string, DocumentParser documentParser) {
        this.m_typeName = string;
        this.m_attrs = new HashMap<String, Object>(10);
        this.m_flags = 1;
        this.m_docParser = documentParser;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public int getAttrNum() {
        return this.m_attrs.size();
    }

    public Object getAttrValue(String string) {
        return this.m_attrs.get(string);
    }

    public Enumeration getAttrNames() {
        int n = this.getAttrNum();
        if (n == 0) {
            return NO_NAMES;
        }
        final Iterator<String> iterator = this.m_attrs.keySet().iterator();
        return new Enumeration(){
            private Object m_name;
            {
                this.m_name = iterator.next();
            }

            public boolean hasMoreElements() {
                return this.m_name != null;
            }

            public Object nextElement() {
                Object object = this.m_name;
                this.m_name = iterator.hasNext() ? iterator.next() : null;
                return object;
            }
        };
    }

    public int getMetaNum() {
        return this.m_metaData == null ? 0 : this.m_metaData.size();
    }

    public Object getMetaValue(String string) {
        if (this.m_metaData != null) {
            return this.m_metaData.get(string);
        }
        return null;
    }

    public Enumeration getMetaKeys() {
        int n = this.getMetaNum();
        if (n == 0) {
            return NO_NAMES;
        }
        final Iterator<String> iterator = this.m_metaData.keySet().iterator();
        return new Enumeration(){
            private Object m_key;
            {
                this.m_key = iterator.next();
            }

            public boolean hasMoreElements() {
                return this.m_key != null;
            }

            public Object nextElement() {
                Object object = this.m_key;
                this.m_key = iterator.hasNext() ? iterator.next() : null;
                return object;
            }
        };
    }

    public void release() {
        this.m_docParser = null;
    }

    public int getKind() {
        return 0;
    }

    public boolean isLeaf() {
        return this.implIsLeaf();
    }

    public Enumeration children() {
        final Iterator<Object> iterator = this.m_attrs.values().iterator();
        return new Enumeration(){
            private FXDElement m_elem = this.advance();

            public boolean hasMoreElements() {
                return this.m_elem != null;
            }

            public FXDElement nextElement() {
                if (this.m_elem == null) {
                    throw new NoSuchElementException();
                }
                FXDElement fXDElement = this.m_elem;
                this.m_elem = this.advance();
                return fXDElement;
            }

            private FXDElement advance() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof FXDElement)) continue;
                    return (FXDElement)e;
                }
                return null;
            }
        };
    }

    public synchronized int getReferenceID() {
        return this.m_refID;
    }

    public synchronized void setReferenceID(int n) {
        this.m_refID = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_typeName != null ? this.m_typeName : "null");
        stringBuffer.append("{");
        for (Map.Entry<String, Object> entry : this.m_attrs.entrySet()) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append(":");
            Object object = entry.getValue();
            if (object == null) {
                stringBuffer.append("null");
            } else if (object instanceof FXDArrayElement) {
                stringBuffer.append("[...]");
            } else if (object instanceof FXDObjectElement) {
                stringBuffer.append("{...}");
            } else {
                stringBuffer.append(object);
            }
            stringBuffer.append(",");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    void addAttribute(String string, Object object) {
        if (!this.m_attrs.containsKey(string)) {
            this.m_attrs.put(string, object);
            if (this.implIsLeaf() && object instanceof FXDElement) {
                this.implSetLeaf(false);
            }
        }
    }

    void addMetaData(String string, Object object) {
        if (this.m_metaData == null) {
            this.m_metaData = new HashMap<String, Object>(4);
        }
        this.m_metaData.put(string, object);
    }

    void completed() throws FXDSyntaxErrorException {
        this.m_docParser.getLoadContext().getPool().processValues(this.m_docParser.getCurrentContainer(), this);
    }

    protected final boolean implIsLeaf() {
        return this.getFlag(1);
    }

    protected final void implSetLeaf(boolean bl) {
        this.setFlag(1, bl);
    }

    private boolean getFlag(int n) {
        return (this.m_flags & n) != 0;
    }

    private final void setFlag(int n, boolean bl) {
        this.m_flags = (byte)(this.m_flags | n);
        if (!bl) {
            this.m_flags = (byte)(this.m_flags ^ n);
        }
    }

    public void setAttrValue(String string, Object object) {
        this.m_attrs.put(string, object);
    }
}

